/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.spark.sv.evidence;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.broadinstitute.hellbender.tools.spark.sv.evidence.QNameAndInterval;
import org.broadinstitute.hellbender.tools.spark.sv.evidence.SVReadFilter;
import org.broadinstitute.hellbender.tools.spark.sv.utils.SVFastqUtils;
import org.broadinstitute.hellbender.tools.spark.utils.HopscotchUniqueMultiMap;
import org.broadinstitute.hellbender.utils.read.GATKRead;
import scala.Tuple2;

public final class ReadsForQNamesFinder
implements Iterable<Tuple2<Integer, List<SVFastqUtils.FastqRead>>> {
    private final List<Tuple2<Integer, List<SVFastqUtils.FastqRead>>> fastQRecords;

    public ReadsForQNamesFinder(HopscotchUniqueMultiMap<String, Integer, QNameAndInterval> qNamesMultiMap, int nIntervals, boolean includeMappingLocation, Iterator<GATKRead> unfilteredReadItr, SVReadFilter filter) {
        int nReadsPerInterval = 2 * qNamesMultiMap.size() / nIntervals;
        List[] intervalReads = new List[nIntervals];
        int nPopulatedIntervals = 0;
        Iterator<GATKRead> readItr = filter.applyFilter(unfilteredReadItr, SVReadFilter::isPrimaryLine);
        while (readItr.hasNext()) {
            GATKRead read = readItr.next();
            Iterator namesItr = qNamesMultiMap.findEach(read.getName());
            if (!namesItr.hasNext()) continue;
            SVFastqUtils.FastqRead fastqRead = new SVFastqUtils.FastqRead(read, includeMappingLocation);
            do {
                int intervalId;
                if (intervalReads[intervalId = ((QNameAndInterval)namesItr.next()).getIntervalId()] == null) {
                    intervalReads[intervalId] = new ArrayList(nReadsPerInterval);
                    ++nPopulatedIntervals;
                }
                intervalReads[intervalId].add(fastqRead);
            } while (namesItr.hasNext());
        }
        this.fastQRecords = new ArrayList<Tuple2<Integer, List<SVFastqUtils.FastqRead>>>(nPopulatedIntervals);
        if (nPopulatedIntervals > 0) {
            for (int idx = 0; idx != nIntervals; ++idx) {
                List readList = intervalReads[idx];
                if (readList == null) continue;
                this.fastQRecords.add((Tuple2<Integer, List<SVFastqUtils.FastqRead>>)new Tuple2((Object)idx, (Object)readList));
            }
        }
    }

    @Override
    public Iterator<Tuple2<Integer, List<SVFastqUtils.FastqRead>>> iterator() {
        return this.fastQRecords.iterator();
    }
}

