/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.spark.sv.evidence;

import java.io.Serializable;
import java.util.Iterator;
import java.util.function.BiPredicate;
import org.broadinstitute.hellbender.tools.spark.sv.StructuralVariationDiscoveryArgumentCollection;
import org.broadinstitute.hellbender.tools.spark.sv.evidence.ReadMetadata;
import org.broadinstitute.hellbender.tools.spark.sv.utils.SVInterval;
import org.broadinstitute.hellbender.tools.spark.sv.utils.SVIntervalTree;
import org.broadinstitute.hellbender.tools.spark.sv.utils.SVUtils;
import org.broadinstitute.hellbender.utils.read.CigarUtils;
import org.broadinstitute.hellbender.utils.read.GATKRead;

public class SVReadFilter
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final int minEvidenceMapQ;
    private final int minEvidenceMatchLength;
    private final int allowedShortFragmentOverhang;
    private final int maxDUSTScore;
    private final int kSize;

    public SVReadFilter(StructuralVariationDiscoveryArgumentCollection.FindBreakpointEvidenceSparkArgumentCollection params) {
        this.minEvidenceMapQ = params.minEvidenceMapQ;
        this.minEvidenceMatchLength = params.minEvidenceMatchLength;
        this.allowedShortFragmentOverhang = params.allowedShortFragmentOverhang;
        this.maxDUSTScore = params.maxDUSTScore;
        this.kSize = params.kSize;
    }

    public boolean notJunk(GATKRead read) {
        return !read.isDuplicate() && !read.failsVendorQualityCheck();
    }

    public boolean isPrimaryLine(GATKRead read) {
        return !read.isSecondaryAlignment() && !read.isSupplementaryAlignment();
    }

    public boolean isMapped(GATKRead read) {
        return this.notJunk(read) && !read.isUnmapped();
    }

    public boolean isMappedPrimary(GATKRead read) {
        return this.isMapped(read) && this.isPrimaryLine(read);
    }

    public boolean isEvidence(GATKRead read) {
        return this.isMapped(read) && read.getMappingQuality() >= this.minEvidenceMapQ && CigarUtils.countAlignedBases(read.getCigar()) >= this.minEvidenceMatchLength && !read.isSecondaryAlignment();
    }

    public boolean isMappedToPrimaryContig(GATKRead read, ReadMetadata readMetadata) {
        if (!this.isMapped(read)) {
            return false;
        }
        int contigID = readMetadata.getContigID(read.getContig());
        return !readMetadata.getCrossContigIgnoreSet().contains(contigID);
    }

    public boolean isTemplateLenTestable(GATKRead read) {
        return this.isEvidence(read) && this.isPrimaryLine(read) && !read.mateIsUnmapped() && !read.isReverseStrand() && read.mateIsReverseStrand() && read.getContig().equals(read.getMateContig()) && read.getStart() - this.allowedShortFragmentOverhang <= read.getMateStart();
    }

    public boolean containedInRegionToIgnore(SVInterval interval, SVIntervalTree<SVInterval> regionsToIgnore) {
        Iterator<SVIntervalTree.Entry<SVInterval>> overlappers = regionsToIgnore.overlappers(interval);
        while (overlappers.hasNext()) {
            SVIntervalTree.Entry<SVInterval> depthFilteredInterval = overlappers.next();
            if (depthFilteredInterval.getInterval().overlapLen(interval) != interval.getLength()) continue;
            return true;
        }
        return false;
    }

    public Iterator<GATKRead> applyFilter(Iterator<GATKRead> readItr, BiPredicate<SVReadFilter, GATKRead> predicate) {
        return new SVUtils.IteratorFilter<GATKRead>(readItr, read -> predicate.test(this, (GATKRead)read));
    }

    public int getMinEvidenceMapQ() {
        return this.minEvidenceMapQ;
    }

    public int getMinEvidenceMatchLength() {
        return this.minEvidenceMatchLength;
    }

    public int getAllowedShortFragmentOverhang() {
        return this.allowedShortFragmentOverhang;
    }
}

