/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.spark.sv.evidence;

import org.broadinstitute.hellbender.utils.Utils;
import org.broadinstitute.hellbender.utils.read.GATKRead;

public enum TemplateFragmentOrdinal {
    UNPAIRED(""),
    PAIRED_UNKNOWN("/?"),
    PAIRED_FIRST("/1"),
    PAIRED_SECOND("/2"),
    PAIRED_INTERIOR("/0");

    private final String nameSuffix;

    private TemplateFragmentOrdinal(String nameSuffix) {
        this.nameSuffix = nameSuffix;
    }

    public String toString() {
        return this.nameSuffix;
    }

    public String nameSuffix() {
        return this.nameSuffix;
    }

    public static TemplateFragmentOrdinal forRead(GATKRead read) {
        Utils.nonNull(read);
        if (read.isPaired()) {
            if (read.isFirstOfPair()) {
                return read.isSecondOfPair() ? PAIRED_INTERIOR : PAIRED_FIRST;
            }
            return read.isSecondOfPair() ? PAIRED_SECOND : PAIRED_UNKNOWN;
        }
        return UNPAIRED;
    }
}

