/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.spark.sv.utils;

import htsjdk.samtools.SAMFileHeader;
import htsjdk.variant.variantcontext.Genotype;
import htsjdk.variant.variantcontext.VariantContext;
import htsjdk.variant.variantcontext.VariantContextBuilder;
import htsjdk.variant.vcf.VCFHeader;
import java.util.ArrayList;
import org.broadinstitute.hellbender.engine.FeatureDataSource;
import org.broadinstitute.hellbender.tools.spark.sv.utils.SVInterval;
import org.broadinstitute.hellbender.tools.spark.sv.utils.SVIntervalTree;
import org.broadinstitute.hellbender.tools.spark.sv.utils.SVUtils;
import org.broadinstitute.hellbender.utils.Utils;
import scala.Tuple2;

public class CNVInputReader {
    public static SVIntervalTree<VariantContext> loadCNVCalls(String cnvCallsFile, SAMFileHeader headerForReads) {
        Utils.validate(cnvCallsFile != null, "Can't load null CNV calls file");
        try (FeatureDataSource<VariantContext> dataSource = new FeatureDataSource<VariantContext>(cnvCallsFile, null, 0, null);){
            String sampleId = SVUtils.getSampleId(headerForReads);
            CNVInputReader.validateCNVcallDataSource(headerForReads, sampleId, dataSource);
            SVIntervalTree<VariantContext> cnvCallTree = new SVIntervalTree<VariantContext>();
            Utils.stream(dataSource.iterator()).map(vc -> new VariantContextBuilder(vc).genotypes(new Genotype[]{vc.getGenotype(sampleId)}).make()).map(vc -> new Tuple2((Object)new SVInterval(headerForReads.getSequenceIndex(vc.getContig()), vc.getStart(), vc.getEnd()), vc)).forEach(pv -> {
                VariantContext cfr_ignored_0 = (VariantContext)cnvCallTree.put((SVInterval)pv._1(), (VariantContext)pv._2());
            });
            SVIntervalTree<VariantContext> sVIntervalTree = cnvCallTree;
            return sVIntervalTree;
        }
    }

    private static void validateCNVcallDataSource(SAMFileHeader headerForReads, String sampleId, FeatureDataSource<VariantContext> dataSource) {
        VCFHeader cnvCallHeader = (VCFHeader)dataSource.getHeader();
        ArrayList sampleNamesInOrder = cnvCallHeader.getSampleNamesInOrder();
        Utils.validate(sampleNamesInOrder.size() == 1, "CNV call VCF should be single sample");
        Utils.validate(sampleNamesInOrder.contains(sampleId), "CNV call VCF does not contain calls for sample " + sampleId);
        Utils.validate(cnvCallHeader.getSequenceDictionary() != null, "CNV calls file does not have a valid sequence dictionary");
        Utils.validate(cnvCallHeader.getSequenceDictionary().isSameDictionary(headerForReads.getSequenceDictionary()), "CNV calls file does not have the same sequence dictionary as the read evidence");
    }
}

