/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.spark.sv.utils;

import java.util.Arrays;
import org.apache.spark.Partitioner;

public final class ComplexityPartitioner
extends Partitioner {
    private static final long serialVersionUID = 1L;
    private final int[] partitions;

    public ComplexityPartitioner(int[] complexities) {
        int idx;
        Integer[] tags = new Integer[complexities.length];
        for (idx = 0; idx != tags.length; ++idx) {
            tags[idx] = idx;
        }
        Arrays.sort(tags, (a, b) -> Integer.compare(complexities[b], complexities[a]));
        this.partitions = new int[complexities.length];
        for (idx = 0; idx != tags.length; ++idx) {
            this.partitions[tags[idx].intValue()] = idx;
        }
    }

    public int numPartitions() {
        return this.partitions.length;
    }

    public int getPartition(Object key) {
        return this.partitions[(Integer)key];
    }
}

