/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.spark.sv.utils;

import com.google.common.base.Throwables;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.FileUtils;

abstract class ExternalCommandlineProgramModule {
    public abstract String getModuleName();

    public abstract List<String> initializeCommands(Path var1);

    public RuntimeInfo run(Path pathToProgram, File directoryToWorkIn, List<String> runtimeArguments, boolean enableSTDIOCapture, String ... workingEnvironmentArgs) {
        List<String> commands = this.initializeCommands(pathToProgram);
        if (null != runtimeArguments && !runtimeArguments.isEmpty()) {
            commands.addAll(runtimeArguments);
        }
        ProcessBuilder builder = new ProcessBuilder(commands);
        this.setupWorkingEnvironment(builder, workingEnvironmentArgs);
        if (null != directoryToWorkIn) {
            builder.directory(directoryToWorkIn);
        }
        try {
            File stderrFile;
            File stdoutFile = enableSTDIOCapture ? Files.createTempFile("stdout", "log", new FileAttribute[0]).toFile() : null;
            File file = stderrFile = enableSTDIOCapture ? Files.createTempFile("stderr", "log", new FileAttribute[0]).toFile() : null;
            if (enableSTDIOCapture) {
                builder.redirectOutput(stdoutFile);
                builder.redirectError(stderrFile);
            }
            String out = "";
            String err = "";
            Process process = builder.start();
            int exitStatus = process.waitFor();
            if (enableSTDIOCapture) {
                try {
                    out = FileUtils.readFileToString((File)stdoutFile, (Charset)Charset.defaultCharset());
                    err = FileUtils.readFileToString((File)stderrFile, (Charset)Charset.defaultCharset());
                }
                catch (IOException ex) {
                    return new RuntimeInfo(this.getModuleName(), RuntimeInfo.ReturnStatus.STDIOFAIL, null, ex.getMessage());
                }
            }
            if (0 != exitStatus) {
                return new RuntimeInfo(this.getModuleName(), RuntimeInfo.ReturnStatus.PGFAIL, null, "Program returned exit status " + exitStatus + "\n" + String.join((CharSequence)" ", commands) + "\n" + out + "\n" + err);
            }
            return new RuntimeInfo(this.getModuleName(), RuntimeInfo.ReturnStatus.SUCCESS, out, err);
        }
        catch (IOException e) {
            return new RuntimeInfo(this.getModuleName(), RuntimeInfo.ReturnStatus.STARTFAIL, null, e.getMessage() + Throwables.getStackTraceAsString((Throwable)e));
        }
        catch (InterruptedException e) {
            return new RuntimeInfo(this.getModuleName(), RuntimeInfo.ReturnStatus.INTERRUPTION, null, e.getMessage() + Throwables.getStackTraceAsString((Throwable)e));
        }
    }

    protected void setupWorkingEnvironment(ProcessBuilder builder, String ... args) {
    }

    @Deprecated
    private static void exampleRun(String sgaPathString, String moduleName, File workingDir, boolean enableSTDIOCapture) {
        Path sgaPath = Paths.get(sgaPathString, new String[0]);
        SGAModule module = new SGAModule(moduleName);
        ArrayList<String> moduleArgs = new ArrayList<String>();
        moduleArgs.add("--algorithm");
        moduleArgs.add("ropebwt");
        moduleArgs.add("--check");
        moduleArgs.add("");
        RuntimeInfo moduleRuntimeInfo = module.run(sgaPath, workingDir, moduleArgs, enableSTDIOCapture, new String[0]);
        RuntimeInfo.ReturnStatus returnStatus = moduleRuntimeInfo.returnStatus;
        if (!returnStatus.equals((Object)RuntimeInfo.ReturnStatus.SUCCESS)) {
            throw new RuntimeException("Appropriate action and error message here");
        }
    }

    @Deprecated
    private static final class SGAModule
    extends ExternalCommandlineProgramModule {
        private final String moduleName;

        SGAModule(String moduleName) {
            this.moduleName = moduleName;
        }

        @Override
        public String getModuleName() {
            return "sga " + this.moduleName;
        }

        @Override
        public List<String> initializeCommands(Path pathToSGA) {
            ArrayList<String> result = new ArrayList<String>();
            result.add(pathToSGA.toString());
            result.add(this.moduleName);
            return result;
        }
    }

    public static final class RuntimeInfo
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public final ReturnStatus returnStatus;
        public final String stdoutMsg;
        public final String stderrMsg;
        public final String moduleName;

        public RuntimeInfo(String moduleName, ReturnStatus status, String stdoutMsg, String stderrMsg) {
            this.moduleName = moduleName;
            this.returnStatus = status;
            this.stdoutMsg = stdoutMsg;
            this.stderrMsg = stderrMsg;
        }

        public String toString() {
            String result = this.moduleName + "\t";
            switch (this.returnStatus) {
                case STARTFAIL: {
                    result = result + " failed to start.\n";
                    break;
                }
                case INTERRUPTION: {
                    result = result + " was interrupted.\n";
                    break;
                }
                case STDIOFAIL: {
                    result = result + " stdout and stderr wasn't successfully captured.\n";
                    break;
                }
                case PGFAIL: {
                    result = result + " returned with non-zero exit status, see stderr message for detailed return status.\n";
                    break;
                }
                default: {
                    result = result + " successfully executed.\n";
                }
            }
            result = result + " Module stdout message: \n";
            result = result + (null != this.stdoutMsg ? this.stdoutMsg + "\n" : "is empty\n");
            result = result + " Module stderr message: \n";
            result = result + (null != this.stderrMsg ? this.stderrMsg + "\n" : "is empty\n");
            return result;
        }

        public static enum ReturnStatus {
            SUCCESS,
            STARTFAIL,
            INTERRUPTION,
            STDIOFAIL,
            PGFAIL;

        }
    }
}

