/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.spark.sv.utils;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.api.java.function.Function;
import org.apache.spark.broadcast.Broadcast;
import org.broadinstitute.barclay.argparser.Argument;
import org.broadinstitute.barclay.argparser.BetaFeature;
import org.broadinstitute.barclay.argparser.CommandLineProgramProperties;
import org.broadinstitute.barclay.help.DocumentedFeature;
import org.broadinstitute.hellbender.engine.spark.GATKSparkTool;
import org.broadinstitute.hellbender.exceptions.GATKException;
import org.broadinstitute.hellbender.utils.gcs.BucketUtils;
import org.broadinstitute.hellbender.utils.read.GATKRead;
import picard.cmdline.programgroups.ReadDataManipulationProgramGroup;

@DocumentedFeature
@BetaFeature
@CommandLineProgramProperties(oneLineSummary="Subsets reads by name", summary="Reads a file of read (i.e., template) names, and searches a SAM/BAM/CRAM to find names that match. The matching reads are copied to an output file. Unlike FilterSamReads (Picard), this tool can take input reads in any order (e.g., unsorted or coordinate-sorted).", programGroup=ReadDataManipulationProgramGroup.class)
public final class ExtractOriginalAlignmentRecordsByNameSpark
extends GATKSparkTool {
    private static final long serialVersionUID = 1L;
    @Argument(doc="file containing list of read names", shortName="f", fullName="read-name-file")
    private String readNameFile;
    @Argument(doc="invert the list, i.e. filter out reads whose name appear in the given file", shortName="v", fullName="invert-match", optional=true)
    private Boolean invertFilter = false;
    @Argument(doc="file to write reads to", shortName="O", fullName="output")
    private String outputSAM;

    @Override
    public boolean requiresReads() {
        return true;
    }

    @Override
    protected void runTool(JavaSparkContext ctx) {
        Broadcast namesToLookForBroadcast = ctx.broadcast(this.parseReadNames());
        Function<GATKRead, Boolean> predicate = ExtractOriginalAlignmentRecordsByNameSpark.getGatkReadBooleanFunction((Broadcast<Set<String>>)namesToLookForBroadcast, this.invertFilter);
        JavaRDD reads = this.getUnfilteredReads().filter(predicate).cache();
        this.writeReads(ctx, this.outputSAM, (JavaRDD<GATKRead>)reads, this.getHeaderForReads(), false);
        this.logger.info("Found " + reads.count() + " alignment records for " + ((Set)namesToLookForBroadcast.getValue()).size() + " unique read names.");
    }

    private static Function<GATKRead, Boolean> getGatkReadBooleanFunction(Broadcast<Set<String>> namesToLookForBroadcast, boolean invertFilter) {
        return invertFilter ? (Function & Serializable)read -> !((Set)namesToLookForBroadcast.getValue()).contains(read.getName()) : (Function & Serializable)read -> ((Set)namesToLookForBroadcast.getValue()).contains(read.getName());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Set<String> parseReadNames() {
        try (BufferedReader rdr = new BufferedReader(new InputStreamReader(BucketUtils.openFile(this.readNameFile)));){
            Set set = rdr.lines().map(s -> s.replaceAll("^@", "").replaceAll("/1$", "").replaceAll("/2$", "")).collect(Collectors.toCollection(HashSet::new));
            return set;
        }
        catch (IOException ioe) {
            throw new GATKException("Unable to read names file from " + this.readNameFile, ioe);
        }
    }
}

