/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.spark.sv.utils;

import htsjdk.variant.vcf.VCFFilterHeaderLine;
import htsjdk.variant.vcf.VCFFormatHeaderLine;
import htsjdk.variant.vcf.VCFHeaderLineCount;
import htsjdk.variant.vcf.VCFHeaderLineType;
import htsjdk.variant.vcf.VCFInfoHeaderLine;
import htsjdk.variant.vcf.VCFSimpleHeaderLine;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.broadinstitute.hellbender.utils.Utils;

public final class GATKSVVCFHeaderLines {
    private static final Map<String, VCFInfoHeaderLine> infoLines = new LinkedHashMap<String, VCFInfoHeaderLine>(30);
    private static final Map<String, VCFFormatHeaderLine> formatLines = new LinkedHashMap<String, VCFFormatHeaderLine>(5);
    private static final Map<String, VCFFilterHeaderLine> filterLines = new LinkedHashMap<String, VCFFilterHeaderLine>(4);
    private static final Map<String, VCFSimpleHeaderLine> symbAltAlleleLines = new LinkedHashMap<String, VCFSimpleHeaderLine>(10);

    public static VCFInfoHeaderLine getInfoLine(String id) {
        return infoLines.get(id);
    }

    public static Set<VCFInfoHeaderLine> getInfoLines() {
        return new HashSet<VCFInfoHeaderLine>(infoLines.values());
    }

    public static VCFFormatHeaderLine getFormatLine(String id) {
        return formatLines.get(id);
    }

    public static Set<VCFFormatHeaderLine> getFormatLines() {
        return new HashSet<VCFFormatHeaderLine>(formatLines.values());
    }

    public static VCFFilterHeaderLine getFilterLine(String id) {
        return filterLines.get(id);
    }

    public static Set<VCFFilterHeaderLine> getFilterLines() {
        return new HashSet<VCFFilterHeaderLine>(filterLines.values());
    }

    private static void addFormatLine(VCFFormatHeaderLine line) {
        Utils.nonNull(line);
        formatLines.put(line.getID(), line);
    }

    private static void addInfoLine(VCFInfoHeaderLine line) {
        Utils.nonNull(line);
        infoLines.put(line.getID(), line);
    }

    private static void addFilterLine(VCFFilterHeaderLine line) {
        Utils.nonNull(line);
        filterLines.put(line.getID(), line);
    }

    public static VCFSimpleHeaderLine getSymbAltAlleleLine(String id) {
        return symbAltAlleleLines.get(id);
    }

    public static Set<VCFSimpleHeaderLine> getSymbAltAlleleLines() {
        return new HashSet<VCFSimpleHeaderLine>(symbAltAlleleLines.values());
    }

    private static void addSymbAltAlleleLine(VCFSimpleHeaderLine line) {
        Utils.nonNull(line);
        symbAltAlleleLines.put(line.getID(), line);
    }

    static {
        GATKSVVCFHeaderLines.addSymbAltAlleleLine(new VCFSimpleHeaderLine("ALT", "INV", "Inversion of reference sequence"));
        GATKSVVCFHeaderLines.addSymbAltAlleleLine(new VCFSimpleHeaderLine("ALT", "DEL", "Deletion relative to the reference"));
        GATKSVVCFHeaderLines.addSymbAltAlleleLine(new VCFSimpleHeaderLine("ALT", "INS", "Insertion of novel sequence relative to the reference"));
        GATKSVVCFHeaderLines.addSymbAltAlleleLine(new VCFSimpleHeaderLine("ALT", "DUP", "Region of elevated copy number relative to the reference"));
        GATKSVVCFHeaderLines.addSymbAltAlleleLine(new VCFSimpleHeaderLine("ALT", "DUP:INV", "Region of elevated copy number relative to the reference, with some copies inverted"));
        GATKSVVCFHeaderLines.addSymbAltAlleleLine(new VCFSimpleHeaderLine("ALT", "CPX", "Complex rearrangement of reference sequence"));
        GATKSVVCFHeaderLines.addInfoLine(new VCFInfoHeaderLine("SVTYPE", 1, VCFHeaderLineType.String, "Type of structural variant"));
        GATKSVVCFHeaderLines.addInfoLine(new VCFInfoHeaderLine("SVLEN", VCFHeaderLineCount.UNBOUNDED, VCFHeaderLineType.Integer, "Difference in length between REF and ALT alleles"));
        GATKSVVCFHeaderLines.addInfoLine(new VCFInfoHeaderLine("SEQ_ALT_HAPLOTYPE", VCFHeaderLineCount.A, VCFHeaderLineType.Character, "Alt haplotype sequence, one per alt allele"));
        GATKSVVCFHeaderLines.addInfoLine(new VCFInfoHeaderLine("INSSEQ", VCFHeaderLineCount.UNBOUNDED, VCFHeaderLineType.String, "Inserted sequence at the breakpoint"));
        GATKSVVCFHeaderLines.addInfoLine(new VCFInfoHeaderLine("INSLEN", VCFHeaderLineCount.A, VCFHeaderLineType.Integer, "Length of inserted sequence (note for duplication records, this does not count the extra copies of the duplicated sequence)"));
        GATKSVVCFHeaderLines.addInfoLine(new VCFInfoHeaderLine("INSSEQ_MAP", VCFHeaderLineCount.UNBOUNDED, VCFHeaderLineType.String, "Alignments of inserted sequence"));
        GATKSVVCFHeaderLines.addInfoLine(new VCFInfoHeaderLine("HOMSEQ", VCFHeaderLineCount.UNBOUNDED, VCFHeaderLineType.String, "Sequence of base pair identical micro-homology at event breakpoints"));
        GATKSVVCFHeaderLines.addInfoLine(new VCFInfoHeaderLine("HOMLEN", 1, VCFHeaderLineType.Integer, "Length of base pair identical micro-homology at event breakpoints"));
        GATKSVVCFHeaderLines.addInfoLine(new VCFInfoHeaderLine("READ_PAIR_SUPPORT", 1, VCFHeaderLineType.Integer, "Number of discordant read pairs supporting the variant"));
        GATKSVVCFHeaderLines.addInfoLine(new VCFInfoHeaderLine("SPLIT_READ_SUPPORT", 1, VCFHeaderLineType.Integer, "Number of split read supplementary mappings supporting the variant"));
        GATKSVVCFHeaderLines.addInfoLine(new VCFInfoHeaderLine("EXTERNAL_CNV_CALLS", 1, VCFHeaderLineType.String, "Comma-delimited list of external copy number calls that overlap with this variant in format ID:CN:CNQ"));
        GATKSVVCFHeaderLines.addInfoLine(new VCFInfoHeaderLine("LINK", VCFHeaderLineCount.UNBOUNDED, VCFHeaderLineType.String, "ID(s) of other record(s) linked to current record"));
        GATKSVVCFHeaderLines.addInfoLine(new VCFInfoHeaderLine("CTG_NAMES", VCFHeaderLineCount.UNBOUNDED, VCFHeaderLineType.String, "Name of local assembly contigs supporting this variant, formatted as \"asm%06d:tig%05d\""));
        GATKSVVCFHeaderLines.addInfoLine(new VCFInfoHeaderLine("TOTAL_MAPPINGS", 1, VCFHeaderLineType.Integer, "Number of local assembly contigs supporting the variant, i.e. number of entries in CTG_NAMES"));
        GATKSVVCFHeaderLines.addInfoLine(new VCFInfoHeaderLine("MAPPING_QUALITIES", VCFHeaderLineCount.UNBOUNDED, VCFHeaderLineType.Integer, "Mapping qualities of the contig alignments that support the variant"));
        GATKSVVCFHeaderLines.addInfoLine(new VCFInfoHeaderLine("HQ_MAPPINGS", 1, VCFHeaderLineType.Integer, "Number of high-quality contig alignments that support the variant"));
        GATKSVVCFHeaderLines.addInfoLine(new VCFInfoHeaderLine("ALIGN_LENGTHS", VCFHeaderLineCount.UNBOUNDED, VCFHeaderLineType.Integer, "Minimum lengths of the flanking aligned region from each contig alignment"));
        GATKSVVCFHeaderLines.addInfoLine(new VCFInfoHeaderLine("MAX_ALIGN_LENGTH", 1, VCFHeaderLineType.Integer, "Maximum of the values listed in ALIGN_LENGTHS"));
        GATKSVVCFHeaderLines.addInfoLine(new VCFInfoHeaderLine("CTG_GOOD_NONCANONICAL_MAPPING", VCFHeaderLineCount.UNBOUNDED, VCFHeaderLineType.String, "Good mapping of evidence contigs as listed in CTG_NAMES to non-canonical reference chromosomes that could potentially offer better explanation of the assembly contig without the SV record. One for each evidence assembly contig, if available; otherwise a \".\". If no evidence contig has such mapping, this annotation is omitted for the record."));
        GATKSVVCFHeaderLines.addInfoLine(new VCFInfoHeaderLine("LINK", VCFHeaderLineCount.UNBOUNDED, VCFHeaderLineType.String, "ID(s) of other variants that are linked to this record, i.e. they constitute a larger more complex variant"));
        GATKSVVCFHeaderLines.addInfoLine(new VCFInfoHeaderLine("MATEID", VCFHeaderLineCount.UNBOUNDED, VCFHeaderLineType.String, "ID(s) for mate(s) of a BND record"));
        GATKSVVCFHeaderLines.addInfoLine(new VCFInfoHeaderLine("IMPRECISE", 0, VCFHeaderLineType.Flag, "Imprecise structural variation"));
        GATKSVVCFHeaderLines.addInfoLine(new VCFInfoHeaderLine("CIPOS", 2, VCFHeaderLineType.Integer, "Confidence interval around POS for imprecise variants"));
        GATKSVVCFHeaderLines.addInfoLine(new VCFInfoHeaderLine("CIEND", 2, VCFHeaderLineType.Integer, "Confidence interval around END for imprecise variants"));
        GATKSVVCFHeaderLines.addInfoLine(new VCFInfoHeaderLine("INV33", 0, VCFHeaderLineType.Flag, "Whether the event represents a 3' to 5' breakpoint"));
        GATKSVVCFHeaderLines.addInfoLine(new VCFInfoHeaderLine("INV55", 0, VCFHeaderLineType.Flag, "Whether the event represents a 5' to 3' breakpoint"));
        GATKSVVCFHeaderLines.addInfoLine(new VCFInfoHeaderLine("DUP_REPEAT_UNIT_REF_SPAN", 1, VCFHeaderLineType.String, "Reference span of the suspected repeated unit in a tandem duplication"));
        GATKSVVCFHeaderLines.addInfoLine(new VCFInfoHeaderLine("DUP_SEQ_CIGARS", VCFHeaderLineCount.UNBOUNDED, VCFHeaderLineType.String, "CIGARs of the repeated sequence on the locally-assembled contigs when aligned to DUP_REPEAT_UNIT_REF_SPAN (currently only available for repeats when DUP_ANNOTATIONS_IMPRECISE is false)"));
        GATKSVVCFHeaderLines.addInfoLine(new VCFInfoHeaderLine("DUP_NUM", VCFHeaderLineCount.R, VCFHeaderLineType.Integer, "Number of times the sequence is duplicated on reference and on the alternate alleles"));
        GATKSVVCFHeaderLines.addInfoLine(new VCFInfoHeaderLine("DUP_ANNOTATIONS_IMPRECISE", 0, VCFHeaderLineType.Flag, "Whether the duplication annotations are from an experimental optimization procedure"));
        GATKSVVCFHeaderLines.addInfoLine(new VCFInfoHeaderLine("DUP_IMPRECISE_AFFECTED_RANGE", VCFHeaderLineCount.UNBOUNDED, VCFHeaderLineType.String, "Affected reference range for duplications annotated with the flag DUP_ANNOTATIONS_IMPRECISE"));
        GATKSVVCFHeaderLines.addInfoLine(new VCFInfoHeaderLine("DUP_ORIENTATIONS", VCFHeaderLineCount.A, VCFHeaderLineType.String, "Orientations of the duplicated sequence on alt allele relative to the copy on ref; one group for each alt allele (currently only available for inverted duplication variants)"));
        GATKSVVCFHeaderLines.addInfoLine(new VCFInfoHeaderLine("CONTRACTION", 0, VCFHeaderLineType.Flag, "Tandem repeats contraction compared to reference"));
        GATKSVVCFHeaderLines.addInfoLine(new VCFInfoHeaderLine("EXPANSION", 0, VCFHeaderLineType.Flag, "Tandem repeats expansion compared to reference"));
        GATKSVVCFHeaderLines.addInfoLine(new VCFInfoHeaderLine("ALT_ARRANGEMENT", VCFHeaderLineCount.UNBOUNDED, VCFHeaderLineType.String, "For CPX variants only; specifies how reference segments given in SEGMENTS are re-arranged"));
        GATKSVVCFHeaderLines.addInfoLine(new VCFInfoHeaderLine("SEGMENTS", VCFHeaderLineCount.UNBOUNDED, VCFHeaderLineType.String, "For CPX variants only; segments of reference that are rearranged"));
        GATKSVVCFHeaderLines.addInfoLine(new VCFInfoHeaderLine("CPX_EVENT", VCFHeaderLineCount.UNBOUNDED, VCFHeaderLineType.String, "ID(s) of CPX(s) events from which current simple variant record is extracted"));
        GATKSVVCFHeaderLines.addFormatLine(new VCFFormatHeaderLine("CN", 1, VCFHeaderLineType.Integer, "Copy number genotype for imprecise events"));
        GATKSVVCFHeaderLines.addFormatLine(new VCFFormatHeaderLine("CNQ", 1, VCFHeaderLineType.Float, "Copy number genotype quality for imprecise events"));
        GATKSVVCFHeaderLines.addFilterLine(new VCFFilterHeaderLine("LOW_MQ", "Assembly evidence based record that whose maximum value specified in MAPPING_QUALITIES is lower than user specified threshold"));
        GATKSVVCFHeaderLines.addFilterLine(new VCFFilterHeaderLine("SHORT_ALN", "Assembly evidence based record that whose MAPPING_QUALITIES value is lower than user specified threshold"));
        GATKSVVCFHeaderLines.addFilterLine(new VCFFilterHeaderLine("LOW_QS", "Depth-only copy number record whose QS value is lower than user specified threshold"));
        GATKSVVCFHeaderLines.addFilterLine(new VCFFilterHeaderLine("FREQ", "Depth-only copy number record whose AF value is higher than user specified threshold"));
    }
}

