/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.spark.sv.utils;

import com.esotericsoftware.kryo.DefaultSerializer;
import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import com.google.common.annotations.VisibleForTesting;
import java.util.Map;
import org.broadinstitute.hellbender.tools.spark.sv.utils.SVKmer;
import org.broadinstitute.hellbender.tools.spark.sv.utils.SVKmerLong;
import org.broadinstitute.hellbender.utils.Utils;

@DefaultSerializer(value=Serializer.class)
@VisibleForTesting
public final class KmerAndCount
extends SVKmerLong
implements Map.Entry<SVKmer, Integer> {
    private int count;

    public KmerAndCount(SVKmerLong kmer) {
        this(kmer, 1);
    }

    public KmerAndCount(SVKmerLong kmer, int count) {
        super(Utils.nonNull(kmer));
        Utils.validateArg(count >= 0, "initializing count is negative: " + count);
        this.count = count;
    }

    private KmerAndCount(Kryo kryo, Input input) {
        super(kryo, input);
        this.count = input.readInt();
    }

    @Override
    protected void serialize(Kryo kryo, Output output) {
        super.serialize(kryo, output);
        output.writeInt(this.count);
    }

    @Override
    public SVKmer getKey() {
        return new SVKmerLong(this);
    }

    @Override
    public Integer getValue() {
        return this.count;
    }

    @Override
    public Integer setValue(Integer count) {
        Integer result = this.count;
        this.count = count;
        return result;
    }

    public int grabCount() {
        return this.count;
    }

    public void bumpCount() {
        ++this.count;
    }

    public void bumpCount(int extra) {
        this.count += extra;
    }

    public static final class Serializer
    extends com.esotericsoftware.kryo.Serializer<KmerAndCount> {
        public void write(Kryo kryo, Output output, KmerAndCount kmerAndInterval) {
            kmerAndInterval.serialize(kryo, output);
        }

        public KmerAndCount read(Kryo kryo, Input input, Class<KmerAndCount> klass) {
            return new KmerAndCount(kryo, input);
        }
    }
}

