/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.spark.sv.utils;

import com.esotericsoftware.kryo.DefaultSerializer;
import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import java.util.Collections;
import java.util.Iterator;
import org.broadinstitute.hellbender.tools.spark.sv.utils.PairedStrandedIntervals;
import org.broadinstitute.hellbender.tools.spark.sv.utils.SVIntervalTree;
import org.broadinstitute.hellbender.tools.spark.sv.utils.StrandedInterval;
import org.broadinstitute.hellbender.utils.Utils;
import scala.Tuple2;

@DefaultSerializer(value=Serializer.class)
public class PairedStrandedIntervalTree<V>
implements Iterable<Tuple2<PairedStrandedIntervals, V>> {
    private SVIntervalTree<Tuple2<Boolean, SVIntervalTree<Tuple2<Boolean, V>>>> leftEnds = new SVIntervalTree();

    public PairedStrandedIntervalTree() {
    }

    public PairedStrandedIntervalTree(Kryo kryo, Input input) {
        this.leftEnds = (SVIntervalTree)kryo.readClassAndObject(input);
    }

    public boolean put(PairedStrandedIntervals pair, V value) {
        if (this.contains(pair)) {
            return false;
        }
        SVIntervalTree.Entry<Tuple2<Boolean, SVIntervalTree<Tuple2<Boolean, V>>>> leftEntry = this.leftEnds.find(pair.getLeft().getInterval());
        if (leftEntry != null) {
            ((SVIntervalTree)leftEntry.getValue()._2()).put(pair.getRight().getInterval(), new Tuple2((Object)pair.getRight().getStrand(), value));
        } else {
            SVIntervalTree<Tuple2> rightEnds = new SVIntervalTree<Tuple2>();
            rightEnds.put(pair.getRight().getInterval(), new Tuple2((Object)pair.getRight().getStrand(), value));
            this.leftEnds.put(pair.getLeft().getInterval(), new Tuple2((Object)pair.getLeft().getStrand(), rightEnds));
        }
        return true;
    }

    public int size() {
        return Utils.stream(this.leftEnds).mapToInt(e -> ((SVIntervalTree)((Tuple2)e.getValue())._2).size()).sum();
    }

    public Iterator<Tuple2<PairedStrandedIntervals, V>> overlappers(PairedStrandedIntervals pair) {
        return new PairedStrandedIntervalTreeOverlapperIterator(this, pair);
    }

    @Override
    public Iterator<Tuple2<PairedStrandedIntervals, V>> iterator() {
        return new PairedStrandedIntervalTreeIterator(this);
    }

    public boolean contains(PairedStrandedIntervals pair) {
        int leftEndIndex = this.leftEnds.getIndex(pair.getLeft().getInterval());
        if (leftEndIndex == -1) {
            return false;
        }
        SVIntervalTree.Entry<Tuple2<Boolean, SVIntervalTree<Tuple2<Boolean, V>>>> leftEndEntry = this.leftEnds.findByIndex(leftEndIndex);
        Tuple2<Boolean, SVIntervalTree<Tuple2<Boolean, V>>> storedValue = leftEndEntry.getValue();
        if (pair.getLeft().getStrand() != ((Boolean)storedValue._1()).booleanValue()) {
            return false;
        }
        SVIntervalTree rightEnds = (SVIntervalTree)storedValue._2();
        int rightIndex = rightEnds.getIndex(pair.getRight().getInterval());
        return rightIndex != -1 && pair.getRight().getStrand() == ((Boolean)((Tuple2)rightEnds.findByIndex(rightIndex).getValue())._1()).booleanValue();
    }

    private void serialize(Kryo kryo, Output output) {
        kryo.writeClassAndObject(output, (Object)this);
    }

    public static final class Serializer<T>
    extends com.esotericsoftware.kryo.Serializer<PairedStrandedIntervalTree<T>> {
        public void write(Kryo kryo, Output output, PairedStrandedIntervalTree<T> tree) {
            ((PairedStrandedIntervalTree)tree).serialize(kryo, output);
        }

        public PairedStrandedIntervalTree<T> read(Kryo kryo, Input input, Class<PairedStrandedIntervalTree<T>> klass) {
            return new PairedStrandedIntervalTree(kryo, input);
        }
    }

    public final class PairedStrandedIntervalTreeIterator
    implements Iterator<Tuple2<PairedStrandedIntervals, V>> {
        private final Iterator<SVIntervalTree.Entry<Tuple2<Boolean, SVIntervalTree<Tuple2<Boolean, V>>>>> leftEndIterator;
        private Iterator<SVIntervalTree.Entry<Tuple2<Boolean, V>>> rightEndIterator;
        private SVIntervalTree.Entry<Tuple2<Boolean, SVIntervalTree<Tuple2<Boolean, V>>>> leftEntry;

        PairedStrandedIntervalTreeIterator(PairedStrandedIntervalTree<V> tree) {
            this.leftEndIterator = tree.leftEnds.iterator();
            if (this.leftEndIterator.hasNext()) {
                this.leftEntry = this.leftEndIterator.next();
                this.rightEndIterator = ((SVIntervalTree)this.leftEntry.getValue()._2()).iterator();
            } else {
                this.leftEntry = null;
                this.rightEndIterator = Collections.emptyIterator();
            }
        }

        @Override
        public boolean hasNext() {
            return this.rightEndIterator.hasNext() || this.leftEndIterator.hasNext();
        }

        @Override
        public Tuple2<PairedStrandedIntervals, V> next() {
            if (!this.rightEndIterator.hasNext()) {
                this.leftEntry = this.leftEndIterator.next();
                this.rightEndIterator = ((SVIntervalTree)this.leftEntry.getValue()._2()).iterator();
            }
            SVIntervalTree.Entry rightEntry = this.rightEndIterator.next();
            return new Tuple2((Object)new PairedStrandedIntervals(new StrandedInterval(this.leftEntry.getInterval(), (Boolean)this.leftEntry.getValue()._1()), new StrandedInterval(rightEntry.getInterval(), (Boolean)rightEntry.getValue()._1())), rightEntry.getValue()._2());
        }

        @Override
        public void remove() {
            this.rightEndIterator.remove();
            if (((SVIntervalTree)this.leftEntry.getValue()._2()).size() == 0) {
                this.leftEndIterator.remove();
            }
        }
    }

    public final class PairedStrandedIntervalTreeOverlapperIterator
    implements Iterator<Tuple2<PairedStrandedIntervals, V>> {
        private Iterator<SVIntervalTree.Entry<Tuple2<Boolean, SVIntervalTree<Tuple2<Boolean, V>>>>> leftOverlappers;
        private Iterator<SVIntervalTree.Entry<Tuple2<Boolean, V>>> rightOverlappers;
        private SVIntervalTree.Entry<Tuple2<Boolean, SVIntervalTree<Tuple2<Boolean, V>>>> leftEntry;
        private SVIntervalTree.Entry<Tuple2<Boolean, V>> rightEntry;
        private final PairedStrandedIntervals query;

        public PairedStrandedIntervalTreeOverlapperIterator(PairedStrandedIntervalTree<V> tree, PairedStrandedIntervals query) {
            this.query = query;
            this.leftOverlappers = tree.leftEnds.overlappers(query.getLeft().getInterval());
        }

        private void advance(PairedStrandedIntervals query) {
            this.leftEntry = null;
            this.rightEntry = null;
            while (this.leftOverlappers.hasNext()) {
                this.leftEntry = this.leftOverlappers.next();
                if ((Boolean)this.leftEntry.getValue()._1() == false == query.getLeft().getStrand()) continue;
                this.rightOverlappers = ((SVIntervalTree)this.leftEntry.getValue()._2()).overlappers(query.getRight().getInterval());
                while (this.rightOverlappers.hasNext()) {
                    this.rightEntry = this.rightOverlappers.next();
                    if ((Boolean)this.rightEntry.getValue()._1() == false == query.getRight().getStrand()) continue;
                    return;
                }
            }
            this.rightEntry = null;
        }

        @Override
        public boolean hasNext() {
            this.advance(this.query);
            return this.leftEntry != null && this.rightEntry != null;
        }

        @Override
        public Tuple2<PairedStrandedIntervals, V> next() {
            Tuple2 nextVal = new Tuple2((Object)new PairedStrandedIntervals(new StrandedInterval(this.leftEntry.getInterval(), (Boolean)this.leftEntry.getValue()._1()), new StrandedInterval(this.rightEntry.getInterval(), (Boolean)this.rightEntry.getValue()._1())), this.rightEntry.getValue()._2);
            return nextVal;
        }

        @Override
        public void remove() {
            this.rightOverlappers.remove();
            if (((SVIntervalTree)this.leftEntry.getValue()._2()).size() == 0) {
                this.leftOverlappers.remove();
            }
        }
    }
}

