/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.spark.sv.utils;

import org.broadinstitute.hellbender.tools.spark.sv.utils.StrandedInterval;
import org.broadinstitute.hellbender.utils.Utils;

public final class PairedStrandedIntervals {
    final StrandedInterval left;
    final StrandedInterval right;

    public PairedStrandedIntervals(StrandedInterval left, StrandedInterval right) {
        Utils.validate(left != null, "Can't construct PairedStrandedInterval with a null left interval");
        Utils.validate(right != null, "Can't construct PairedStrandedInterval with a null right interval");
        this.left = left;
        this.right = right;
    }

    public StrandedInterval getLeft() {
        return this.left;
    }

    public StrandedInterval getRight() {
        return this.right;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PairedStrandedIntervals that = (PairedStrandedIntervals)o;
        if (!this.left.equals(that.left)) {
            return false;
        }
        return this.right.equals(that.right);
    }

    public int hashCode() {
        int result = this.left.hashCode();
        result = 31 * result + this.right.hashCode();
        return result;
    }
}

