/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.spark.sv.utils;

import htsjdk.samtools.Cigar;
import htsjdk.samtools.CigarElement;
import htsjdk.samtools.CigarOperator;
import htsjdk.samtools.SAMSequenceDictionary;
import htsjdk.samtools.SAMSequenceRecord;
import htsjdk.variant.variantcontext.Allele;
import htsjdk.variant.variantcontext.StructuralVariantType;
import htsjdk.variant.variantcontext.VariantContext;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.broadinstitute.hellbender.engine.spark.datasources.ReferenceMultiSparkSource;
import org.broadinstitute.hellbender.exceptions.GATKException;
import org.broadinstitute.hellbender.tools.spark.sv.evidence.ReadMetadata;
import org.broadinstitute.hellbender.tools.spark.sv.utils.PairedStrandedIntervals;
import org.broadinstitute.hellbender.tools.spark.sv.utils.SVInterval;
import org.broadinstitute.hellbender.tools.spark.sv.utils.StrandedInterval;
import org.broadinstitute.hellbender.utils.SimpleInterval;
import org.broadinstitute.hellbender.utils.Utils;
import org.broadinstitute.hellbender.utils.haplotype.Haplotype;
import org.broadinstitute.hellbender.utils.param.ParamUtils;
import org.broadinstitute.hellbender.utils.reference.ReferenceBases;

public final class SVContext
extends VariantContext {
    private static final long serialVersionUID = 1L;
    private static final int MISSING_END = -2;
    private static final int MISSING_LENGTH = -2;
    public static final int NO_LENGTH = -1;
    private int end = -2;
    private int length = -2;

    public static SVContext of(VariantContext vc) {
        if (vc instanceof SVContext) {
            return (SVContext)vc;
        }
        SVContext.assertIsStructuralVariantContext(vc);
        return new SVContext(vc);
    }

    private static void assertIsStructuralVariantContext(VariantContext vc) {
        Utils.nonNull(vc, "the input variant context must not be null");
        Utils.nonNull(vc.getStructuralVariantType(), "the input variant-context is not structural; the SVTYPE annotation is missing");
        if (vc.getNAlleles() != 2) {
            throw new IllegalArgumentException("structural variant context must be biallelic");
        }
        if (((Allele)vc.getAlleles().get(0)).isNonReference()) {
            throw new IllegalArgumentException("the allele with index 0 must be reference");
        }
        if (((Allele)vc.getAlleles().get(1)).isReference()) {
            throw new IllegalArgumentException("the allele with index 1 must be non-reference");
        }
    }

    private SVContext(VariantContext other) {
        super(other);
    }

    public int getEnd() {
        if (this.end == -2) {
            this.end = this.getAttributeAsInt("END", -2);
            if (this.end == -2) {
                this.end = this.getStructuralVariantType() == StructuralVariantType.DEL ? this.getStart() + this.getStructuralVariantLength() : super.getEnd();
            }
        }
        return this.end;
    }

    public List<String> getSupportingContigIds() {
        if (!this.hasAttribute("CTG_NAMES")) {
            return Collections.emptyList();
        }
        List result = this.getAttributeAsStringList("CTG_NAMES", null);
        if (result.contains(null)) {
            throw new IllegalStateException("the contig names annotation contains undefined values");
        }
        return result;
    }

    public Haplotype composeHaplotypeBasedOnReference(int index, int paddingSize, ReferenceMultiSparkSource reference) {
        ReferenceBases bases;
        Utils.nonNull(reference, "the input reference cannot be null");
        ParamUtils.isPositiveOrZero(paddingSize, "the input padding must be 0 or greater");
        ParamUtils.inRange(index, 0, 1, "the input allele index must be 0 or 1");
        SAMSequenceDictionary dictionary = reference.getReferenceSequenceDictionary(null);
        Utils.nonNull(dictionary, "the input reference does not have a dictionary");
        SAMSequenceRecord contigRecord = dictionary.getSequence(this.getContig());
        Utils.nonNull(contigRecord, "the input reference does not have a contig named: " + this.getContig());
        int contigLength = contigRecord.getSequenceLength();
        if (contigLength < this.getEnd()) {
            throw new IllegalArgumentException(String.format("this variant goes beyond the end of the containing contig based on the input reference: contig %s length is %d but variant end is %d", this.getContig(), contigLength, this.getEnd()));
        }
        SimpleInterval referenceInterval = SVContext.composePaddedInterval(this.getContig(), contigLength, this.getStart(), this.getEnd(), paddingSize);
        try {
            bases = reference.getReferenceBases(referenceInterval);
        }
        catch (IOException ex) {
            throw new GATKException("could not read reference file");
        }
        if (index == 0) {
            Haplotype result = new Haplotype(bases.getBases(), true);
            result.setCigar(new Cigar(Collections.singletonList(new CigarElement(referenceInterval.size(), CigarOperator.M))));
            result.setGenomeLocation(referenceInterval);
            return result;
        }
        switch (this.getStructuralVariantType()) {
            case INS: {
                return this.composeInsertionHaplotype(bases);
            }
            case DEL: {
                return this.composeDeletionHaplotype(bases);
            }
        }
        throw new UnsupportedOperationException("not supported yet");
    }

    private Haplotype composeDeletionHaplotype(ReferenceBases referenceBases) {
        int deletionSize = this.getStructuralVariantLength();
        byte[] resultBases = new byte[referenceBases.getInterval().size() - deletionSize];
        int leftPaddingSize = this.getStart() - referenceBases.getInterval().getStart() + 1;
        int rightPaddingSize = referenceBases.getInterval().getEnd() - this.getStart() - deletionSize;
        byte[] referenceBaseBytes = referenceBases.getBases();
        System.arraycopy(referenceBaseBytes, 0, resultBases, 0, leftPaddingSize);
        System.arraycopy(referenceBaseBytes, leftPaddingSize + deletionSize, resultBases, leftPaddingSize, rightPaddingSize);
        Cigar cigar = new Cigar(Arrays.asList(new CigarElement(leftPaddingSize, CigarOperator.M), new CigarElement(deletionSize, CigarOperator.D), new CigarElement(rightPaddingSize, CigarOperator.M)));
        Haplotype result = new Haplotype(resultBases, false);
        result.setCigar(cigar);
        result.setGenomeLocation(referenceBases.getInterval());
        return result;
    }

    private Haplotype composeInsertionHaplotype(ReferenceBases referenceBases) {
        byte[] insertedSequence = this.getInsertedSequence();
        byte[] referenceBaseBytes = referenceBases.getBases();
        byte[] resultBases = new byte[referenceBases.getInterval().size() + insertedSequence.length];
        int leftPaddingSize = this.getStart() - referenceBases.getInterval().getStart() + 1;
        int rightPaddingSize = referenceBases.getInterval().getEnd() - this.getStart();
        System.arraycopy(referenceBaseBytes, 0, resultBases, 0, leftPaddingSize);
        System.arraycopy(insertedSequence, 0, resultBases, leftPaddingSize, insertedSequence.length);
        System.arraycopy(referenceBaseBytes, leftPaddingSize, resultBases, leftPaddingSize + insertedSequence.length, rightPaddingSize);
        Cigar cigar = new Cigar(Arrays.asList(new CigarElement(leftPaddingSize, CigarOperator.M), new CigarElement(insertedSequence.length, CigarOperator.I), new CigarElement(rightPaddingSize, CigarOperator.M)));
        Haplotype result = new Haplotype(resultBases, false);
        result.setCigar(cigar);
        result.setGenomeLocation(referenceBases.getInterval());
        return result;
    }

    public byte[] getInsertedSequence() {
        if (this.hasAttribute("INSSEQ")) {
            String asString = this.getAttributeAsString("INSSEQ", null);
            return asString == null ? null : asString.getBytes();
        }
        return null;
    }

    public int getStructuralVariantLength() {
        if (this.length == -2) {
            this.length = Math.abs(this.getAttributeAsInt("SVLEN", -1));
        }
        return this.length;
    }

    public List<SimpleInterval> getBreakPointIntervals(int padding, SAMSequenceDictionary dictionary, boolean padForHomology) {
        ParamUtils.isPositiveOrZero(padding, "the input padding must be 0 or greater");
        Utils.nonNull(dictionary, "the input dictionary cannot be null");
        String contigName = this.getContig();
        int contigLength = dictionary.getSequence(contigName).getSequenceLength();
        StructuralVariantType type = this.getStructuralVariantType();
        int start = this.getStart();
        if (type == StructuralVariantType.INS) {
            return Collections.singletonList(SVContext.composePaddedInterval(contigName, contigLength, start, start, padding));
        }
        if (type == StructuralVariantType.DEL) {
            int end = this.getEnd();
            int homologyPadding = padForHomology ? this.getAttributeAsInt("HOMLEN", 0) : 0;
            return Arrays.asList(SVContext.composePaddedInterval(contigName, contigLength, start + 1, start + 1 + homologyPadding, padding), SVContext.composePaddedInterval(contigName, contigLength, end, end + homologyPadding, padding));
        }
        throw new UnsupportedOperationException("currently only supported for INS and DELs");
    }

    private static SimpleInterval composePaddedInterval(String contig, int contigSize, int start, int end, int padding) {
        return new SimpleInterval(contig, Math.max(1, padding > 0 ? start - padding + 1 : start), Math.min(contigSize, end + padding));
    }

    public PairedStrandedIntervals getPairedStrandedIntervals(ReadMetadata metadata, SAMSequenceDictionary referenceSequenceDictionary, int padding) {
        StructuralVariantType type = this.getStructuralVariantType();
        if (type == StructuralVariantType.DEL) {
            List<SimpleInterval> breakPointIntervals = this.getBreakPointIntervals(padding, referenceSequenceDictionary, true);
            SimpleInterval leftBreakpointSimpleInterval = breakPointIntervals.get(0);
            SVInterval leftBreakpointInterval = new SVInterval(metadata.getContigID(leftBreakpointSimpleInterval.getContig()), leftBreakpointSimpleInterval.getStart(), leftBreakpointSimpleInterval.getEnd() + 1);
            SimpleInterval rightBreakpointSimpleInterval = breakPointIntervals.get(1);
            SVInterval rightBreakpointInterval = new SVInterval(metadata.getContigID(rightBreakpointSimpleInterval.getContig()), rightBreakpointSimpleInterval.getStart(), rightBreakpointSimpleInterval.getEnd() + 1);
            return new PairedStrandedIntervals(new StrandedInterval(leftBreakpointInterval, true), new StrandedInterval(rightBreakpointInterval, false));
        }
        throw new UnsupportedOperationException("currently only supported for DELs");
    }
}

