/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.spark.sv.utils;

import java.util.stream.Stream;
import org.broadinstitute.hellbender.exceptions.GATKException;
import org.broadinstitute.hellbender.tools.spark.sv.utils.SVKmer;
import org.broadinstitute.hellbender.tools.spark.sv.utils.SVKmerizer;
import org.broadinstitute.hellbender.utils.Utils;

public class SVDUSTFilteredKmerizer
extends SVKmerizer {
    private final int maxDUSTScore;
    private final int[] trimerCounts;
    private int curDUSTScore;

    public SVDUSTFilteredKmerizer(byte[] seq, int kSize, int maxDUSTScore, SVKmer kmer) {
        this(new SVKmerizer.ASCIICharSequence(seq), kSize, maxDUSTScore, kmer);
    }

    public SVDUSTFilteredKmerizer(CharSequence seq, int kSize, int maxDUSTScore, SVKmer kmer) {
        super(kSize, seq);
        int polyACount;
        if (kSize < 4) {
            throw new GATKException("kmer size must be at least 4 for this filter to work properly.");
        }
        this.maxDUSTScore = maxDUSTScore;
        this.trimerCounts = new int[64];
        this.trimerCounts[0] = polyACount = kSize - 2;
        this.curDUSTScore = polyACount * (polyACount - 1) / 2;
        this.nextKmer = this.nextKmer(kmer, 0);
    }

    public static Stream<SVKmer> stream(CharSequence seq, int kSize, int maxDUSTScore, SVKmer kmer) {
        return Utils.stream(new SVDUSTFilteredKmerizer(seq, kSize, maxDUSTScore, kmer));
    }

    public static Stream<SVKmer> stream(byte[] seq, int kSize, int maxDUSTScore, SVKmer kmer) {
        return Utils.stream(new SVDUSTFilteredKmerizer(seq, kSize, maxDUSTScore, kmer));
    }

    public static Stream<SVKmer> canonicalStream(CharSequence seq, int kSize, int maxDUSTScore, SVKmer kmer) {
        return SVDUSTFilteredKmerizer.stream(seq, kSize, maxDUSTScore, kmer).map(km -> km.canonical(kSize));
    }

    public static Stream<SVKmer> canonicalStream(byte[] seq, int kSize, int maxDUSTScore, SVKmer kmer) {
        return SVDUSTFilteredKmerizer.stream(seq, kSize, maxDUSTScore, kmer).map(km -> km.canonical(kSize));
    }

    @Override
    protected SVKmer nextKmer(SVKmer initialKmer, int validBaseCount) {
        int len = this.seq.length();
        SVKmer result = initialKmer;
        while (this.idx < len) {
            int n = result.firstTrimer(this.kSize);
            int n2 = this.trimerCounts[n] - 1;
            this.trimerCounts[n] = n2;
            this.curDUSTScore -= n2;
            switch (this.seq.charAt(this.idx)) {
                case 'A': 
                case 'a': {
                    result = result.successor(SVKmer.Base.A, this.kSize);
                    break;
                }
                case 'C': 
                case 'c': {
                    result = result.successor(SVKmer.Base.C, this.kSize);
                    break;
                }
                case 'G': 
                case 'g': {
                    result = result.successor(SVKmer.Base.G, this.kSize);
                    break;
                }
                case 'T': 
                case 't': {
                    result = result.successor(SVKmer.Base.T, this.kSize);
                    break;
                }
                default: {
                    result = result.successor(SVKmer.Base.A, this.kSize);
                    validBaseCount = -1;
                }
            }
            int n3 = result.lastTrimer();
            int n4 = this.trimerCounts[n3];
            this.trimerCounts[n3] = n4 + 1;
            this.curDUSTScore += n4;
            ++this.idx;
            if (++validBaseCount < this.kSize || this.curDUSTScore > this.maxDUSTScore) continue;
            return result;
        }
        return null;
    }
}

