/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.spark.sv.utils;

import com.esotericsoftware.kryo.DefaultSerializer;
import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.Serializer;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import com.netflix.servo.util.VisibleForTesting;
import htsjdk.samtools.Cigar;
import htsjdk.samtools.CigarOperator;
import htsjdk.samtools.SAMTag;
import htsjdk.samtools.SAMUtils;
import htsjdk.samtools.util.Locatable;
import htsjdk.samtools.util.SequenceUtil;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.broadinstitute.hellbender.exceptions.GATKException;
import org.broadinstitute.hellbender.exceptions.UserException;
import org.broadinstitute.hellbender.tools.spark.sv.discovery.alignment.AlignmentInterval;
import org.broadinstitute.hellbender.tools.spark.sv.evidence.TemplateFragmentOrdinal;
import org.broadinstitute.hellbender.utils.Utils;
import org.broadinstitute.hellbender.utils.fermi.FermiLiteAssembler;
import org.broadinstitute.hellbender.utils.gcs.BucketUtils;
import org.broadinstitute.hellbender.utils.read.GATKRead;

public class SVFastqUtils {
    public static final char HEADER_PREFIX_CHR = '@';
    public static final char FRAGMENT_NUMBER_SEPARATOR_CHR = '/';
    public static final char HEADER_FIELD_SEPARATOR_CHR = '\t';
    public static final String HEADER_FIELD_SEPARATOR_REGEXP = "\\t";
    public static final char HEADER_FIELD_EQUAL_CHR = '=';
    public static final String HEADER_FIELD_LIST_SEPARATOR_STR = ";";
    private static final char LINE_SEPARATOR_CHR = '+';
    private static final String MAPPING_FIELD_NAME = "mapping";
    private static final String UNMAPPED_STR = "*";
    private static final String HEADER_FIELD_SEPARATOR_STR = "\t";
    private static final String MAPPING_FIELD_EQUAL_TO = "mapping=";
    private static final String UNMAPPED_DESCRIPTION_STR = "mapping=*";
    private static final Pattern FASTQ_READ_HEADER_PATTERN = Pattern.compile("^@([^\\t]+)(\\t(.*))?$");
    private static final Pattern SA_TAG_ALN_INTERVAL_SEPARATOR_PATTERN = Pattern.compile(";");

    public static List<FastqRead> readFastqFile(String fileName) {
        List<FastqRead> reads;
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(BucketUtils.openFile(fileName)));){
            reads = SVFastqUtils.readFastqStream(reader, fileName);
        }
        catch (IOException ioe) {
            throw new GATKException("Can't read " + fileName, ioe);
        }
        return reads;
    }

    public static List<FastqRead> readFastqStream(BufferedReader reader, String fileName) throws IOException {
        String header;
        int INITIAL_CAPACITY = 10000;
        ArrayList<FastqRead> reads = new ArrayList<FastqRead>(10000);
        int lineNo = 0;
        while ((header = reader.readLine()) != null) {
            ++lineNo;
            if (!FASTQ_READ_HEADER_PATTERN.matcher(header).find()) {
                throw new GATKException("In FASTQ file " + fileName + " sequence identifier line does not start with @ on line " + lineNo);
            }
            String callLine = reader.readLine();
            ++lineNo;
            if (callLine == null) {
                throw new GATKException("In FASTQ file " + fileName + " file truncated: missing calls.");
            }
            String sepLine = reader.readLine();
            ++lineNo;
            if (sepLine == null) {
                throw new GATKException("In FASTQ file " + fileName + " file truncated: missing + line.");
            }
            if (sepLine.length() < 1 || sepLine.charAt(0) != '+') {
                throw new GATKException("In FASTQ file " + fileName + " separator line does not start with + on line " + lineNo);
            }
            String qualLine = reader.readLine();
            ++lineNo;
            if (qualLine == null) {
                throw new UserException.BadInput("In FASTQ file " + fileName + " file truncated: missing quals.");
            }
            if (callLine.length() != qualLine.length()) {
                throw new UserException.BadInput("In FASTQ file " + fileName + " there are " + qualLine.length() + " quality scores on line " + lineNo + " but there are " + callLine.length() + " base calls.");
            }
            byte[] quals = qualLine.getBytes();
            SAMUtils.fastqToPhred((byte[])quals);
            byte[] calls = callLine.getBytes();
            reads.add(new FastqRead(header, calls, quals));
        }
        return reads;
    }

    public static String readToFastqSeqId(GATKRead read, boolean includeMappingLocation) {
        String description;
        String nameSuffix = TemplateFragmentOrdinal.forRead(read).nameSuffix();
        if (includeMappingLocation) {
            Mapping mapping = new Mapping(read);
            description = '\t' + Mapping.toString(read);
        } else {
            description = "";
        }
        return read.getName() + nameSuffix + '\t' + description;
    }

    public static void writeFastqFile(String fileName, Iterator<FastqRead> fastqReadItr) {
        try (BufferedOutputStream writer = new BufferedOutputStream(BucketUtils.createFile(fileName));){
            SVFastqUtils.writeFastqStream(writer, fastqReadItr);
        }
        catch (IOException ioe) {
            throw new GATKException("Can't write " + fileName, ioe);
        }
    }

    public static void writeFastqStream(OutputStream writer, Iterator<FastqRead> fastqReadItr) throws IOException {
        int index = 0;
        while (fastqReadItr.hasNext()) {
            FastqRead read = fastqReadItr.next();
            String header = read.getHeader();
            if (header.contains(" ")) {
                throw new IllegalStateException("Blank found: " + header);
            }
            if (header == null) {
                writer.write(Integer.toString(++index).getBytes());
            } else {
                writer.write(header.getBytes());
            }
            writer.write(10);
            writer.write(read.getBases());
            writer.write(10);
            writer.write(43);
            writer.write(10);
            byte[] quals = read.getQuals();
            int nQuals = quals.length;
            byte[] fastqQuals = new byte[nQuals];
            for (int idx = 0; idx != nQuals; ++idx) {
                fastqQuals[idx] = (byte)SAMUtils.phredToFastq((int)quals[idx]);
            }
            writer.write(fastqQuals);
            writer.write(10);
        }
    }

    @DefaultSerializer(value=Serializer.class)
    public static final class FastqRead
    implements FermiLiteAssembler.BasesAndQuals {
        private final String header;
        private final byte[] bases;
        private final byte[] quals;

        public FastqRead(GATKRead read) {
            this(read, true);
        }

        public FastqRead(GATKRead read, boolean includeMappingLocation) {
            this.header = FastqRead.composeHeaderLine(read, includeMappingLocation);
            this.bases = read.getBases();
            this.quals = read.getBaseQualities();
            if (!read.isUnmapped() && read.isReverseStrand()) {
                SequenceUtil.reverseComplement((byte[])this.bases);
                SequenceUtil.reverseQualities((byte[])this.quals);
            }
        }

        private static String composeHeaderLine(GATKRead read, boolean includeMappingLocation) {
            Utils.nonNull(read);
            return '@' + read.getName() + (Object)((Object)TemplateFragmentOrdinal.forRead(read)) + (includeMappingLocation ? "\tmapping=" + Mapping.toString(read) : "");
        }

        @VisibleForTesting
        FastqRead(String header, byte[] bases, byte[] quals) {
            this.header = header;
            this.bases = bases;
            this.quals = quals;
        }

        private FastqRead(Kryo kryo, Input input) {
            this.header = input.readString();
            int nBases = input.readInt();
            this.bases = new byte[nBases];
            input.readBytes(this.bases);
            this.quals = new byte[nBases];
            input.readBytes(this.quals);
        }

        public String getHeader() {
            return this.header;
        }

        public String getId() {
            String[] headerParts = this.header.split(SVFastqUtils.HEADER_FIELD_SEPARATOR_STR);
            return headerParts[0].substring(1);
        }

        public String getName() {
            String id = this.getId();
            int fragmentNumberSeparatorIndex = id.lastIndexOf(47);
            return fragmentNumberSeparatorIndex >= 0 ? id.substring(0, fragmentNumberSeparatorIndex) : id;
        }

        public String getDescription() {
            int tabIndex = this.header.indexOf(9);
            return tabIndex >= 0 ? this.header.substring(tabIndex + 1) : "";
        }

        public Mapping getMapping() {
            int mappingEqualToIndex = this.header.indexOf(SVFastqUtils.MAPPING_FIELD_EQUAL_TO);
            if (mappingEqualToIndex < 0) {
                return null;
            }
            int nextFieldSeperator = this.header.indexOf(SVFastqUtils.HEADER_FIELD_SEPARATOR_STR, mappingEqualToIndex);
            String mappingString = nextFieldSeperator < 0 ? this.header.substring(mappingEqualToIndex + SVFastqUtils.MAPPING_FIELD_EQUAL_TO.length()) : this.header.substring(mappingEqualToIndex + SVFastqUtils.MAPPING_FIELD_EQUAL_TO.length(), nextFieldSeperator);
            return new Mapping(mappingString);
        }

        public byte[] getBases() {
            return this.bases;
        }

        public byte[] getQuals() {
            return this.quals;
        }

        private void serialize(Kryo kryo, Output output) {
            output.writeAscii(this.header);
            output.writeInt(this.bases.length);
            output.writeBytes(this.bases);
            output.writeBytes(this.quals);
        }

        public static final class Serializer
        extends com.esotericsoftware.kryo.Serializer<FastqRead> {
            public void write(Kryo kryo, Output output, FastqRead read) {
                read.serialize(kryo, output);
            }

            public FastqRead read(Kryo kryo, Input input, Class<FastqRead> type) {
                return new FastqRead(kryo, input);
            }
        }
    }

    public static final class Mapping
    implements Locatable {
        final List<AlignmentInterval> intervals;

        public Mapping(String str) {
            Utils.nonNull(str);
            this.intervals = str.equals(SVFastqUtils.UNMAPPED_STR) ? Collections.emptyList() : Collections.unmodifiableList(SA_TAG_ALN_INTERVAL_SEPARATOR_PATTERN.splitAsStream(str).filter(s -> !s.isEmpty()).map(AlignmentInterval::new).collect(Collectors.toList()));
        }

        public Mapping(GATKRead read) {
            Utils.nonNull(read);
            if (read.isUnmapped()) {
                this.intervals = Collections.emptyList();
            } else if (!read.hasAttribute(SAMTag.SA.name())) {
                if (read.isSupplementaryAlignment()) {
                    throw new GATKException("a supplementary alignment read record must supply a SA tag. Perhaps this constraint isn't satisfied by the aligner used to produce the record");
                }
                this.intervals = Collections.singletonList(new AlignmentInterval(read));
            } else if (!read.isSupplementaryAlignment()) {
                this.intervals = !read.hasAttribute(SAMTag.SA.name()) ? Collections.singletonList(new AlignmentInterval(read)) : Collections.unmodifiableList(Stream.concat(Stream.of(new AlignmentInterval(read)), SA_TAG_ALN_INTERVAL_SEPARATOR_PATTERN.splitAsStream(read.getAttributeAsString(SAMTag.SA.name())).filter(s -> !s.isEmpty()).map(AlignmentInterval::new)).collect(Collectors.toList()));
            } else {
                List otherIntervals = SA_TAG_ALN_INTERVAL_SEPARATOR_PATTERN.splitAsStream(read.getAttributeAsString(SAMTag.SA.name())).filter(s -> !s.isEmpty()).map(AlignmentInterval::new).collect(Collectors.toList());
                if (otherIntervals.isEmpty()) {
                    throw new GATKException("the SA tag on a supplementary read record does not have alignments, perhaps this constraint is not satisfied by the aligner used to generate these records");
                }
                ArrayList<AlignmentInterval> newIntervals = new ArrayList<AlignmentInterval>(otherIntervals.size() + 1);
                AlignmentInterval readInterval = new AlignmentInterval(read);
                AlignmentInterval primaryInterval = (AlignmentInterval)otherIntervals.get(0);
                newIntervals.add(primaryInterval);
                newIntervals.add(readInterval);
                newIntervals.addAll(otherIntervals.subList(1, otherIntervals.size()));
                this.intervals = Collections.unmodifiableList(newIntervals);
            }
            if (!this.intervals.isEmpty() && this.intervals.get((int)0).cigarAlong5to3DirectionOfContig.containsOperator(CigarOperator.H)) {
                throw new GATKException("the interval/cigar of a non-supplementary record must not contain hard-clips, perhaps this constraint is not satisfied by the aligner used to generate these records");
            }
        }

        public boolean isMapped() {
            return !this.intervals.isEmpty();
        }

        public String getContig() {
            return this.isMapped() ? this.intervals.get((int)0).referenceSpan.getContig() : null;
        }

        public int getStart() {
            return this.isMapped() ? this.intervals.get((int)0).referenceSpan.getStart() : 0;
        }

        public int getEnd() {
            return this.isMapped() ? this.intervals.get((int)0).referenceSpan.getEnd() : 0;
        }

        public Cigar getCigar() {
            return this.isMapped() ? this.intervals.get(0).cigarAlongReference() : new Cigar();
        }

        public boolean isForwardStrand() {
            if (this.isMapped()) {
                return this.intervals.get((int)0).forwardStrand;
            }
            throw new UnsupportedOperationException("no forward or backward strand if unmapped");
        }

        public AlignmentInterval getPrimaryInterval() {
            return this.intervals.isEmpty() ? null : this.intervals.get(0);
        }

        public List<AlignmentInterval> getSupplementaryIntervals() {
            return this.intervals.isEmpty() ? this.intervals : this.intervals.subList(1, this.intervals.size());
        }

        public List<AlignmentInterval> getAllIntervals() {
            return this.intervals;
        }

        public static String toString(GATKRead read) {
            Utils.nonNull(read);
            if (read.isUnmapped() || read.getCigar().getPaddedReferenceLength() == 0) {
                return SVFastqUtils.UNMAPPED_STR;
            }
            StringBuilder builder = new StringBuilder(100);
            new AlignmentInterval(read).appendSATagString(builder);
            if (read.hasAttribute(SAMTag.SA.name())) {
                builder.append(SVFastqUtils.HEADER_FIELD_LIST_SEPARATOR_STR).append(read.getAttributeAsString(SAMTag.SA.name()));
            }
            if (builder.lastIndexOf(SVFastqUtils.HEADER_FIELD_LIST_SEPARATOR_STR) == builder.length() - 1) {
                builder.setLength(builder.length() - 1);
            }
            return builder.toString();
        }

        public String toString() {
            if (this.isMapped()) {
                StringBuilder builder = new StringBuilder(100);
                for (AlignmentInterval interval : this.intervals) {
                    interval.appendSATagString(builder).append(SVFastqUtils.HEADER_FIELD_LIST_SEPARATOR_STR);
                }
                builder.setLength(builder.length() - 1);
                return builder.toString();
            }
            return SVFastqUtils.UNMAPPED_STR;
        }
    }
}

