/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.spark.sv.utils;

import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMFileWriter;
import htsjdk.samtools.SAMFileWriterFactory;
import htsjdk.samtools.SAMRecord;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.UncheckedIOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.broadinstitute.hellbender.exceptions.GATKException;
import org.broadinstitute.hellbender.tools.spark.sv.utils.SVInterval;
import org.broadinstitute.hellbender.tools.spark.sv.utils.SVKmer;
import org.broadinstitute.hellbender.tools.spark.sv.utils.SVKmerLong;
import org.broadinstitute.hellbender.tools.spark.sv.utils.SVKmerizer;
import org.broadinstitute.hellbender.tools.spark.utils.HopscotchSet;
import org.broadinstitute.hellbender.utils.Utils;
import org.broadinstitute.hellbender.utils.gcs.BucketUtils;
import org.broadinstitute.hellbender.utils.io.IOUtils;

public final class SVFileUtils {
    private static final String REFERENCE_GAP_INTERVAL_FILE_COMMENT_LINE_PROMPT = "#";

    public static void writeSAMFile(String outputName, Iterator<SAMRecord> alignments, SAMFileHeader header, boolean preOrdered) {
        Utils.nonNull(alignments, "provided alignments to write out is null");
        Utils.nonNull(header, "provided header for outputting sam file is null");
        Utils.nonNull(outputName, "provided output name is null");
        SAMFileWriterFactory factory = new SAMFileWriterFactory().setCreateIndex(preOrdered && outputName.endsWith(".bam") && header.getSortOrder() == SAMFileHeader.SortOrder.coordinate);
        try (SAMFileWriter writer = factory.makeSAMOrBAMWriter(header, preOrdered, IOUtils.getPath(outputName));){
            alignments.forEachRemaining(arg_0 -> ((SAMFileWriter)writer).addAlignment(arg_0));
        }
        catch (UncheckedIOException ie) {
            throw new GATKException("Can't write SAM file to the specified location: " + outputName, ie);
        }
    }

    public static Set<SVKmer> readKmersFile(String kmersFilePath, int kSize) {
        HopscotchSet<SVKmer> kmers;
        Utils.nonNull(kmersFilePath, "provided path for file containing kmers is null");
        Utils.validateArg(kSize > 0, "provided k-size is non positive: " + kSize);
        try (BufferedReader rdr = new BufferedReader(new InputStreamReader(BucketUtils.openFile(kmersFilePath)));){
            String line;
            long fileLength = BucketUtils.fileSize(kmersFilePath);
            kmers = new HopscotchSet<SVKmer>((int)(fileLength / (long)(kSize + 1)));
            while ((line = rdr.readLine()) != null) {
                if (line.length() != kSize) {
                    throw new GATKException("SVKmer kill set contains a line of length " + line.length() + " but we were expecting K = " + kSize);
                }
                SVKmerizer kmerizer = new SVKmerizer(line, kSize, 1, (SVKmer)new SVKmerLong(kSize));
                if (!kmerizer.hasNext()) {
                    throw new GATKException("Unable to kmerize the kmer kill set string '" + line + "'.");
                }
                kmers.add(kmerizer.next());
            }
        }
        catch (IOException ioe) {
            throw new GATKException("Unable to read kmers from " + kmersFilePath, ioe);
        }
        return kmers;
    }

    public static <KType extends SVKmer> void writeKmersFile(String kmersFilePath, int kSize, Collection<KType> kmers) {
        try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(BucketUtils.createFile(kmersFilePath)));){
            for (SVKmer kmer : kmers) {
                writer.write(kmer.toString(kSize));
                ((Writer)writer).write(10);
            }
        }
        catch (IOException ioe) {
            throw new GATKException("Unable to write kmers to " + kmersFilePath, ioe);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static List<SVInterval> readIntervalsFile(String intervalsFilePath, Map<String, Integer> contigNameMap) {
        Utils.nonNull(intervalsFilePath, "provided intervals file path is null");
        Utils.nonNull(contigNameMap, "provided map for contig index lookup is null");
        try (BufferedReader rdr = new BufferedReader(new InputStreamReader(BucketUtils.openFile(intervalsFilePath)));){
            String line;
            long sizeGuess = BucketUtils.fileSize(intervalsFilePath) / 25L;
            ArrayList<SVInterval> intervals = new ArrayList<SVInterval>((int)sizeGuess);
            int lineNo = 0;
            while ((line = rdr.readLine()) != null) {
                ++lineNo;
                if (line.startsWith(REFERENCE_GAP_INTERVAL_FILE_COMMENT_LINE_PROMPT)) continue;
                String[] tokens = line.split("\t");
                if (tokens.length != 3) {
                    throw new GATKException("Interval file " + intervalsFilePath + " line " + lineNo + " did not contain 3 columns: " + line);
                }
                try {
                    Integer contigId = contigNameMap.get(tokens[0]);
                    if (contigId == null) {
                        throw new GATKException("contig name " + tokens[0] + " not in dictionary");
                    }
                    int start = Integer.valueOf(tokens[1]);
                    int end = Integer.valueOf(tokens[2]);
                    intervals.add(new SVInterval(contigId, start, end));
                }
                catch (Exception e) {
                    throw new GATKException("Unable to parse interval file " + intervalsFilePath + " line " + lineNo + ": " + line, e);
                    return intervals;
                }
            }
        }
        catch (IOException ioe) {
            throw new GATKException("Unable to read intervals from " + intervalsFilePath, ioe);
        }
    }

    public static void writeIntervalsFile(String intervalsFilePath, Collection<SVInterval> intervals, List<String> contigNames) {
        try (OutputStreamWriter writer = new OutputStreamWriter(new BufferedOutputStream(BucketUtils.createFile(intervalsFilePath)));){
            for (SVInterval interval : intervals) {
                String seqName = contigNames.get(interval.getContig());
                writer.write(seqName + "\t" + interval.getStart() + "\t" + interval.getEnd() + "\n");
            }
        }
        catch (IOException ioe) {
            throw new GATKException("Can't write intervals file " + intervalsFilePath, ioe);
        }
    }
}

