/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.spark.sv.utils;

import com.esotericsoftware.kryo.DefaultSerializer;
import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import com.google.common.annotations.VisibleForTesting;
import org.broadinstitute.hellbender.exceptions.GATKException;
import org.broadinstitute.hellbender.tools.spark.sv.utils.SVLocation;
import org.broadinstitute.hellbender.utils.Utils;

@DefaultSerializer(value=Serializer.class)
@VisibleForTesting
public final class SVInterval
implements Comparable<SVInterval> {
    private final int contig;
    private final int start;
    private final int end;

    public SVInterval(int contig, int start, int end) {
        this(contig, start, end, SVIntervalConstructorArgsValidator.RefuseNegativeContigAndCoordinates);
    }

    public SVInterval(int contig, int start, int end, SVIntervalConstructorArgsValidator argsValidator) {
        argsValidator.accept(contig, start, end);
        this.contig = contig;
        this.start = start;
        this.end = end;
    }

    private SVInterval(Kryo kryo, Input input) {
        this.contig = input.readInt();
        this.start = input.readInt();
        this.end = input.readInt();
    }

    private void serialize(Kryo kryo, Output output) {
        output.writeInt(this.contig);
        output.writeInt(this.start);
        output.writeInt(this.end);
    }

    public int getContig() {
        return this.contig;
    }

    public int getStart() {
        return this.start;
    }

    public int getEnd() {
        return this.end;
    }

    public int getLength() {
        return this.end - this.start;
    }

    public SVLocation getStartLocation() {
        return new SVLocation(this.contig, this.start);
    }

    public boolean overlaps(SVInterval that) {
        return this.contig == that.contig && this.start < that.end && that.start < this.end;
    }

    public boolean isDisjointFrom(SVInterval that) {
        return !this.overlaps(that);
    }

    public boolean isUpstreamOf(SVInterval that) {
        return this.contig < that.contig || this.contig == that.contig && this.end <= that.start;
    }

    public boolean contains(SVInterval that) {
        return this.contig == that.contig && this.start <= that.start && this.end >= that.end;
    }

    public int gapLen(SVInterval that) {
        if (this.contig != that.contig) {
            return Integer.MAX_VALUE;
        }
        return that.start - this.end;
    }

    public int overlapLen(SVInterval that) {
        if (this.contig != that.contig) {
            return 0;
        }
        return Math.max(0, Math.min(this.end, that.end) - Math.max(this.start, that.start));
    }

    public SVInterval join(SVInterval that) {
        if (this.contig != that.contig) {
            throw new GATKException("Joining across contigs.");
        }
        return new SVInterval(this.contig, Math.min(this.start, that.start), Math.max(this.end, that.end));
    }

    public SVInterval intersect(SVInterval that) {
        if (!this.overlaps(that)) {
            return null;
        }
        return new SVInterval(this.getContig(), Math.max(this.start, that.start), Math.min(this.end, that.end));
    }

    public int midpoint() {
        return (this.start + this.end) / 2;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof SVInterval)) {
            return false;
        }
        SVInterval that = (SVInterval)obj;
        return this.contig == that.contig && this.start == that.start && this.end == that.end;
    }

    public int hashCode() {
        return 47 * (47 * (47 * (47 * this.contig) + this.start) + this.end);
    }

    @Override
    public int compareTo(SVInterval that) {
        int result = Integer.compare(this.contig, that.contig);
        if (result == 0 && (result = Integer.compare(this.start, that.start)) == 0) {
            result = Integer.compare(this.end, that.end);
        }
        return result;
    }

    public String toString() {
        return Integer.toString(this.contig) + "[" + this.start + ":" + this.end + "]";
    }

    public static final class Serializer
    extends com.esotericsoftware.kryo.Serializer<SVInterval> {
        public void write(Kryo kryo, Output output, SVInterval interval) {
            interval.serialize(kryo, output);
        }

        public SVInterval read(Kryo kryo, Input input, Class<SVInterval> klass) {
            return new SVInterval(kryo, input);
        }
    }

    @FunctionalInterface
    public static interface SVIntervalConstructorArgsValidator {
        public static final SVIntervalConstructorArgsValidator ACCEPTS_ALL = (contig, start, end) -> {};
        public static final SVIntervalConstructorArgsValidator RefuseNegativeContigs = (contig, start, end) -> {
            if (contig < 0) {
                throw new IllegalArgumentException("provided contig is negative: " + contig);
            }
        };
        public static final SVIntervalConstructorArgsValidator RefuseNegativeCoordinates = (contig, start, end) -> {
            if (start < 0) {
                throw new IllegalArgumentException("provided start is negative: " + start);
            }
            if (end < 0) {
                throw new IllegalArgumentException("provided end is negative: " + end);
            }
        };
        public static final SVIntervalConstructorArgsValidator RefuseNegativeContigAndCoordinates = RefuseNegativeContigs.andThen(RefuseNegativeCoordinates);

        public void accept(int var1, int var2, int var3);

        default public SVIntervalConstructorArgsValidator andThen(SVIntervalConstructorArgsValidator after) {
            Utils.nonNull(after);
            return (contig, start, end) -> {
                this.accept(contig, start, end);
                after.accept(contig, start, end);
            };
        }
    }
}

