/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.spark.sv.utils;

import com.esotericsoftware.kryo.DefaultSerializer;
import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import org.broadinstitute.hellbender.exceptions.GATKException;
import org.broadinstitute.hellbender.tools.spark.sv.utils.SVInterval;

@DefaultSerializer(value=Serializer.class)
public final class SVIntervalTree<V>
implements Iterable<Entry<V>> {
    private Node<V> root;
    private V sentinel;

    public SVIntervalTree() {
    }

    private SVIntervalTree(Kryo kryo, Input input) {
        SVInterval.Serializer intervalSerializer = new SVInterval.Serializer();
        int size = input.readInt();
        while (size-- > 0) {
            Object interval = intervalSerializer.read(kryo, input, (Class)SVInterval.class);
            Object value = kryo.readClassAndObject(input);
            this.put((SVInterval)interval, value);
        }
    }

    private void serialize(Kryo kryo, Output output) {
        SVInterval.Serializer intervalSerializer = new SVInterval.Serializer();
        int nEntries = this.size();
        output.writeInt(nEntries);
        for (Entry<V> entry : this) {
            intervalSerializer.write(kryo, output, entry.getInterval());
            kryo.writeClassAndObject(output, entry.getValue());
            --nEntries;
        }
        if (nEntries != 0) {
            throw new GATKException("SVIntervalTree size and iteration gave a different number of intervals.");
        }
    }

    public int size() {
        return this.root == null ? 0 : this.root.getSize();
    }

    public void clear() {
        this.root = null;
    }

    public V put(SVInterval interval, V value) {
        V result = this.sentinel;
        if (this.root == null) {
            this.root = new Node<V>(interval, value);
        } else {
            Node<V> parent = null;
            Node<V> node = this.root;
            int cmpVal = 0;
            while (node != null) {
                parent = node;
                cmpVal = interval.compareTo(node.getInterval());
                if (cmpVal == 0) break;
                node = cmpVal < 0 ? node.getLeft() : node.getRight();
            }
            if (cmpVal == 0) {
                result = parent.setValue(value);
            } else {
                this.root = cmpVal < 0 ? parent.insertLeft(interval, value, this.root) : parent.insertRight(interval, value, this.root);
            }
        }
        return result;
    }

    public V remove(SVInterval interval) {
        V result = this.sentinel;
        Node<V> node = this.root;
        while (node != null) {
            int cmpVal = interval.compareTo(node.getInterval());
            if (cmpVal == 0) {
                result = node.getValue();
                this.root = node.remove(this.root);
                break;
            }
            node = cmpVal < 0 ? node.getLeft() : node.getRight();
        }
        return result;
    }

    public Entry<V> find(SVInterval interval) {
        int cmpVal;
        Node<V> node = this.root;
        while (node != null && (cmpVal = interval.compareTo(node.getInterval())) != 0) {
            node = cmpVal < 0 ? node.getLeft() : node.getRight();
        }
        return node;
    }

    public Entry<V> findByIndex(int idx) {
        return Node.findByRank(this.root, idx + 1);
    }

    public int getIndex(SVInterval interval) {
        return Node.getRank(this.root, interval) - 1;
    }

    public Entry<V> min() {
        Node<V> result = null;
        for (Node<V> node = this.root; node != null; node = node.getLeft()) {
            result = node;
        }
        return result;
    }

    public Entry<V> min(SVInterval interval) {
        Node<V> result = null;
        Node<V> node = this.root;
        int cmpVal = 0;
        while (node != null) {
            result = node;
            cmpVal = interval.compareTo(node.getInterval());
            if (cmpVal == 0) break;
            node = cmpVal < 0 ? node.getLeft() : node.getRight();
        }
        if (cmpVal > 0) {
            result = result.getNext();
        }
        return result;
    }

    public boolean hasOverlapper(SVInterval interval) {
        block3: {
            Node<V> node = this.root;
            if (node == null || node.getMaxEndInterval().isUpstreamOf(interval)) break block3;
            while (true) {
                if (node.getInterval().overlaps(interval)) {
                    return true;
                }
                Node<V> left = node.getLeft();
                if (left != null && !left.getMaxEndInterval().isUpstreamOf(interval)) {
                    node = left;
                    continue;
                }
                if (interval.isUpstreamOf(node.getInterval()) || (node = node.getRight()) == null || node.getMaxEndInterval().isUpstreamOf(interval)) break;
            }
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Entry<V> minOverlapper(SVInterval interval) {
        Node<V> result = null;
        Node<V> node = this.root;
        if (node == null || node.getMaxEndInterval().isUpstreamOf(interval)) return result;
        while (true) {
            if (node.getInterval().overlaps(interval)) {
                result = node;
                if ((node = node.getLeft()) != null && !node.getMaxEndInterval().isUpstreamOf(interval)) continue;
                return result;
            }
            Node<V> left = node.getLeft();
            if (left != null && !left.getMaxEndInterval().isUpstreamOf(interval)) {
                node = left;
                continue;
            }
            if (interval.isUpstreamOf(node.getInterval()) || (node = node.getRight()) == null || node.getMaxEndInterval().isUpstreamOf(interval)) return result;
        }
    }

    public Entry<V> max() {
        Node<V> result = null;
        for (Node<V> node = this.root; node != null; node = node.getRight()) {
            result = node;
        }
        return result;
    }

    public Entry<V> max(SVInterval interval) {
        Node<V> result = null;
        Node<V> node = this.root;
        int cmpVal = 0;
        while (node != null) {
            result = node;
            cmpVal = interval.compareTo(node.getInterval());
            if (cmpVal == 0) break;
            node = cmpVal < 0 ? node.getLeft() : node.getRight();
        }
        if (cmpVal < 0) {
            result = result.getPrev();
        }
        return result;
    }

    public SVInterval maxEnd() {
        return this.root == null ? null : this.root.getMaxEndInterval();
    }

    @Override
    public Iterator<Entry<V>> iterator() {
        return new FwdIterator((Node)this.min());
    }

    public Iterator<Entry<V>> iterator(SVInterval interval) {
        return new FwdIterator((Node)this.min(interval));
    }

    public Iterator<Entry<V>> overlappers(SVInterval interval) {
        return new OverlapIterator(interval);
    }

    public Iterator<Entry<V>> reverseIterator() {
        return new RevIterator((Node)this.max());
    }

    public Iterator<Entry<V>> reverseIterator(SVInterval interval) {
        return new RevIterator((Node)this.max(interval));
    }

    public V getSentinel() {
        return this.sentinel;
    }

    public V setSentinel(V sentinel) {
        V result = this.sentinel;
        this.sentinel = sentinel;
        return result;
    }

    public float overlapFraction(SVIntervalTree<?> that) {
        int count = 0;
        for (Entry<V> entry : this) {
            if (!that.hasOverlapper(entry.getInterval())) continue;
            ++count;
        }
        return (float)count / (float)this.size();
    }

    void removeNode(Node<V> node) {
        this.root = node.remove(this.root);
    }

    public static final class Serializer<T>
    extends com.esotericsoftware.kryo.Serializer<SVIntervalTree<T>> {
        public void write(Kryo kryo, Output output, SVIntervalTree<T> interval) {
            ((SVIntervalTree)interval).serialize(kryo, output);
        }

        public SVIntervalTree<T> read(Kryo kryo, Input input, Class<SVIntervalTree<T>> klass) {
            return new SVIntervalTree(kryo, input);
        }
    }

    public static final class ValuesIterator<V1>
    implements Iterator<V1> {
        private final Iterator<Entry<V1>> itr;

        public ValuesIterator(Iterator<Entry<V1>> itr) {
            this.itr = itr;
        }

        @Override
        public boolean hasNext() {
            return this.itr.hasNext();
        }

        @Override
        public V1 next() {
            return this.itr.next().getValue();
        }

        @Override
        public void remove() {
            this.itr.remove();
        }
    }

    public final class OverlapIterator
    extends IteratorBase {
        private final SVInterval interval;

        public OverlapIterator(SVInterval interval) {
            super((Node)SVIntervalTree.this.minOverlapper(interval));
            this.interval = interval;
        }

        @Override
        public Node<V> next() {
            if (this.next == null) {
                throw new NoSuchElementException("No next element.");
            }
            if (this.next.wasRemoved()) {
                throw new ConcurrentModificationException("Current element was removed.");
            }
            this.last = this.next;
            this.next = Node.getNextOverlapper(this.next, this.interval);
            return this.last;
        }
    }

    public final class RevIterator
    extends IteratorBase {
        public RevIterator(Node<V> node) {
            super(node);
        }

        @Override
        public Node<V> next() {
            if (this.next == null) {
                throw new NoSuchElementException("No next element.");
            }
            if (this.next.wasRemoved()) {
                this.next = (Node)SVIntervalTree.this.max(this.next.getInterval());
                if (this.next == null) {
                    throw new ConcurrentModificationException("Current element was removed, and there are no more elements.");
                }
            }
            this.last = this.next;
            this.next = this.next.getPrev();
            return this.last;
        }
    }

    public final class FwdIterator
    extends IteratorBase {
        public FwdIterator(Node<V> node) {
            super(node);
        }

        @Override
        public Node<V> next() {
            if (this.next == null) {
                throw new NoSuchElementException("No next element.");
            }
            if (this.next.wasRemoved()) {
                this.next = (Node)SVIntervalTree.this.min(this.next.getInterval());
                if (this.next == null) {
                    throw new ConcurrentModificationException("Current element was removed, and there are no more elements.");
                }
            }
            this.last = this.next;
            this.next = this.next.getNext();
            return this.last;
        }
    }

    abstract class IteratorBase
    implements Iterator<Entry<V>> {
        protected Node<V> next;
        protected Node<V> last;

        protected IteratorBase(Node<V> node) {
            this.next = node;
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        @Override
        public void remove() {
            if (this.last == null) {
                throw new IllegalStateException("No entry to remove.");
            }
            SVIntervalTree.this.removeNode(this.last);
            this.last = null;
        }

        public boolean equals(Object obj) {
            return obj instanceof IteratorBase && ((IteratorBase)obj).next == this.next;
        }

        public int hashCode() {
            return Objects.hashCode(this.next);
        }
    }

    static final class Node<V1>
    implements Entry<V1> {
        private final SVInterval interval;
        private V1 value;
        private Node<V1> parent;
        private Node<V1> left;
        private Node<V1> right;
        private int size;
        private SVInterval maxEndInterval;
        private boolean isBlack;

        Node(SVInterval interval, V1 value) {
            this.interval = interval;
            this.value = value;
            this.size = 1;
            this.maxEndInterval = interval;
            this.isBlack = true;
        }

        Node(Node<V1> parent, SVInterval interval, V1 value) {
            this.interval = interval;
            this.value = value;
            this.parent = parent;
            this.size = 1;
            this.maxEndInterval = interval;
        }

        @Override
        public SVInterval getInterval() {
            return this.interval;
        }

        @Override
        public V1 getValue() {
            return this.value;
        }

        @Override
        public V1 setValue(V1 value) {
            V1 result = this.value;
            this.value = value;
            return result;
        }

        int getSize() {
            return this.size;
        }

        SVInterval getMaxEndInterval() {
            return this.maxEndInterval;
        }

        Node<V1> getLeft() {
            return this.left;
        }

        Node<V1> insertLeft(SVInterval interval, V1 value, Node<V1> root) {
            this.left = new Node<V1>(this, interval, value);
            return Node.insertFixup(this.left, root);
        }

        Node<V1> getRight() {
            return this.right;
        }

        Node<V1> insertRight(SVInterval interval, V1 value, Node<V1> root) {
            this.right = new Node<V1>(this, interval, value);
            return Node.insertFixup(this.right, root);
        }

        Node<V1> getNext() {
            Node<V1> result;
            if (this.right != null) {
                result = this.right;
                while (result.left != null) {
                    result = result.left;
                }
            } else {
                Node<V1> node = this;
                result = this.parent;
                while (result != null && node == result.right) {
                    node = result;
                    result = result.parent;
                }
            }
            return result;
        }

        Node<V1> getPrev() {
            Node<V1> result;
            if (this.left != null) {
                result = this.left;
                while (result.right != null) {
                    result = result.right;
                }
            } else {
                Node<V1> node = this;
                result = this.parent;
                while (result != null && node == result.left) {
                    node = result;
                    result = result.parent;
                }
            }
            return result;
        }

        boolean wasRemoved() {
            return this.size == 0;
        }

        Node<V1> remove(Node<V1> initialRoot) {
            Node<V1> root = initialRoot;
            if (this.size == 0) {
                throw new IllegalStateException("Entry was already removed.");
            }
            if (this.left == null) {
                if (this.right == null) {
                    if (this.parent == null) {
                        root = null;
                    } else if (this.parent.left == this) {
                        this.parent.left = null;
                        Node.fixup(this.parent);
                        if (this.isBlack) {
                            root = Node.removeFixup(this.parent, null, root);
                        }
                    } else {
                        this.parent.right = null;
                        Node.fixup(this.parent);
                        if (this.isBlack) {
                            root = Node.removeFixup(this.parent, null, root);
                        }
                    }
                } else {
                    root = this.spliceOut(this.right, root);
                }
            } else if (this.right == null) {
                root = this.spliceOut(this.left, root);
            } else {
                Node<V1> next = this.getNext();
                root = next.remove(root);
                next.parent = this.parent;
                if (next.parent == null) {
                    root = next;
                } else if (this.parent.left == this) {
                    this.parent.left = next;
                } else {
                    this.parent.right = next;
                }
                next.left = this.left;
                if (next.left != null) {
                    this.left.parent = next;
                }
                if ((next.right = this.right) != null) {
                    this.right.parent = next;
                }
                next.isBlack = this.isBlack;
                next.size = this.size;
                Node.fixup(next);
            }
            this.size = 0;
            return root;
        }

        static <V1> Node<V1> getNextOverlapper(Node<V1> startingNode, SVInterval interval) {
            Node<V1> node = startingNode;
            do {
                Node<V1> nextNode;
                if ((nextNode = node.right) != null && !nextNode.maxEndInterval.isUpstreamOf(interval)) {
                    node = nextNode;
                    while ((nextNode = node.left) != null && !nextNode.maxEndInterval.isUpstreamOf(interval)) {
                        node = nextNode;
                    }
                } else {
                    nextNode = node;
                    while ((node = nextNode.parent) != null && node.right == nextNode) {
                        nextNode = node;
                    }
                }
                if (node == null || !interval.isUpstreamOf(node.interval)) continue;
                node = null;
            } while (node != null && interval.isDisjointFrom(node.interval));
            return node;
        }

        static <V1> Node<V1> findByRank(Node<V1> startingNode, int initialRank) {
            int nodeRank;
            Node<V1> node = startingNode;
            int rank = initialRank;
            while (node != null && rank != (nodeRank = super.getRank())) {
                if (rank < nodeRank) {
                    node = node.left;
                    continue;
                }
                node = node.right;
                rank -= nodeRank;
            }
            return node;
        }

        static <V1> int getRank(Node<V1> startingNode, SVInterval interval) {
            Node<V1> node = startingNode;
            int rank = 0;
            while (node != null) {
                int cmpVal = interval.compareTo(node.getInterval());
                if (cmpVal < 0) {
                    node = node.left;
                    continue;
                }
                rank += super.getRank();
                if (cmpVal == 0) {
                    return rank;
                }
                node = node.right;
            }
            return 0;
        }

        private int getRank() {
            int result = 1;
            if (this.left != null) {
                result = this.left.size + 1;
            }
            return result;
        }

        private Node<V1> spliceOut(Node<V1> child, Node<V1> initialRoot) {
            Node<V1> root = initialRoot;
            child.parent = this.parent;
            if (child.parent == null) {
                root = child;
                child.isBlack = true;
            } else {
                if (this.parent.left == this) {
                    this.parent.left = child;
                } else {
                    this.parent.right = child;
                }
                Node.fixup(this.parent);
                if (this.isBlack) {
                    root = Node.removeFixup(this.parent, child, root);
                }
            }
            return root;
        }

        private Node<V1> rotateLeft(Node<V1> initialRoot) {
            Node<V1> root = initialRoot;
            Node<V1> child = this.right;
            int childSize = child.size;
            child.size = this.size;
            this.size -= childSize;
            this.right = child.left;
            if (this.right != null) {
                this.right.parent = this;
                this.size += this.right.size;
            }
            if ((child.parent = this.parent) == null) {
                root = child;
            } else if (this == this.parent.left) {
                this.parent.left = child;
            } else {
                this.parent.right = child;
            }
            child.left = this;
            this.parent = child;
            this.setMaxEnd();
            super.setMaxEnd();
            return root;
        }

        private Node<V1> rotateRight(Node<V1> initialRoot) {
            Node<V1> root = initialRoot;
            Node<V1> child = this.left;
            int childSize = child.size;
            child.size = this.size;
            this.size -= childSize;
            this.left = child.right;
            if (this.left != null) {
                this.left.parent = this;
                this.size += this.left.size;
            }
            if ((child.parent = this.parent) == null) {
                root = child;
            } else if (this == this.parent.left) {
                this.parent.left = child;
            } else {
                this.parent.right = child;
            }
            child.right = this;
            this.parent = child;
            this.setMaxEnd();
            super.setMaxEnd();
            return root;
        }

        private void setMaxEnd() {
            this.maxEndInterval = this.interval;
            if (this.left != null) {
                this.maxEndInterval = Node.laterEndingInterval(this.maxEndInterval, this.left.maxEndInterval);
            }
            if (this.right != null) {
                this.maxEndInterval = Node.laterEndingInterval(this.maxEndInterval, this.right.maxEndInterval);
            }
        }

        private static SVInterval laterEndingInterval(SVInterval interval1, SVInterval interval2) {
            int contig2;
            int contig1 = interval1.getContig();
            if (contig1 > (contig2 = interval2.getContig())) {
                return interval1;
            }
            if (contig2 > contig1) {
                return interval2;
            }
            if (interval2.getEnd() > interval1.getEnd()) {
                return interval2;
            }
            return interval1;
        }

        private static <V1> void fixup(Node<V1> initialNode) {
            Node<V1> node = initialNode;
            do {
                node.size = 1;
                if (node.left != null) {
                    node.size += node.left.size;
                }
                if (node.right != null) {
                    node.size += node.right.size;
                }
                super.setMaxEnd();
            } while ((node = node.parent) != null);
        }

        /*
         * Enabled aggressive block sorting
         */
        private static <V1> Node<V1> insertFixup(Node<V1> initialDaughter, Node<V1> initialRoot) {
            Node<V1> daughter = initialDaughter;
            Node<V1> root = initialRoot;
            Node<V1> mom = daughter.parent;
            Node.fixup(mom);
            while (mom != null && !mom.isBlack) {
                block8: {
                    Node<V1> gramma = mom.parent;
                    Node<V1> auntie = gramma.left;
                    if (auntie == mom) {
                        auntie = gramma.right;
                        if (auntie != null && !auntie.isBlack) {
                            mom.isBlack = true;
                            auntie.isBlack = true;
                            gramma.isBlack = false;
                            daughter = gramma;
                            break block8;
                        } else {
                            if (daughter == mom.right) {
                                root = super.rotateLeft(root);
                                mom = daughter;
                            }
                            mom.isBlack = true;
                            gramma.isBlack = false;
                            root = super.rotateRight(root);
                            break;
                        }
                    }
                    if (auntie != null && !auntie.isBlack) {
                        mom.isBlack = true;
                        auntie.isBlack = true;
                        gramma.isBlack = false;
                        daughter = gramma;
                    } else {
                        if (daughter == mom.left) {
                            root = super.rotateRight(root);
                            mom = daughter;
                        }
                        mom.isBlack = true;
                        gramma.isBlack = false;
                        root = super.rotateLeft(root);
                        break;
                    }
                }
                mom = daughter.parent;
            }
            root.isBlack = true;
            return root;
        }

        private static <V1> Node<V1> removeFixup(Node<V1> initialParent, Node<V1> initialNode, Node<V1> initialRoot) {
            Node<V1> parent = initialParent;
            Node<V1> node = initialNode;
            Node<V1> root = initialRoot;
            do {
                Node<V1> sister;
                if (node == parent.left) {
                    sister = parent.right;
                    if (!sister.isBlack) {
                        sister.isBlack = true;
                        parent.isBlack = false;
                        root = super.rotateLeft(root);
                        sister = parent.right;
                    }
                    if ((sister.left == null || sister.left.isBlack) && (sister.right == null || sister.right.isBlack)) {
                        sister.isBlack = false;
                        node = parent;
                        continue;
                    }
                    if (sister.right == null || sister.right.isBlack) {
                        sister.left.isBlack = true;
                        sister.isBlack = false;
                        root = super.rotateRight(root);
                        sister = parent.right;
                    }
                    sister.isBlack = parent.isBlack;
                    parent.isBlack = true;
                    sister.right.isBlack = true;
                    root = super.rotateLeft(root);
                    node = root;
                    continue;
                }
                sister = parent.left;
                if (!sister.isBlack) {
                    sister.isBlack = true;
                    parent.isBlack = false;
                    root = super.rotateRight(root);
                    sister = parent.left;
                }
                if ((sister.left == null || sister.left.isBlack) && (sister.right == null || sister.right.isBlack)) {
                    sister.isBlack = false;
                    node = parent;
                    continue;
                }
                if (sister.left == null || sister.left.isBlack) {
                    sister.right.isBlack = true;
                    sister.isBlack = false;
                    root = super.rotateLeft(root);
                    sister = parent.left;
                }
                sister.isBlack = parent.isBlack;
                parent.isBlack = true;
                sister.left.isBlack = true;
                root = super.rotateRight(root);
                node = root;
            } while ((parent = node.parent) != null && node.isBlack);
            node.isBlack = true;
            return root;
        }
    }

    public static interface Entry<V1> {
        public SVInterval getInterval();

        public V1 getValue();

        public V1 setValue(V1 var1);
    }
}

