/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.spark.sv.utils;

public abstract class SVKmer {
    protected static final long[] BYTEWISE_REVERSE_COMPLEMENT = new long[256];

    public abstract SVKmer successor(Base var1, int var2);

    public abstract SVKmer predecessor(Base var1, int var2);

    public abstract SVKmer reverseComplement(int var1);

    public abstract SVKmer canonical(int var1);

    public abstract Base firstBase(int var1);

    public abstract Base lastBase();

    public abstract int firstTrimer(int var1);

    public abstract int lastTrimer();

    public abstract String toString(int var1);

    protected static long reverseComplement(long val) {
        long result = BYTEWISE_REVERSE_COMPLEMENT[(int)val & 0xFF];
        int nBytes = 8;
        while (--nBytes != 0) {
            result = result << 8 | BYTEWISE_REVERSE_COMPLEMENT[(int)(val >>= 8) & 0xFF];
        }
        return result;
    }

    protected static long reverseComplementByteValueAsLong(int bIn) {
        return (long)(~((bIn & 3) << 6 | (bIn >> 2 & 3) << 4 | (bIn >> 4 & 3) << 2 | bIn >> 6 & 3)) & 0xFFL;
    }

    static {
        for (int idx = 0; idx != 256; ++idx) {
            SVKmer.BYTEWISE_REVERSE_COMPLEMENT[idx] = SVKmer.reverseComplementByteValueAsLong(idx);
        }
    }

    public static enum Base {
        A(0L),
        C(1L),
        G(2L),
        T(3L);

        public final long value;

        private Base(long value) {
            this.value = value;
        }
    }
}

