/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.spark.sv.utils;

import com.esotericsoftware.kryo.DefaultSerializer;
import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import org.broadinstitute.hellbender.tools.spark.sv.utils.SVKmer;
import org.broadinstitute.hellbender.tools.spark.sv.utils.SVUtils;
import org.broadinstitute.hellbender.utils.BaseUtils;
import org.broadinstitute.hellbender.utils.Utils;

@DefaultSerializer(value=Serializer.class)
public class SVKmerLong
extends SVKmer
implements Comparable<SVKmerLong> {
    private final long valHigh;
    private final long valLow;

    public SVKmerLong() {
        this.valLow = 0L;
        this.valHigh = 0L;
    }

    public SVKmerLong(int kSize) {
        Utils.validateArg(kSize >= 1 && kSize < 64, "Kmer length must be between 1 and 63.");
        this.valLow = 0L;
        this.valHigh = 0L;
    }

    public SVKmerLong(SVKmerLong that) {
        this.valHigh = that.valHigh;
        this.valLow = that.valLow;
    }

    public SVKmerLong(SVKmer that) {
        SVKmerLong thatLong = (SVKmerLong)that;
        this.valHigh = thatLong.valHigh;
        this.valLow = thatLong.valLow;
    }

    private SVKmerLong(long valHigh, long valLow) {
        this.valHigh = valHigh;
        this.valLow = valLow;
    }

    protected SVKmerLong(Kryo kryo, Input input) {
        this.valHigh = input.readLong();
        this.valLow = input.readLong();
    }

    protected void serialize(Kryo kryo, Output output) {
        output.writeLong(this.valHigh);
        output.writeLong(this.valLow);
    }

    @Override
    public final SVKmerLong successor(SVKmer.Base base, int kSize) {
        long mask = (1L << kSize) - 1L;
        long newV1 = (this.valHigh << 2 | this.valLow >> kSize - 2) & mask;
        long newV2 = (this.valLow << 2 | base.value & 3L) & mask;
        return new SVKmerLong(newV1, newV2);
    }

    @Override
    public final SVKmerLong predecessor(SVKmer.Base base, int kSize) {
        long mask = (1L << kSize) - 1L;
        long newV1 = (this.valHigh >> 2 | base.value << kSize - 2) & mask;
        long newV2 = (this.valLow >> 2 | this.valHigh << kSize - 2) & mask;
        return new SVKmerLong(newV1, newV2);
    }

    @Override
    public final SVKmerLong reverseComplement(int kSize) {
        long mask = (1L << kSize) - 1L;
        int compK = 64 - kSize;
        if ((kSize & 1) == 0) {
            return new SVKmerLong(SVKmerLong.reverseComplement(this.valLow << compK) & mask, SVKmerLong.reverseComplement(this.valHigh << compK) & mask);
        }
        long newV1 = SVKmerLong.reverseComplement(this.valLow << compK + 1) << 1 & mask ^ (this.valHigh & 1L ^ 1L);
        long newV2 = SVKmerLong.reverseComplement(this.valHigh << compK) & mask ^ this.valLow & 1L << kSize - 1;
        return new SVKmerLong(newV1, newV2);
    }

    @Override
    public SVKmerLong canonical(int kSize) {
        Utils.validateArg((kSize & 1) != 0, "Kmer length must be odd to canonicalize.");
        if ((this.valHigh & 1L) == 0L) {
            return this;
        }
        return this.reverseComplement(kSize);
    }

    @Override
    public final SVKmer.Base firstBase(int kSize) {
        return SVKmer.Base.values()[(int)(this.valHigh >> kSize - 2)];
    }

    @Override
    public final SVKmer.Base lastBase() {
        return SVKmer.Base.values()[(int)(this.valLow & 3L)];
    }

    @Override
    public final int firstTrimer(int kSize) {
        return (int)(this.valHigh >>> kSize - 6);
    }

    @Override
    public final int lastTrimer() {
        return (int)this.valLow & 0x3F;
    }

    public boolean equals(Object obj) {
        return obj instanceof SVKmerLong && this.equals((SVKmerLong)obj);
    }

    public final boolean equals(SVKmerLong that) {
        return this.valHigh == that.valHigh && this.valLow == that.valLow;
    }

    public final int hashCode() {
        return (int)SVUtils.fnvLong64(SVUtils.fnvLong64(this.valHigh), this.valLow);
    }

    @Override
    public final int compareTo(SVKmerLong that) {
        int result = Long.compare(this.valHigh, that.valHigh);
        if (result == 0) {
            result = Long.compare(this.valLow, that.valLow);
        }
        return result;
    }

    @Override
    public final String toString(int kSize) {
        int nChars;
        StringBuilder sb = new StringBuilder(kSize);
        long val = this.valLow;
        for (nChars = kSize / 2; nChars > 0; --nChars) {
            sb.append(BaseUtils.BASE_CHARS[(int)val & 3]);
            val >>= 2;
        }
        val = (kSize & 1) == 0 ? this.valHigh : (val |= this.valHigh << 1);
        for (nChars = (kSize + 1) / 2; nChars > 0; --nChars) {
            sb.append(BaseUtils.BASE_CHARS[(int)val & 3]);
            val >>= 2;
        }
        return sb.reverse().toString();
    }

    public static final class Serializer
    extends com.esotericsoftware.kryo.Serializer<SVKmerLong> {
        public void write(Kryo kryo, Output output, SVKmerLong svKmer) {
            svKmer.serialize(kryo, output);
        }

        public SVKmerLong read(Kryo kryo, Input input, Class<SVKmerLong> klass) {
            return new SVKmerLong(kryo, input);
        }
    }
}

