/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.spark.sv.utils;

import com.esotericsoftware.kryo.DefaultSerializer;
import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import org.broadinstitute.hellbender.tools.spark.sv.utils.SVKmer;
import org.broadinstitute.hellbender.tools.spark.sv.utils.SVUtils;
import org.broadinstitute.hellbender.utils.BaseUtils;
import org.broadinstitute.hellbender.utils.Utils;

@DefaultSerializer(value=Serializer.class)
public class SVKmerShort
extends SVKmer
implements Comparable<SVKmerShort> {
    private final long valLow;

    public SVKmerShort() {
        this.valLow = 0L;
    }

    public SVKmerShort(int kSize) {
        Utils.validateArg(kSize >= 1 && kSize < 32, "Kmer length must be between 1 and 31.");
        this.valLow = 0L;
    }

    public SVKmerShort(SVKmerShort that) {
        this.valLow = that.valLow;
    }

    public SVKmerShort(long valLow) {
        this.valLow = valLow;
    }

    private SVKmerShort(Kryo kryo, Input input) {
        this.valLow = input.readLong();
    }

    private void serialize(Kryo kryo, Output output) {
        output.writeLong(this.valLow);
    }

    public long getLong() {
        return this.valLow;
    }

    @Override
    public final SVKmerShort successor(SVKmer.Base base, int kSize) {
        long mask = (1L << kSize * 2) - 1L;
        long newV2 = (this.valLow << 2 | base.value & 3L) & mask;
        return new SVKmerShort(newV2);
    }

    @Override
    public final SVKmerShort predecessor(SVKmer.Base base, int kSize) {
        long mask = (1L << kSize * 2) - 1L;
        long newV2 = (this.valLow >> 2 | base.value << kSize * 2 - 2) & mask;
        return new SVKmerShort(newV2);
    }

    @Override
    public final SVKmerShort reverseComplement(int kSize) {
        long mask = (1L << kSize * 2) - 1L;
        int compK = 64 - kSize * 2;
        return new SVKmerShort(SVKmerShort.reverseComplement(this.valLow << compK) & mask);
    }

    @Override
    public SVKmerShort canonical(int kSize) {
        Utils.validateArg((kSize & 1) != 0, "Kmer length must be odd to canonicalize.");
        if ((this.valLow >> kSize & 1L) == 0L) {
            return this;
        }
        return this.reverseComplement(kSize);
    }

    @Override
    public final SVKmer.Base firstBase(int kSize) {
        return SVKmer.Base.values()[(int)(this.valLow >> kSize * 2 - 2)];
    }

    @Override
    public final SVKmer.Base lastBase() {
        return SVKmer.Base.values()[(int)(this.valLow & 3L)];
    }

    @Override
    public final int firstTrimer(int kSize) {
        return (int)(this.valLow >>> kSize * 2 - 6);
    }

    @Override
    public final int lastTrimer() {
        return (int)this.valLow & 0x3F;
    }

    public boolean equals(Object obj) {
        return obj instanceof SVKmerShort && this.equals((SVKmerShort)obj);
    }

    public final boolean equals(SVKmerShort that) {
        return this.valLow == that.valLow;
    }

    public final int hashCode() {
        return (int)SVUtils.fnvLong64(2166136261L, this.valLow);
    }

    @Override
    public final int compareTo(SVKmerShort that) {
        return Long.compare(this.valLow, that.valLow);
    }

    public static SVKmerShort getMask(byte[] positions, int kSize) {
        long mask = 0L;
        for (byte pos : positions) {
            mask |= 3L << 2 * (kSize - pos - 1);
        }
        return new SVKmerShort(mask ^ 0xFFFFFFFFFFFFFFFFL);
    }

    public SVKmerShort mask(SVKmerShort mask) {
        return new SVKmerShort(this.valLow & mask.valLow);
    }

    @Override
    public final String toString(int kSize) {
        StringBuilder sb = new StringBuilder(kSize);
        long val = this.valLow;
        for (int idx = 0; idx != kSize; ++idx) {
            sb.append(BaseUtils.BASE_CHARS[(int)val & 3]);
            val >>= 2;
        }
        return sb.reverse().toString();
    }

    public static final class Serializer
    extends com.esotericsoftware.kryo.Serializer<SVKmerShort> {
        public void write(Kryo kryo, Output output, SVKmerShort svKmer) {
            svKmer.serialize(kryo, output);
        }

        public SVKmerShort read(Kryo kryo, Input input, Class<SVKmerShort> klass) {
            return new SVKmerShort(kryo, input);
        }
    }
}

