/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.spark.sv.utils;

import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.broadinstitute.hellbender.tools.spark.sv.utils.SVKmer;
import org.broadinstitute.hellbender.utils.Utils;

public class SVKmerizer
implements Iterator<SVKmer> {
    protected final CharSequence seq;
    protected final int kSize;
    protected final int kAdvance;
    protected int idx = 0;
    protected SVKmer nextKmer;

    public SVKmerizer(byte[] seq, int kSize, SVKmer kmer) {
        this(seq, kSize, 1, kmer);
    }

    public SVKmerizer(byte[] seq, int kSize, int kSpace, SVKmer kmer) {
        this(new ASCIICharSequence(seq), kSize, kSpace, kmer);
    }

    public SVKmerizer(CharSequence seq, int kSize, SVKmer kmer) {
        this(seq, kSize, 1, kmer);
    }

    public SVKmerizer(CharSequence seq, int kSize, int kSpace, SVKmer kmer) {
        this.seq = seq;
        this.kSize = kSize;
        this.kAdvance = kSize - kSpace;
        this.nextKmer = this.nextKmer(kmer, 0);
    }

    protected SVKmerizer(int kSize, CharSequence seq) {
        this(kSize, 1, seq);
    }

    protected SVKmerizer(int kSize, int kSpace, CharSequence seq) {
        this.seq = seq;
        this.kSize = kSize;
        this.kAdvance = kSize - kSpace;
    }

    @Override
    public boolean hasNext() {
        return this.nextKmer != null;
    }

    @Override
    public SVKmer next() {
        if (this.nextKmer == null) {
            throw new NoSuchElementException("Kmerization sequence exhausted.");
        }
        SVKmer result = this.nextKmer;
        this.nextKmer = this.nextKmer(this.nextKmer, this.kAdvance);
        return result;
    }

    public static SVKmer toKmer(CharSequence seq, SVKmer kmer) {
        SVKmerizer sk = new SVKmerizer(seq, seq.length(), 1, kmer);
        Utils.validateArg(sk.hasNext(), () -> "Can't make a SVKmer from '" + seq + "'");
        return sk.next();
    }

    public static SVKmer toKmer(byte[] seq, SVKmer kmer) {
        return SVKmerizer.toKmer(new ASCIICharSequence(seq), kmer);
    }

    public static Stream<SVKmer> stream(CharSequence seq, int kSize, int kSpace, SVKmer kmer) {
        return StreamSupport.stream(((Iterable)() -> new SVKmerizer(seq, kSize, kSpace, kmer)).spliterator(), false);
    }

    public static Stream<SVKmer> stream(byte[] seq, int kSize, int kSpace, SVKmer kmer) {
        return SVKmerizer.stream(new ASCIICharSequence(seq), kSize, kSpace, kmer);
    }

    public static Stream<SVKmer> stream(byte[] seq, int kSize, SVKmer kmer) {
        return SVKmerizer.stream(seq, kSize, 1, kmer);
    }

    public static Stream<SVKmer> canonicalStream(byte[] seq, int kSize, SVKmer kmer) {
        return SVKmerizer.stream(seq, kSize, 1, kmer).map(kkk -> kkk.canonical(kSize));
    }

    protected SVKmer nextKmer(SVKmer tmpKmer, int validBaseCount) {
        int len = this.seq.length();
        while (this.idx < len) {
            switch (this.seq.charAt(this.idx)) {
                case 'A': 
                case 'a': {
                    tmpKmer = tmpKmer.successor(SVKmer.Base.A, this.kSize);
                    break;
                }
                case 'C': 
                case 'c': {
                    tmpKmer = tmpKmer.successor(SVKmer.Base.C, this.kSize);
                    break;
                }
                case 'G': 
                case 'g': {
                    tmpKmer = tmpKmer.successor(SVKmer.Base.G, this.kSize);
                    break;
                }
                case 'T': 
                case 't': {
                    tmpKmer = tmpKmer.successor(SVKmer.Base.T, this.kSize);
                    break;
                }
                default: {
                    validBaseCount = -1;
                }
            }
            ++this.idx;
            if (++validBaseCount != this.kSize) continue;
            return tmpKmer;
        }
        return null;
    }

    public static final class ASCIICharSequence
    implements CharSequence {
        final byte[] bytes;

        ASCIICharSequence(byte[] bytes) {
            this.bytes = bytes;
        }

        @Override
        public int length() {
            return this.bytes.length;
        }

        @Override
        public char charAt(int index) {
            return (char)(this.bytes[index] & 0xFF);
        }

        @Override
        public CharSequence subSequence(int start, int end) {
            return new ASCIICharSequence(Arrays.copyOfRange(this.bytes, start, end));
        }

        @Override
        public String toString() {
            return new StringBuilder(this).toString();
        }
    }
}

