/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.spark.sv.utils;

import htsjdk.samtools.SAMSequenceDictionary;
import htsjdk.samtools.SAMSequenceRecord;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.JavaSparkContext;
import org.broadinstitute.hellbender.engine.spark.datasources.ReferenceMultiSparkSource;
import org.broadinstitute.hellbender.exceptions.GATKException;
import org.broadinstitute.hellbender.utils.SimpleInterval;
import org.broadinstitute.hellbender.utils.Utils;

public final class SVReferenceUtils {
    public static JavaRDD<byte[]> getReferenceBasesRDD(JavaSparkContext ctx, int kSize, ReferenceMultiSparkSource ref, SAMSequenceDictionary dict, int refRecordLen, int refRecordsPerPartition) {
        Utils.nonNull(dict, "provided dictionary is null");
        Utils.validateArg(kSize != 0, "provided kmer size is zero");
        Utils.validateArg(refRecordLen > 0, "provided ref record length is non positive + " + refRecordLen);
        Utils.validateArg(refRecordsPerPartition > 0, "provided ref record per partition is non positive + " + refRecordsPerPartition);
        int effectiveRecLen = refRecordLen - kSize + 1;
        ArrayList<byte[]> sequenceChunks = new ArrayList<byte[]>();
        for (SAMSequenceRecord rec : dict.getSequences()) {
            String seqName = rec.getSequenceName();
            int seqLen = rec.getSequenceLength();
            SimpleInterval interval = new SimpleInterval(seqName, 1, seqLen);
            try {
                byte[] bases = ref.getReferenceBases(interval).getBases();
                for (int start = 0; start < seqLen; start += effectiveRecLen) {
                    sequenceChunks.add(Arrays.copyOfRange(bases, start, Math.min(start + refRecordLen, seqLen)));
                }
            }
            catch (IOException ioe) {
                throw new GATKException("Can't get reference sequence bases for " + interval, ioe);
            }
        }
        return ctx.parallelize(sequenceChunks, sequenceChunks.size() / refRecordsPerPartition + 1);
    }
}

