/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.spark.sv.utils;

import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMReadGroupRecord;
import htsjdk.samtools.SAMRecordComparator;
import htsjdk.samtools.SAMRecordCoordinateComparator;
import htsjdk.samtools.SAMRecordQueryNameComparator;
import htsjdk.samtools.SAMSequenceDictionary;
import htsjdk.samtools.SAMSequenceRecord;
import htsjdk.variant.variantcontext.VariantContext;
import java.io.IOException;
import java.math.BigInteger;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import org.broadinstitute.hellbender.exceptions.UserException;
import org.broadinstitute.hellbender.tools.spark.sv.utils.SVKmer;
import org.broadinstitute.hellbender.tools.spark.utils.HopscotchSet;
import org.broadinstitute.hellbender.tools.spark.utils.LongIterator;
import org.broadinstitute.hellbender.utils.SimpleInterval;
import org.broadinstitute.hellbender.utils.Utils;
import org.broadinstitute.hellbender.utils.io.IOUtils;

public final class SVUtils {
    public static final String GATKSV_CONTIG_ALIGNMENTS_READ_GROUP_ID = "GATKSVContigAlignments";
    private static final long FNV64_DEFAULT_SEED = new BigInteger("14695981039346656037").longValue();

    public static String getSampleId(SAMFileHeader header) {
        List readGroups = header.getReadGroups();
        Set sampleSet = readGroups.stream().map(SAMReadGroupRecord::getSample).collect(Collectors.toSet());
        Utils.validate(sampleSet.size() == 1, "Read groups must contain reads from one and only one sample, but we are finding the following ones in the given header: \t" + sampleSet.toString());
        String sample = (String)sampleSet.iterator().next();
        return sample;
    }

    public static SAMRecordComparator getSamRecordComparator(SAMFileHeader.SortOrder sortOrder) {
        SAMRecordCoordinateComparator samRecordComparator;
        switch (sortOrder) {
            case coordinate: {
                samRecordComparator = new SAMRecordCoordinateComparator();
                break;
            }
            case queryname: {
                samRecordComparator = new SAMRecordQueryNameComparator();
                break;
            }
            default: {
                throw new UserException("Unsupported assembly alignment sort order specified");
            }
        }
        return samRecordComparator;
    }

    public static List<String> getAttributeAsStringList(VariantContext vc, String attributeKey) {
        return SVUtils.getAttributeAsStringStream(vc, attributeKey).collect(Collectors.toList());
    }

    public static Stream<String> getAttributeAsStringStream(VariantContext vc, String attributeKey) {
        if (!vc.hasAttribute(attributeKey)) {
            return Stream.empty();
        }
        return vc.getAttributeAsStringList(attributeKey, "").stream().flatMap(s -> {
            if (s.contains(",")) {
                return Arrays.stream(s.split(","));
            }
            return Stream.of(s);
        });
    }

    public static SimpleInterval makeOneBpInterval(String chr, int pos) {
        return new SimpleInterval(chr, pos, pos);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Set<String> getCanonicalChromosomes(String nonCanonicalContigNamesFile, @Nonnull SAMSequenceDictionary dictionary) {
        LinkedHashSet allContigs = Utils.nonNull(dictionary).getSequences().stream().map(SAMSequenceRecord::getSequenceName).collect(Collectors.toCollection(LinkedHashSet::new));
        if (nonCanonicalContigNamesFile == null) {
            return allContigs;
        }
        try (Stream<String> nonCanonical = Files.lines(IOUtils.getPath(Utils.nonNull(nonCanonicalContigNamesFile)));){
            nonCanonical.forEach(allContigs::remove);
            LinkedHashSet linkedHashSet = allContigs;
            return linkedHashSet;
        }
        catch (IOException ioe) {
            throw new UserException("Can't read nonCanonicalContigNamesFile file " + nonCanonicalContigNamesFile, ioe);
        }
    }

    public static int hashMapCapacity(int nElements) {
        return (int)((long)nElements * 4L / 3L) + 1;
    }

    public static <T> int iteratorSize(Iterator<T> itr) {
        int result = 0;
        while (itr.hasNext()) {
            ++result;
            itr.next();
        }
        return result;
    }

    public static int iteratorSize(LongIterator itr) {
        int result = 0;
        while (itr.hasNext()) {
            ++result;
            itr.next();
        }
        return result;
    }

    public static <T> Iterator<T> singletonIterator(T t) {
        return Collections.singletonList(t).iterator();
    }

    public static Collection<SVKmer> uniquify(Collection<SVKmer> coll1, Collection<SVKmer> coll2) {
        Utils.nonNull(coll1, "first collection of kmers is null");
        Utils.nonNull(coll2, "second collection of kmers is null");
        HopscotchSet<SVKmer> kmers = new HopscotchSet<SVKmer>(coll1.size() + coll2.size());
        kmers.addAll(coll1);
        kmers.addAll(coll2);
        return kmers;
    }

    public static <T> List<T> concatenateLists(List<T> list1, List<T> list2) {
        Utils.validateArg(list1.getClass().equals(list2.getClass()), "Lists to be concatenated are of different classes");
        ArrayList<T> result = new ArrayList<T>(list1.size() + list2.size());
        result.addAll(list1);
        result.addAll(list2);
        return result;
    }

    public static <T> Collector<T, ?, ArrayList<T>> arrayListCollector(int size) {
        return Collectors.toCollection(() -> new ArrayList(size));
    }

    public static <T extends Enum<T>> EnumMap<T, Long> getZeroInitializedEnumMap(Class<T> clazz) {
        EnumMap<T, Long> map = new EnumMap<T, Long>(clazz);
        for (Enum t : (Enum[])clazz.getEnumConstants()) {
            map.put(t, 0L);
        }
        return map;
    }

    public static long fnvLong64(long toHash) {
        return SVUtils.fnvLong64(FNV64_DEFAULT_SEED, toHash);
    }

    public static long fnvLong64(long start, long toHash) {
        long mult = 1099511628211L;
        start ^= toHash >> 56 & 0xFFL;
        start *= 1099511628211L;
        start ^= toHash >> 48 & 0xFFL;
        start *= 1099511628211L;
        start ^= toHash >> 40 & 0xFFL;
        start *= 1099511628211L;
        start ^= toHash >> 32 & 0xFFL;
        start *= 1099511628211L;
        start ^= toHash >> 24 & 0xFFL;
        start *= 1099511628211L;
        start ^= toHash >> 16 & 0xFFL;
        start *= 1099511628211L;
        start ^= toHash >> 8 & 0xFFL;
        start *= 1099511628211L;
        start ^= toHash & 0xFFL;
        return start *= 1099511628211L;
    }

    public static long fnvByteArray64(byte[] toHash) {
        return SVUtils.fnvByteArray64(1099511628211L, toHash);
    }

    public static long fnvByteArray64(long start, byte[] toHash) {
        for (int i = 0; i < toHash.length; i += 8) {
            long val = 0L;
            for (int j = 0; j < 8 && i + j < toHash.length; ++j) {
                val = val << 8 | (long)toHash[i + j];
            }
            start = SVUtils.fnvLong64(start, val);
        }
        return start;
    }

    public static class IteratorFilter<T>
    implements Iterator<T> {
        private final Iterator<T> itr;
        private final Predicate<T> predicate;
        private T obj;

        public IteratorFilter(Iterator<T> itr, Predicate<T> predicate) {
            this.itr = itr;
            this.predicate = predicate;
            this.advance();
        }

        @Override
        public boolean hasNext() {
            return this.obj != null;
        }

        @Override
        public T next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException("IteratorFilter is exhausted.");
            }
            T result = this.obj;
            this.advance();
            return result;
        }

        private void advance() {
            this.obj = null;
            while (this.itr.hasNext()) {
                T next = this.itr.next();
                if (!this.predicate.test(next)) continue;
                this.obj = next;
                break;
            }
        }
    }
}

