/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.spark.sv.utils;

import htsjdk.samtools.SAMSequenceDictionary;
import htsjdk.variant.variantcontext.StructuralVariantType;
import htsjdk.variant.variantcontext.VariantContext;
import org.broadinstitute.hellbender.engine.FeatureDataSource;
import org.broadinstitute.hellbender.exceptions.UserException;
import org.broadinstitute.hellbender.tools.spark.sv.utils.SVInterval;
import org.broadinstitute.hellbender.tools.spark.sv.utils.SVIntervalTree;

public class SVVCFReader {
    public static SVIntervalTree<String> readBreakpointsFromTruthVCF(String truthVCF, SAMSequenceDictionary dictionary, int padding) {
        SVIntervalTree<String> breakpoints = new SVIntervalTree<String>();
        try (FeatureDataSource dataSource = new FeatureDataSource(truthVCF, null, 0, VariantContext.class);){
            for (VariantContext vc : dataSource) {
                StructuralVariantType svType = vc.getStructuralVariantType();
                if (svType == null) continue;
                String eventName = vc.getID();
                int contigID = dictionary.getSequenceIndex(vc.getContig());
                if (contigID < 0) {
                    throw new UserException("VCF contig " + vc.getContig() + " does not appear in dictionary.");
                }
                int start = vc.getStart();
                switch (svType) {
                    case DEL: 
                    case INV: 
                    case CNV: {
                        int end = vc.getEnd();
                        breakpoints.put(new SVInterval(contigID, start - padding, end + padding), eventName);
                        break;
                    }
                    case INS: 
                    case DUP: 
                    case BND: {
                        breakpoints.put(new SVInterval(contigID, start - padding, start + padding), eventName);
                    }
                }
            }
        }
        return breakpoints;
    }
}

