/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.spark.sv.utils;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Sets;
import htsjdk.samtools.SAMSequenceDictionary;
import htsjdk.samtools.util.Locatable;
import htsjdk.variant.variantcontext.VariantContext;
import htsjdk.variant.variantcontext.writer.Options;
import htsjdk.variant.variantcontext.writer.VariantContextWriter;
import htsjdk.variant.variantcontext.writer.VariantContextWriterBuilder;
import htsjdk.variant.vcf.VCFHeader;
import htsjdk.variant.vcf.VCFHeaderLine;
import htsjdk.variant.vcf.VCFSimpleHeaderLine;
import htsjdk.variant.vcf.VCFStandardHeaderLines;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.logging.log4j.Logger;
import org.broadinstitute.hellbender.exceptions.GATKException;
import org.broadinstitute.hellbender.tools.spark.sv.discovery.SvType;
import org.broadinstitute.hellbender.tools.spark.sv.utils.GATKSVVCFHeaderLines;
import org.broadinstitute.hellbender.tools.spark.sv.utils.SVUtils;
import org.broadinstitute.hellbender.utils.IntervalUtils;
import org.broadinstitute.hellbender.utils.gcs.BucketUtils;

public class SVVCFWriter {
    public static void writeVCF(List<VariantContext> localVariants, String vcfFileName, SAMSequenceDictionary referenceSequenceDictionary, Set<VCFHeaderLine> defaultToolVCFHeaderLines, Logger logger) {
        List<VariantContext> sortedVariantsList = SVVCFWriter.sortVariantsByCoordinate(localVariants, referenceSequenceDictionary);
        if (logger != null) {
            SVVCFWriter.logNumOfVarByTypes(sortedVariantsList, logger);
        }
        SVVCFWriter.writeVariants(vcfFileName, sortedVariantsList, referenceSequenceDictionary, defaultToolVCFHeaderLines);
    }

    private static void logNumOfVarByTypes(List<VariantContext> variants, Logger logger) {
        logger.info("Discovered a total of " + variants.size() + " records: ");
        Map<String, Long> variantsCountByType = variants.stream().collect(Collectors.groupingBy(vc -> (String)vc.getAttribute("SVTYPE"), Collectors.counting()));
        variantsCountByType.forEach((key, value) -> logger.info("  " + key + ": " + value));
        logger.info("  And none of : " + Sets.difference(SvType.getKnownTypes(), variantsCountByType.keySet()).toString());
    }

    @VisibleForTesting
    public static List<VariantContext> sortVariantsByCoordinate(List<VariantContext> variants, SAMSequenceDictionary referenceSequenceDictionary) {
        return variants.stream().sorted((v1, v2) -> {
            String s2;
            int x = IntervalUtils.compareLocatables((Locatable)v1, (Locatable)v2, referenceSequenceDictionary);
            if (x != 0) {
                return x;
            }
            String s1 = v1.getAttributeAsString("INSSEQ", "");
            x = s1.compareTo(s2 = v2.getAttributeAsString("INSSEQ", ""));
            if (x != 0) {
                return x;
            }
            return v1.getID().compareTo(v2.getID());
        }).collect(SVUtils.arrayListCollector(variants.size()));
    }

    private static void writeVariants(String fileName, List<VariantContext> variantsArrayList, SAMSequenceDictionary referenceSequenceDictionary, Set<VCFHeaderLine> defaultToolVCFHeaderLines) {
        try (BufferedOutputStream outputStream = new BufferedOutputStream(BucketUtils.createFile(fileName));){
            VariantContextWriter vcfWriter = SVVCFWriter.getVariantContextWriter(outputStream, referenceSequenceDictionary);
            VCFHeader vcfHeader = SVVCFWriter.getVcfHeader(referenceSequenceDictionary);
            defaultToolVCFHeaderLines.forEach(arg_0 -> ((VCFHeader)vcfHeader).addMetaDataLine(arg_0));
            vcfWriter.writeHeader(vcfHeader);
            variantsArrayList.forEach(arg_0 -> ((VariantContextWriter)vcfWriter).add(arg_0));
            vcfWriter.close();
        }
        catch (IOException e) {
            throw new GATKException("Could not create output file", e);
        }
    }

    @VisibleForTesting
    static VCFHeader getVcfHeader(SAMSequenceDictionary referenceSequenceDictionary) {
        HashSet<VCFSimpleHeaderLine> headerLines = new HashSet<VCFSimpleHeaderLine>(GATKSVVCFHeaderLines.getSymbAltAlleleLines());
        headerLines.addAll(GATKSVVCFHeaderLines.getInfoLines());
        headerLines.add((VCFSimpleHeaderLine)VCFStandardHeaderLines.getInfoLine((String)"END"));
        headerLines.addAll(GATKSVVCFHeaderLines.getFormatLines());
        headerLines.addAll(GATKSVVCFHeaderLines.getFilterLines());
        VCFHeader header = new VCFHeader(new VCFHeader(headerLines));
        header.setSequenceDictionary(referenceSequenceDictionary);
        return header;
    }

    private static VariantContextWriter getVariantContextWriter(OutputStream outputStream, SAMSequenceDictionary referenceSequenceDictionary) {
        VariantContextWriterBuilder vcWriterBuilder = new VariantContextWriterBuilder().clearOptions().setOutputStream(outputStream);
        if (null != referenceSequenceDictionary) {
            vcWriterBuilder = vcWriterBuilder.setReferenceDictionary(referenceSequenceDictionary);
        }
        for (Options opt : new Options[]{}) {
            vcWriterBuilder = vcWriterBuilder.setOption(opt);
        }
        return vcWriterBuilder.build();
    }
}

