/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.spark.sv.utils;

import htsjdk.samtools.SAMFlag;
import htsjdk.samtools.reference.FastaReferenceWriter;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.broadinstitute.hellbender.exceptions.GATKException;
import org.broadinstitute.hellbender.tools.spark.sv.discovery.alignment.AlignedContig;
import org.broadinstitute.hellbender.tools.spark.sv.discovery.alignment.AlignmentInterval;
import org.broadinstitute.hellbender.utils.Utils;
import org.broadinstitute.hellbender.utils.bwa.BwaMemAligner;
import org.broadinstitute.hellbender.utils.bwa.BwaMemAlignment;
import org.broadinstitute.hellbender.utils.bwa.BwaMemIndex;

public class SingleSequenceReferenceAligner<T, U>
implements AutoCloseable {
    private final File image;
    private final BwaMemAligner aligner;
    private final BwaMemIndex index;
    private final List<String> refNames;
    private boolean closed = false;
    public static final Predicate<? super BwaMemAlignment> NO_FILTER = x -> true;
    private final Function<? super T, List<byte[]>> basesOf;
    private final TriFunction<? super T, List<List<BwaMemAlignment>>, List<String>, ? extends U> alignmentOf;
    private final Predicate<? super BwaMemAlignment> alignmentFilter;

    public SingleSequenceReferenceAligner(String name, byte[] bases, Function<? super T, List<byte[]>> basesOf, TriFunction<? super T, List<List<BwaMemAlignment>>, List<String>, ? extends U> alignmentOf) {
        this(name, bases, basesOf, alignmentOf, NO_FILTER);
    }

    public SingleSequenceReferenceAligner(String name, byte[] bases, Function<? super T, List<byte[]>> basesOf, TriFunction<? super T, List<List<BwaMemAlignment>>, List<String>, ? extends U> alignmentOf, Predicate<? super BwaMemAlignment> alignmentFilter) {
        Utils.nonNull(name, "the input reference name cannot be null");
        Utils.nonNull(bases, "the input bases cannot be null");
        this.basesOf = Utils.nonNull(basesOf);
        this.alignmentOf = Utils.nonNull(alignmentOf);
        this.alignmentFilter = Utils.nonNull(alignmentFilter);
        Utils.validate(bases.length > 0, "the reference contig bases sequence must have at least one base");
        try {
            File fasta = File.createTempFile("ssvh-temp", ".fasta");
            fasta.deleteOnExit();
            this.image = new File(fasta.getParentFile(), fasta.getName().replace(".fasta", ".img"));
            this.image.deleteOnExit();
            FastaReferenceWriter.writeSingleSequenceReference((Path)fasta.toPath(), (boolean)false, (boolean)false, (String)name, null, (byte[])bases);
            BwaMemIndex.createIndexImageFromFastaFile((String)fasta.toString(), (String)this.image.toString());
            fasta.delete();
            this.index = new BwaMemIndex(this.image.toString());
            this.aligner = new BwaMemAligner(this.index);
        }
        catch (IOException ex) {
            throw new GATKException("could not create index files", ex);
        }
        this.refNames = Collections.singletonList(name);
    }

    public BwaMemAligner getAligner() {
        return this.aligner;
    }

    public List<U> align(Iterable<? extends T> inputs) {
        Utils.nonNull(inputs);
        return this.align(Utils.stream(inputs).collect(Collectors.toList()));
    }

    public List<U> align(List<? extends T> inputs) {
        this.checkNotClosed();
        Utils.nonNull(inputs, "the input sequence array cannot be null");
        List seqs = inputs.stream().map(this.basesOf).collect(Collectors.toList());
        List flattenSeqs = seqs.stream().flatMap(Collection::stream).collect(Collectors.toList());
        List alignments = this.aligner.alignSeqs(flattenSeqs);
        if (alignments.size() != flattenSeqs.size()) {
            throw new IllegalStateException("something went terribly wrong and the number of returned alignment list does not correspond to the number of input sequences: " + alignments.size() + " != " + flattenSeqs.size());
        }
        ArrayList<U> result = new ArrayList<U>(inputs.size());
        int nextAlignmentIndex = 0;
        for (int i = 0; i < inputs.size(); ++i) {
            List filteredAlignments;
            T inputObject = inputs.get(i);
            List sequences = (List)seqs.get(i);
            List relevantAlignments = alignments.subList(nextAlignmentIndex, nextAlignmentIndex += sequences.size());
            if (this.alignmentFilter == NO_FILTER) {
                filteredAlignments = relevantAlignments;
            } else {
                filteredAlignments = new ArrayList(relevantAlignments.size());
                for (int j = 0; j < relevantAlignments.size(); ++j) {
                    filteredAlignments.add(((List)relevantAlignments.get(j)).stream().filter(this.alignmentFilter).collect(Collectors.toList()));
                }
            }
            U outputObject = this.alignmentOf.apply(inputObject, filteredAlignments, this.refNames);
            result.add(outputObject);
        }
        return result;
    }

    public <V> Map<V, U> align(List<? extends T> inputs, BiFunction<? super T, ? super U, ? extends V> keyOf) {
        List<U> outs = this.align(inputs);
        LinkedHashMap<V, U> result = new LinkedHashMap<V, U>(outs.size());
        for (int i = 0; i < outs.size(); ++i) {
            result.putIfAbsent(keyOf.apply(inputs.get(i), outs.get(i)), outs.get(i));
        }
        return result;
    }

    public static <T> SingleSequenceReferenceAligner<T, AlignedContig> contigsAligner(String refName, byte[] refBases, Function<? super T, String> nameOf, Function<? super T, byte[]> basesOf) {
        return new SingleSequenceReferenceAligner<Object, AlignedContig>(refName, refBases, t -> Collections.singletonList(basesOf.apply(t)), (t, bma, refNames) -> {
            String name = (String)nameOf.apply(t);
            byte[] bases = (byte[])basesOf.apply(t);
            List<AlignmentInterval> intervals = ((List)bma.get(0)).stream().map(b -> new AlignmentInterval((BwaMemAlignment)b, (List<String>)refNames, bases.length)).collect(Collectors.toList());
            return new AlignedContig(name, bases, intervals);
        }, bma -> bma.getRefId() >= 0 && SAMFlag.SECONDARY_ALIGNMENT.isUnset(bma.getSamFlag()));
    }

    private void checkNotClosed() {
        if (this.closed) {
            throw new IllegalStateException("operation not allowed once the aligner is closed");
        }
    }

    @Override
    public void close() throws IOException {
        if (!this.closed) {
            this.aligner.close();
            this.closed = true;
            try {
                this.index.close();
            }
            finally {
                this.image.delete();
            }
        }
    }

    @FunctionalInterface
    public static interface TriFunction<T, U, V, W> {
        public W apply(T var1, U var2, V var3);
    }
}

