/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.spark.sv.utils;

import com.esotericsoftware.kryo.DefaultSerializer;
import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import java.util.NoSuchElementException;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.broadinstitute.hellbender.utils.Utils;

@DefaultSerializer(value=Serializer.class)
public enum Strand {
    POSITIVE('+'),
    NEGATIVE('-');

    public static final Pattern PATTERN;
    private final char charEncoding;

    private Strand(char ce) {
        this.charEncoding = ce;
    }

    public static Strand decode(String ce) {
        Utils.nonNull(ce);
        if (ce.length() == 1) {
            return Strand.decode(ce.charAt(0));
        }
        throw new NoSuchElementException(String.format("there is no strand designation for encoding %s valid encodings are: %s.", ce, Stream.of(Strand.values()).map(Strand::encodeAsString).collect(Collectors.joining(", "))));
    }

    public static Strand decode(char ce) {
        if (ce == Strand.POSITIVE.charEncoding) {
            return POSITIVE;
        }
        if (ce == Strand.NEGATIVE.charEncoding) {
            return NEGATIVE;
        }
        throw new NoSuchElementException("there is no strand designation for encoding " + ce + " valid encodings are: " + Stream.of(Strand.values()).map(s -> "" + s.charEncoding).collect(Collectors.joining(", ")) + ".");
    }

    public String toString() {
        return this.encodeAsString();
    }

    String encodeAsString() {
        return "" + this.charEncoding;
    }

    public void serialize(Kryo kryo, Output output) {
        output.write(this.ordinal());
    }

    static {
        PATTERN = Pattern.compile("\\+|\\-");
    }

    public static final class Serializer
    extends com.esotericsoftware.kryo.Serializer<Strand> {
        public void write(Kryo kryo, Output output, Strand strand) {
            strand.serialize(kryo, output);
        }

        public Strand read(Kryo kryo, Input input, Class<Strand> kclass) {
            return Strand.values()[input.readInt()];
        }
    }
}

