/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.spark.sv.utils;

import com.esotericsoftware.kryo.DefaultSerializer;
import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import org.broadinstitute.hellbender.tools.spark.sv.utils.SVInterval;
import org.broadinstitute.hellbender.utils.Utils;

@DefaultSerializer(value=Serializer.class)
public class StrandedInterval {
    private static final SVInterval.Serializer intervalSerializer = new SVInterval.Serializer();
    final SVInterval interval;
    final boolean strand;

    public StrandedInterval(SVInterval interval, boolean strand) {
        Utils.validate(interval != null, "Can't construct stranded interval with null interval");
        this.interval = interval;
        this.strand = strand;
    }

    public StrandedInterval(Kryo kryo, Input input) {
        this.interval = intervalSerializer.read(kryo, input, (Class)SVInterval.class);
        this.strand = input.readBoolean();
    }

    private void serialize(Kryo kryo, Output output) {
        intervalSerializer.write(kryo, output, this.interval);
        output.writeBoolean(this.strand);
    }

    public SVInterval getInterval() {
        return this.interval;
    }

    public boolean getStrand() {
        return this.strand;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StrandedInterval that = (StrandedInterval)o;
        if (this.strand != that.strand) {
            return false;
        }
        return this.interval.equals(that.interval);
    }

    public int hashCode() {
        int result = this.interval.hashCode();
        result = 31 * result + (this.strand ? 1 : 0);
        return result;
    }

    public String toString() {
        return "StrandedInterval{interval=" + this.interval + ", strand=" + this.strand + '}';
    }

    public static final class Serializer
    extends com.esotericsoftware.kryo.Serializer<StrandedInterval> {
        public void write(Kryo kryo, Output output, StrandedInterval strandedInterval) {
            strandedInterval.serialize(kryo, output);
        }

        public StrandedInterval read(Kryo kryo, Input input, Class<StrandedInterval> klass) {
            return new StrandedInterval(kryo, input);
        }
    }
}

