/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.spark.sv.utils;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class TextMDCodec {
    static final Pattern mdPat = Pattern.compile("\\G(?:([0-9]+)|([ACTGNactgn])|(\\^[ACTGNactgn]+))");

    public static List<MDElement> parseMDString(String mdString) {
        ArrayList<MDElement> results = new ArrayList<MDElement>();
        Matcher match = mdPat.matcher(mdString);
        while (match.find()) {
            String mg = match.group(1);
            if (mg != null && !mg.isEmpty()) {
                int num = Integer.parseInt(mg);
                results.add(new MatchMDElement(num));
                continue;
            }
            mg = match.group(2);
            if (mg != null && !mg.isEmpty()) {
                results.add(new MismatchMDElement());
                continue;
            }
            mg = match.group(3);
            if (mg == null || mg.isEmpty()) continue;
            results.add(new DeletionMDElement(mg.length() - 1));
        }
        return results;
    }

    public static class DeletionMDElement
    extends MDElement {
        public DeletionMDElement(int length) {
            super(length);
        }

        @Override
        public int getLength() {
            return this.length;
        }
    }

    public static class MismatchMDElement
    extends MDElement {
        public MismatchMDElement() {
            super(1);
        }

        @Override
        public int getLength() {
            return 1;
        }
    }

    public static class MatchMDElement
    extends MDElement {
        public MatchMDElement(int length) {
            super(length);
        }

        @Override
        public int getLength() {
            return this.length;
        }
    }

    public static abstract class MDElement {
        final int length;

        public MDElement(int length) {
            this.length = length;
        }

        public abstract int getLength();

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MDElement mdElement = (MDElement)o;
            return this.length == mdElement.length;
        }

        public int hashCode() {
            return this.length;
        }
    }
}

