/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.spark.transforms;

import htsjdk.samtools.SAMFileHeader;
import java.io.Serializable;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.function.FlatMapFunction;
import org.apache.spark.broadcast.Broadcast;
import org.broadinstitute.hellbender.tools.ApplyBQSRArgumentCollection;
import org.broadinstitute.hellbender.transformers.BQSRReadTransformer;
import org.broadinstitute.hellbender.utils.Utils;
import org.broadinstitute.hellbender.utils.read.GATKRead;
import org.broadinstitute.hellbender.utils.recalibration.RecalibrationReport;

public class ApplyBQSRSparkFn {
    public static JavaRDD<GATKRead> apply(JavaRDD<GATKRead> reads, Broadcast<RecalibrationReport> reportBroadcast, SAMFileHeader readsHeader, ApplyBQSRArgumentCollection args) {
        return reads.mapPartitions((FlatMapFunction & Serializable)readsIterator -> {
            RecalibrationReport report = (RecalibrationReport)reportBroadcast.getValue();
            BQSRReadTransformer transformer = new BQSRReadTransformer(readsHeader, report, args);
            return Utils.stream(readsIterator).map(transformer::apply).iterator();
        });
    }
}

