/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.spark.transforms;

import com.google.common.collect.Iterators;
import htsjdk.samtools.SAMFileHeader;
import java.io.Serializable;
import org.apache.spark.SparkFiles;
import org.apache.spark.api.java.JavaPairRDD;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.function.FlatMapFunction;
import org.broadinstitute.hellbender.engine.ReferenceFileSource;
import org.broadinstitute.hellbender.utils.Utils;
import org.broadinstitute.hellbender.utils.io.IOUtils;
import org.broadinstitute.hellbender.utils.read.GATKRead;
import org.broadinstitute.hellbender.utils.recalibration.BaseRecalibrationEngine;
import org.broadinstitute.hellbender.utils.recalibration.QuantizationInfo;
import org.broadinstitute.hellbender.utils.recalibration.RecalUtils;
import org.broadinstitute.hellbender.utils.recalibration.RecalibrationArgumentCollection;
import org.broadinstitute.hellbender.utils.recalibration.RecalibrationReport;
import org.broadinstitute.hellbender.utils.recalibration.RecalibrationTables;
import org.broadinstitute.hellbender.utils.recalibration.covariates.StandardCovariateList;
import org.broadinstitute.hellbender.utils.variant.GATKVariant;

public final class BaseRecalibratorSparkFn {
    public static RecalibrationReport apply(JavaPairRDD<GATKRead, Iterable<GATKVariant>> readsWithVariants, SAMFileHeader header, String referenceFileName, RecalibrationArgumentCollection recalArgs) {
        JavaRDD unmergedTables = readsWithVariants.mapPartitions((FlatMapFunction & Serializable)readsWithVariantsIterator -> {
            String pathOnExecutor = SparkFiles.get((String)referenceFileName);
            ReferenceFileSource referenceDataSource = new ReferenceFileSource(IOUtils.getPath(pathOnExecutor));
            BaseRecalibrationEngine bqsr = new BaseRecalibrationEngine(recalArgs, header);
            bqsr.logCovariatesUsed();
            Utils.stream(readsWithVariantsIterator).forEach(t -> bqsr.processRead((GATKRead)t._1, referenceDataSource, (Iterable)t._2));
            return Iterators.singletonIterator((Object)bqsr.getRecalibrationTables());
        });
        RecalibrationTables emptyRecalibrationTable = new RecalibrationTables(new StandardCovariateList(recalArgs, header));
        RecalibrationTables combinedTables = (RecalibrationTables)unmergedTables.treeAggregate((Object)emptyRecalibrationTable, RecalibrationTables::inPlaceCombine, RecalibrationTables::inPlaceCombine, Math.max(1, (int)(Math.log(unmergedTables.partitions().size()) / Math.log(2.0))));
        BaseRecalibrationEngine.finalizeRecalibrationTables(combinedTables);
        QuantizationInfo quantizationInfo = new QuantizationInfo(combinedTables, recalArgs.QUANTIZING_LEVELS);
        StandardCovariateList covariates = new StandardCovariateList(recalArgs, header);
        return RecalUtils.createRecalibrationReport(recalArgs.generateReportTable(covariates.covariateNames()), quantizationInfo.generateReportTable(), RecalUtils.generateReportTables(combinedTables, covariates));
    }
}

