/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.spark.transforms.markduplicates;

import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.metrics.MetricsFile;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import org.apache.spark.Partitioner;
import org.apache.spark.api.java.JavaPairRDD;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.JavaRDDLike;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.api.java.function.FlatMapFunction2;
import org.apache.spark.api.java.function.Function;
import org.apache.spark.api.java.function.PairFunction;
import org.broadinstitute.barclay.argparser.Advanced;
import org.broadinstitute.barclay.argparser.Argument;
import org.broadinstitute.barclay.argparser.ArgumentCollection;
import org.broadinstitute.barclay.argparser.CommandLineProgramProperties;
import org.broadinstitute.barclay.help.DocumentedFeature;
import org.broadinstitute.hellbender.cmdline.argumentcollections.MarkDuplicatesSparkArgumentCollection;
import org.broadinstitute.hellbender.cmdline.argumentcollections.OpticalDuplicatesArgumentCollection;
import org.broadinstitute.hellbender.engine.GATKPath;
import org.broadinstitute.hellbender.engine.filters.ReadFilter;
import org.broadinstitute.hellbender.engine.filters.ReadFilterLibrary;
import org.broadinstitute.hellbender.engine.spark.GATKSparkTool;
import org.broadinstitute.hellbender.exceptions.GATKException;
import org.broadinstitute.hellbender.exceptions.UserException;
import org.broadinstitute.hellbender.tools.spark.transforms.markduplicates.MarkDuplicatesSparkUtils;
import org.broadinstitute.hellbender.utils.Utils;
import org.broadinstitute.hellbender.utils.read.GATKRead;
import org.broadinstitute.hellbender.utils.read.ReadUtils;
import org.broadinstitute.hellbender.utils.read.markduplicates.GATKDuplicationMetrics;
import org.broadinstitute.hellbender.utils.read.markduplicates.MarkDuplicatesScoringStrategy;
import org.broadinstitute.hellbender.utils.spark.SparkUtils;
import picard.cmdline.programgroups.ReadDataManipulationProgramGroup;
import picard.sam.markduplicates.MarkDuplicates;
import picard.sam.markduplicates.util.OpticalDuplicateFinder;
import scala.Tuple2;

@DocumentedFeature
@CommandLineProgramProperties(summary="Marks duplicates on spark", oneLineSummary="MarkDuplicates on Spark", programGroup=ReadDataManipulationProgramGroup.class)
public final class MarkDuplicatesSpark
extends GATKSparkTool {
    private static final long serialVersionUID = 1L;
    public static final String ALLOW_MULTIPLE_SORT_ORDERS_IN_INPUT_ARG = "allow-multiple-sort-orders-in-input";
    public static final String TREAT_UNSORTED_AS_ORDERED = "treat-unsorted-as-querygroup-ordered";
    @Argument(doc="the output bam", shortName="O", fullName="output", optional=false)
    protected String output;
    @Argument(doc="Path to write duplication metrics to.", optional=true, shortName="M", fullName="metrics-file")
    protected String metricsFile;
    @Advanced
    @Argument(doc="Allow non-queryname sorted inputs when specifying multiple input bams.", optional=true, fullName="allow-multiple-sort-orders-in-input")
    protected boolean allowMultipleSortOrders = false;
    @Advanced
    @Argument(doc="Treat unsorted files as query-group orderd files. WARNING: This option disables a basic safety check and may result in unexpected behavior if the file is truly unordered", optional=true, fullName="treat-unsorted-as-querygroup-ordered")
    protected boolean treatUnsortedAsOrdered = false;
    @ArgumentCollection
    protected MarkDuplicatesSparkArgumentCollection markDuplicatesSparkArgumentCollection = new MarkDuplicatesSparkArgumentCollection();
    @ArgumentCollection
    protected OpticalDuplicatesArgumentCollection opticalDuplicatesArgumentCollection = new OpticalDuplicatesArgumentCollection();
    public static int NO_OPTICAL_MARKER = -1;
    public static int OPTICAL_DUPLICATE_MARKER = -2;

    @Override
    public boolean requiresReads() {
        return true;
    }

    @Override
    public List<ReadFilter> getDefaultReadFilters() {
        return Collections.singletonList(ReadFilterLibrary.ALLOW_ALL_READS);
    }

    @Override
    public GATKSparkTool.ReadInputMergingPolicy getReadInputMergingPolicy() {
        return GATKSparkTool.ReadInputMergingPolicy.concatMerge;
    }

    public static JavaRDD<GATKRead> mark(JavaRDD<GATKRead> reads, SAMFileHeader header, MarkDuplicatesScoringStrategy scoringStrategy, OpticalDuplicateFinder opticalDuplicateFinder, int numReducers, boolean dontMarkUnmappedMates, MarkDuplicates.DuplicateTaggingPolicy taggingPolicy) {
        boolean markUnmappedMates = !dontMarkUnmappedMates;
        SAMFileHeader headerForTool = header.clone();
        JavaRDD<GATKRead> sortedReadsForMarking = SparkUtils.querynameSortReadsIfNecessary(reads, numReducers, headerForTool);
        boolean markOpticalDups = taggingPolicy != MarkDuplicates.DuplicateTaggingPolicy.DontTag;
        JavaPairRDD<MarkDuplicatesSparkUtils.IndexPair<String>, Integer> namesOfNonDuplicates = MarkDuplicatesSparkUtils.transformToDuplicateNames(headerForTool, scoringStrategy, opticalDuplicateFinder, sortedReadsForMarking, numReducers, markOpticalDups);
        JavaRDD repartitionedReadNames = namesOfNonDuplicates.mapToPair((PairFunction & Serializable)pair -> new Tuple2((Object)((MarkDuplicatesSparkUtils.IndexPair)pair._1).getIndex(), (Object)new Tuple2(((MarkDuplicatesSparkUtils.IndexPair)pair._1).getValue(), pair._2))).partitionBy((Partitioner)new KnownIndexPartitioner(sortedReadsForMarking.getNumPartitions())).values();
        return sortedReadsForMarking.zipPartitions((JavaRDDLike)repartitionedReadNames, (FlatMapFunction2 & Serializable)(readsIter, readNamesIter) -> {
            HashMap namesOfNonDuplicateReadsAndOpticalCounts = new HashMap();
            readNamesIter.forEachRemaining(tup -> {
                if (namesOfNonDuplicateReadsAndOpticalCounts.putIfAbsent(tup._1, tup._2) != null) {
                    throw new GATKException(String.format("Detected multiple mark duplicate records objects corresponding to read with name '%s', this could be the result of the file sort order being incorrect or that a previous tool has let readnames span multiple partitions", tup._1()));
                }
            });
            return Utils.stream(readsIter).peek(read -> read.setIsDuplicate(false)).peek(read -> read.setAttribute("DT", (String)null)).peek(read -> {
                if (namesOfNonDuplicateReadsAndOpticalCounts.containsKey(read.getName())) {
                    if ((Integer)namesOfNonDuplicateReadsAndOpticalCounts.get(read.getName()) == OPTICAL_DUPLICATE_MARKER) {
                        read.setIsDuplicate(true);
                        read.setAttribute("DT", "SQ");
                    } else {
                        int dupCount;
                        read.setIsDuplicate(false);
                        if ((markUnmappedMates || !read.isUnmapped()) && (dupCount = namesOfNonDuplicateReadsAndOpticalCounts.replace(read.getName(), NO_OPTICAL_MARKER).intValue()) > -1) {
                            read.setTransientAttribute("OD", dupCount);
                        }
                    }
                } else if (ReadUtils.readAndMateAreUnmapped(read)) {
                    read.setIsDuplicate(false);
                } else if (markUnmappedMates || !read.isUnmapped()) {
                    read.setIsDuplicate(true);
                    if (taggingPolicy == MarkDuplicates.DuplicateTaggingPolicy.All) {
                        read.setAttribute("DT", "LB");
                    }
                } else {
                    read.setIsDuplicate(false);
                }
            }).iterator();
        });
    }

    public static JavaRDD<GATKRead> mark(JavaRDD<GATKRead> reads, SAMFileHeader header, OpticalDuplicateFinder finder, MarkDuplicatesSparkArgumentCollection mdArgs, int numReducers) {
        return MarkDuplicatesSpark.mark(reads, header, mdArgs.duplicatesScoringStrategy, finder, numReducers, mdArgs.dontMarkUnmappedMates, mdArgs.taggingPolicy);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected void runTool(JavaSparkContext ctx) {
        SAMFileHeader mergedHeader = this.getHeaderForReads();
        if (this.readArguments.getReadPathSpecifiers().size() > 1) {
            Optional<GATKPath> badlySorted = this.readArguments.getReadPathSpecifiers().stream().filter(spec -> !this.treatAsReadGroupOrdered(this.getHeaderForReadsInput((GATKPath)spec), this.treatUnsortedAsOrdered)).findFirst();
            if (badlySorted.isPresent()) {
                if (!this.allowMultipleSortOrders) throw new UserException("Multiple inputs to MarkDuplicatesSpark detected. MarkDuplicatesSpark requires all inputs to be queryname sorted or querygroup-sorted for multi-input processing but input " + badlySorted.get() + " was sorted in " + this.getHeaderForReadsInput(badlySorted.get()) + " order");
                this.logger.info("Input files are not all grouped by read name so they will be sorted together.");
            } else if (!this.allowMultipleSortOrders) {
                mergedHeader.setGroupOrder(SAMFileHeader.GroupOrder.query);
            }
        } else if (this.treatUnsortedAsOrdered && (mergedHeader.getSortOrder().equals((Object)SAMFileHeader.SortOrder.unknown) || mergedHeader.getSortOrder().equals((Object)SAMFileHeader.SortOrder.unsorted))) {
            this.logger.warn("Input bam was marked as " + mergedHeader.getSortOrder().toString() + " but " + TREAT_UNSORTED_AS_ORDERED + " is specified so it's being treated as read name grouped");
            mergedHeader.setGroupOrder(SAMFileHeader.GroupOrder.query);
        }
        JavaRDD<GATKRead> reads = this.getReads();
        OpticalDuplicateFinder finder = new OpticalDuplicateFinder(this.opticalDuplicatesArgumentCollection.READ_NAME_REGEX, this.opticalDuplicatesArgumentCollection.OPTICAL_DUPLICATE_PIXEL_DISTANCE, null);
        if (this.markDuplicatesSparkArgumentCollection.removeSequencingDuplicates && this.markDuplicatesSparkArgumentCollection.taggingPolicy == MarkDuplicates.DuplicateTaggingPolicy.DontTag) {
            this.markDuplicatesSparkArgumentCollection.taggingPolicy = MarkDuplicates.DuplicateTaggingPolicy.OpticalOnly;
        }
        JavaRDD finalReadsForMetrics = MarkDuplicatesSpark.mark(reads, mergedHeader, finder, this.markDuplicatesSparkArgumentCollection, this.getRecommendedNumReducers());
        if (this.metricsFile != null) {
            JavaPairRDD<String, GATKDuplicationMetrics> metricsByLibrary = MarkDuplicatesSparkUtils.generateMetrics(mergedHeader, finalReadsForMetrics);
            MetricsFile resultMetrics = this.getMetricsFile();
            MarkDuplicatesSparkUtils.saveMetricsRDD(resultMetrics, mergedHeader, metricsByLibrary, this.metricsFile);
        }
        JavaRDD readsForWriting = finalReadsForMetrics;
        if (this.markDuplicatesSparkArgumentCollection.removeAllDuplicates) {
            readsForWriting = readsForWriting.filter((Function & Serializable)r -> !r.isDuplicate());
        } else if (this.markDuplicatesSparkArgumentCollection.removeSequencingDuplicates) {
            readsForWriting = readsForWriting.filter((Function & Serializable)r -> !"SQ".equals(r.getAttributeAsString("DT")));
        }
        mergedHeader.setSortOrder(SAMFileHeader.SortOrder.coordinate);
        this.writeReads(ctx, this.output, (JavaRDD<GATKRead>)readsForWriting, mergedHeader, true);
    }

    private boolean treatAsReadGroupOrdered(SAMFileHeader header, boolean treatUnsortedAsReadGrouped) {
        SAMFileHeader.SortOrder sortOrder = header.getSortOrder();
        if (ReadUtils.isReadNameGroupedBam(header)) {
            return true;
        }
        if (treatUnsortedAsReadGrouped && (sortOrder.equals((Object)SAMFileHeader.SortOrder.unknown) || sortOrder.equals((Object)SAMFileHeader.SortOrder.unsorted))) {
            this.logger.warn("Input bam was marked as " + sortOrder.toString() + " but " + TREAT_UNSORTED_AS_ORDERED + " is specified so it's being treated as read name grouped");
            return true;
        }
        return false;
    }

    private static class KnownIndexPartitioner
    extends Partitioner {
        private static final long serialVersionUID = 1L;
        private final int numPartitions;

        KnownIndexPartitioner(int numPartitions) {
            this.numPartitions = numPartitions;
        }

        public int numPartitions() {
            return this.numPartitions;
        }

        public int getPartition(Object key) {
            return (Integer)key;
        }
    }
}

