/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.spark.utils;

import java.util.Collections;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.function.Function;

public class FlatMapGluer<I, O>
implements Iterator<O> {
    private final Function<I, Iterator<O>> flatMapFunc;
    private final Iterator<? extends I> inputIterator;
    private I sentinel;
    private Iterator<O> outputIterator;

    public FlatMapGluer(Function<I, Iterator<O>> flatMapFunc, Iterator<? extends I> inputIterator) {
        this(flatMapFunc, inputIterator, null);
    }

    public FlatMapGluer(Function<I, Iterator<O>> flatMapFunc, Iterator<? extends I> inputIterator, I sentinel) {
        this.flatMapFunc = flatMapFunc;
        this.inputIterator = inputIterator;
        this.sentinel = sentinel;
        this.outputIterator = Collections.emptyIterator();
    }

    @Override
    public boolean hasNext() {
        while (!this.outputIterator.hasNext()) {
            if (this.inputIterator.hasNext()) {
                this.outputIterator = this.flatMapFunc.apply(this.inputIterator.next());
                continue;
            }
            if (this.sentinel != null) {
                this.outputIterator = this.flatMapFunc.apply(this.sentinel);
                this.sentinel = null;
                continue;
            }
            return false;
        }
        return true;
    }

    @Override
    public O next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException("Iteration is exhausted.");
        }
        return this.outputIterator.next();
    }

    public static <I, O> Iterator<O> applyMapFunc(Function<I, Iterator<O>> flatMapFunc, Iterator<? extends I> inputIterator) {
        return new FlatMapGluer<Object, O>(flatMapFunc, inputIterator, null);
    }

    public static <I, O> Iterator<O> applyMapFunc(Function<I, Iterator<O>> flatMapFunc, Iterator<? extends I> inputIterator, I sentinel) {
        return new FlatMapGluer<I, O>(flatMapFunc, inputIterator, sentinel);
    }

    public static <T> Iterator<T> concatIterators(Iterator<Iterator<T>> itrItr) {
        return new FlatMapGluer(itr -> itr, itrItr);
    }
}

