/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.spark.utils;

import com.esotericsoftware.kryo.DefaultSerializer;
import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import java.util.AbstractCollection;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.function.BiPredicate;
import java.util.function.Function;
import org.broadinstitute.hellbender.tools.spark.utils.SetSizeUtils;

@DefaultSerializer(value=Serializer.class)
public class HopscotchCollection<T>
extends AbstractCollection<T> {
    private int capacity;
    private int size;
    private T[] buckets;
    private byte[] status;
    private static final double LOAD_FACTOR = 0.85;
    private static final int NO_ELEMENT_INDEX = -1;
    private static final int SPREADER = 241;

    public HopscotchCollection() {
        this(12000);
    }

    public HopscotchCollection(int capacity) {
        this.capacity = HopscotchCollection.computeCapacity(capacity);
        this.size = 0;
        this.buckets = new Object[this.capacity];
        this.status = new byte[this.capacity];
    }

    public HopscotchCollection(Collection<? extends T> collection) {
        this(collection.size());
        this.addAll(collection);
    }

    protected HopscotchCollection(Kryo kryo, Input input) {
        boolean oldReferences = kryo.getReferences();
        kryo.setReferences(false);
        this.capacity = input.readInt();
        this.size = 0;
        this.buckets = new Object[this.capacity];
        this.status = new byte[this.capacity];
        int nElements = input.readInt();
        while (nElements-- > 0) {
            this.add((T)kryo.readClassAndObject(input));
        }
        kryo.setReferences(oldReferences);
    }

    protected void serialize(Kryo kryo, Output output) {
        int idx;
        boolean oldReferences = kryo.getReferences();
        kryo.setReferences(false);
        output.writeInt(this.capacity);
        output.writeInt(this.size);
        int count = 0;
        for (idx = 0; idx != this.capacity; ++idx) {
            if (!this.isChainHead(idx)) continue;
            kryo.writeClassAndObject(output, this.buckets[idx]);
            ++count;
        }
        for (idx = 0; idx != this.capacity; ++idx) {
            T val = this.buckets[idx];
            if (val == null || this.isChainHead(idx)) continue;
            kryo.writeClassAndObject(output, val);
            ++count;
        }
        kryo.setReferences(oldReferences);
        if (count != this.size) {
            throw new IllegalStateException("Failed to serialize the expected number of objects: expected=" + this.size + " actual=" + count + ".");
        }
    }

    @Override
    public final boolean add(T entry) {
        if (entry == null) {
            throw new UnsupportedOperationException("This collection cannot contain null.");
        }
        if (this.size == this.capacity) {
            this.resize();
        }
        BiPredicate<T, T> collision = this.entryCollides();
        try {
            return this.insert(entry, collision);
        }
        catch (IllegalStateException ise) {
            this.resize();
            return this.insert(entry, collision);
        }
    }

    @Override
    public final void clear() {
        for (int idx = 0; idx != this.capacity; ++idx) {
            this.buckets[idx] = null;
            this.status[idx] = 0;
        }
        this.size = 0;
    }

    public final int capacity() {
        return this.capacity;
    }

    @Override
    public final boolean contains(Object key) {
        return this.find(key) != null;
    }

    public final T find(Object key) {
        int offset;
        int bucketIndex = this.hashToIndex(key);
        if (!this.isChainHead(bucketIndex)) {
            return null;
        }
        T entry = this.buckets[bucketIndex];
        if (this.equivalent(entry, key)) {
            return entry;
        }
        while ((offset = this.getOffset(bucketIndex)) != 0) {
            entry = this.buckets[bucketIndex = this.getIndex(bucketIndex, offset)];
            if (!this.equivalent(entry, key)) continue;
            return entry;
        }
        return null;
    }

    public final Iterator<T> findEach(Object key) {
        return new ElementIterator(key);
    }

    @Override
    public final boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public final Iterator<T> iterator() {
        return new CompleteIterator();
    }

    @Override
    public final boolean remove(Object key) {
        int bucketIndex = this.hashToIndex(key);
        if (this.buckets[bucketIndex] == null || !this.isChainHead(bucketIndex)) {
            return false;
        }
        int predecessorIndex = -1;
        while (!this.equivalent(this.buckets[bucketIndex], key)) {
            int offset = this.getOffset(bucketIndex);
            if (offset == 0) {
                return false;
            }
            predecessorIndex = bucketIndex;
            bucketIndex = this.getIndex(bucketIndex, offset);
        }
        this.removeAtIndex(bucketIndex, predecessorIndex);
        return true;
    }

    public final boolean removeEach(Object key) {
        boolean result = false;
        ElementIterator elementItr = new ElementIterator(key);
        while (elementItr.hasNext()) {
            elementItr.next();
            elementItr.remove();
            result = true;
        }
        return result;
    }

    @Override
    public final boolean removeAll(Collection<?> collection) {
        boolean result = false;
        for (Object entry : collection) {
            if (!this.removeEach(entry)) continue;
            result = true;
        }
        return result;
    }

    @Override
    public final int size() {
        return this.size;
    }

    protected BiPredicate<T, T> entryCollides() {
        return (t1, t2) -> false;
    }

    protected Function<T, Object> toKey() {
        return i -> i;
    }

    private boolean equivalent(T entry, Object key) {
        return Objects.equals(this.toKey().apply(entry), key);
    }

    private int hashToIndex(Object entry) {
        int result;
        int n = result = entry == null ? 0 : 241 * entry.hashCode() % this.capacity;
        if (result < 0) {
            result += this.capacity;
        }
        return result;
    }

    private boolean insert(T entry, BiPredicate<T, T> collision) {
        int bucketIndex = this.hashToIndex(this.toKey().apply(entry));
        if (this.buckets[bucketIndex] != null && !this.isChainHead(bucketIndex)) {
            this.evict(bucketIndex);
        }
        if (this.buckets[bucketIndex] == null) {
            this.buckets[bucketIndex] = entry;
            this.status[bucketIndex] = -128;
            ++this.size;
            return true;
        }
        int endOfChainIndex = bucketIndex;
        while (true) {
            T tableEntry;
            if (collision.test(tableEntry = this.buckets[endOfChainIndex], entry)) {
                return false;
            }
            int offset = this.getOffset(endOfChainIndex);
            if (offset == 0) break;
            endOfChainIndex = this.getIndex(endOfChainIndex, offset);
        }
        int emptyBucketIndex = this.insertIntoChain(bucketIndex, endOfChainIndex);
        this.buckets[emptyBucketIndex] = entry;
        ++this.size;
        return true;
    }

    private void removeAtIndex(int bucketIndex, int predecessorIndex) {
        int offset = this.getOffset(bucketIndex);
        if (offset == 0) {
            this.buckets[bucketIndex] = null;
            this.status[bucketIndex] = 0;
            if (predecessorIndex != -1) {
                int n = predecessorIndex;
                this.status[n] = (byte)(this.status[n] - this.getOffset(predecessorIndex));
            }
        } else {
            int offsetToNext;
            int prevIndex = bucketIndex;
            int nextIndex = this.getIndex(prevIndex, offset);
            while ((offsetToNext = this.getOffset(nextIndex)) != 0) {
                prevIndex = nextIndex;
                nextIndex = this.getIndex(nextIndex, offsetToNext);
            }
            this.buckets[bucketIndex] = this.buckets[nextIndex];
            this.buckets[nextIndex] = null;
            int n = prevIndex;
            this.status[n] = (byte)(this.status[n] - this.getOffset(prevIndex));
        }
        --this.size;
    }

    private int insertIntoChain(int bucketIndex, int endOfChainIndex) {
        int offsetToEmpty;
        int offsetToEndOfChain = this.getIndexDiff(bucketIndex, endOfChainIndex);
        int emptyBucketIndex = this.findEmptyBucket(bucketIndex);
        int maxOffset = offsetToEndOfChain + 127;
        while ((offsetToEmpty = this.getIndexDiff(bucketIndex, emptyBucketIndex)) > maxOffset) {
            emptyBucketIndex = this.hopscotch(bucketIndex, emptyBucketIndex);
        }
        if (offsetToEmpty > offsetToEndOfChain) {
            int n = endOfChainIndex;
            this.status[n] = (byte)(this.status[n] + (offsetToEmpty - offsetToEndOfChain));
        } else {
            this.linkIntoChain(bucketIndex, emptyBucketIndex);
        }
        return emptyBucketIndex;
    }

    private void linkIntoChain(int bucketIndex, int emptyBucketIndex) {
        int offsetToEmpty;
        int offset;
        int tmpIndex = bucketIndex;
        for (offsetToEmpty = this.getIndexDiff(bucketIndex, emptyBucketIndex); (offset = this.getOffset(tmpIndex)) < offsetToEmpty; offsetToEmpty -= offset) {
            tmpIndex = this.getIndex(tmpIndex, offset);
        }
        int n = tmpIndex;
        this.status[n] = (byte)(this.status[n] - (offset -= offsetToEmpty));
        this.status[emptyBucketIndex] = (byte)offset;
    }

    private void evict(int bucketToEvictIndex) {
        int bucketIndex = this.hashToIndex(this.toKey().apply(this.buckets[bucketToEvictIndex]));
        int offsetToEvictee = this.getIndexDiff(bucketIndex, bucketToEvictIndex);
        int emptyBucketIndex = this.findEmptyBucket(bucketIndex);
        int fromIndex = bucketIndex;
        while (true) {
            if (this.getIndexDiff(bucketIndex, emptyBucketIndex) > offsetToEvictee) {
                emptyBucketIndex = this.hopscotch(fromIndex, emptyBucketIndex);
                continue;
            }
            if (emptyBucketIndex == bucketToEvictIndex) {
                return;
            }
            fromIndex = emptyBucketIndex;
            this.linkIntoChain(bucketIndex, emptyBucketIndex);
            int prevIndex = bucketIndex;
            int offsetToNext = this.getOffset(prevIndex);
            int nextIndex = this.getIndex(prevIndex, offsetToNext);
            while ((offsetToNext = this.getOffset(nextIndex)) != 0) {
                prevIndex = nextIndex;
                nextIndex = this.getIndex(nextIndex, offsetToNext);
            }
            this.buckets[emptyBucketIndex] = this.buckets[nextIndex];
            this.buckets[nextIndex] = null;
            this.status[nextIndex] = 0;
            int n = prevIndex;
            this.status[n] = (byte)(this.status[n] - this.getOffset(prevIndex));
            emptyBucketIndex = nextIndex;
        }
    }

    private int findEmptyBucket(int bucketIndex) {
        while (this.buckets[bucketIndex = this.getIndex(bucketIndex, 1)] != null) {
        }
        return bucketIndex;
    }

    private boolean isChainHead(int bucketIndex) {
        return (this.status[bucketIndex] & 0xFFFFFF80) != 0;
    }

    private int getOffset(int bucketIndex) {
        return this.status[bucketIndex] & 0x7F;
    }

    private int getIndex(int bucketIndex, int offset) {
        int result = bucketIndex + offset;
        if (result >= this.capacity) {
            result -= this.capacity;
        } else if (result < 0) {
            result += this.capacity;
        }
        return result;
    }

    private int getIndexDiff(int bucketIndex1, int bucketIndex2) {
        int result = bucketIndex2 - bucketIndex1;
        if (result < 0) {
            result += this.capacity;
        }
        return result;
    }

    private int hopscotch(int fromIndex, int emptyBucketIndex) {
        int fromToEmptyDistance = this.getIndexDiff(fromIndex, emptyBucketIndex);
        for (int offsetToEmpty = 127; offsetToEmpty > 1; --offsetToEmpty) {
            int bucketIndex = this.getIndex(emptyBucketIndex, -offsetToEmpty);
            int offsetInBucket = this.getOffset(bucketIndex);
            if (offsetInBucket == 0 || offsetInBucket >= offsetToEmpty || offsetToEmpty - offsetInBucket >= fromToEmptyDistance) continue;
            int bucketToMoveIndex = this.getIndex(bucketIndex, offsetInBucket);
            this.move(bucketIndex, bucketToMoveIndex, emptyBucketIndex);
            return bucketToMoveIndex;
        }
        throw new IllegalStateException("Hopscotching failed at load factor " + 1.0 * (double)this.size / (double)this.capacity);
    }

    private void move(int predecessorBucketIndex, int bucketToMoveIndex, int emptyBucketIndex) {
        int toEmptyDistance = this.getIndexDiff(bucketToMoveIndex, emptyBucketIndex);
        int nextOffset = this.getOffset(bucketToMoveIndex);
        if (nextOffset == 0 || nextOffset > toEmptyDistance) {
            int n = predecessorBucketIndex;
            this.status[n] = (byte)(this.status[n] + toEmptyDistance);
        } else {
            int n = predecessorBucketIndex;
            this.status[n] = (byte)(this.status[n] + nextOffset);
            toEmptyDistance -= nextOffset;
            predecessorBucketIndex = this.getIndex(bucketToMoveIndex, nextOffset);
            while ((nextOffset = this.getOffset(predecessorBucketIndex)) != 0 && nextOffset < toEmptyDistance) {
                toEmptyDistance -= nextOffset;
                predecessorBucketIndex = this.getIndex(predecessorBucketIndex, nextOffset);
            }
            this.status[predecessorBucketIndex] = (byte)toEmptyDistance;
        }
        if (nextOffset != 0) {
            this.status[emptyBucketIndex] = (byte)(nextOffset - toEmptyDistance);
        }
        this.buckets[emptyBucketIndex] = this.buckets[bucketToMoveIndex];
        this.buckets[bucketToMoveIndex] = null;
        this.status[bucketToMoveIndex] = 0;
    }

    private void resize() {
        if (this.buckets == null) {
            throw new IllegalStateException("Someone must be doing something ugly with reflection -- I have no buckets.");
        }
        int oldCapacity = this.capacity;
        int oldSize = this.size;
        T[] oldBuckets = this.buckets;
        byte[] oldStatus = this.status;
        this.capacity = SetSizeUtils.getLegalSizeAbove(this.capacity);
        this.size = 0;
        this.buckets = new Object[this.capacity];
        this.status = new byte[this.capacity];
        try {
            int idx = 0;
            do {
                T entry;
                if ((entry = oldBuckets[idx]) == null) continue;
                this.insert(entry, (t1, t2) -> false);
            } while ((idx = (idx + 127) % oldCapacity) != 0);
        }
        catch (IllegalStateException ise) {
            this.capacity = oldCapacity;
            this.size = oldSize;
            this.buckets = oldBuckets;
            this.status = oldStatus;
            throw new IllegalStateException("Hopscotching failed at load factor " + 1.0 * (double)this.size / (double)this.capacity + ", and resizing didn't help.");
        }
        if (this.size != oldSize) {
            throw new IllegalStateException("Lost some elements during resizing.");
        }
    }

    private static int computeCapacity(int size) {
        if ((double)size < 1.82536109995E9) {
            int augmentedSize = (int)((double)size / 0.85);
            for (int legalSize : SetSizeUtils.legalSizes) {
                if (legalSize < augmentedSize) continue;
                return legalSize;
            }
        }
        return SetSizeUtils.legalSizes[SetSizeUtils.legalSizes.length - 1];
    }

    public static final class Serializer<T>
    extends com.esotericsoftware.kryo.Serializer<HopscotchCollection<T>> {
        public void write(Kryo kryo, Output output, HopscotchCollection<T> hopscotchCollection) {
            hopscotchCollection.serialize(kryo, output);
        }

        public HopscotchCollection<T> read(Kryo kryo, Input input, Class<HopscotchCollection<T>> klass) {
            return new HopscotchCollection(kryo, input);
        }
    }

    private final class CompleteIterator
    extends BaseIterator {
        private int bucketHeadIndex;

        CompleteIterator() {
            this.bucketHeadIndex = -1;
            this.nextBucketHead();
        }

        @Override
        public boolean hasNext() {
            return this.bucketHeadIndex != -1;
        }

        @Override
        public T next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException("Iterator exhausted.");
            }
            this.removeIndex = this.currentIndex;
            this.removePrevIndex = this.prevIndex;
            int offset = HopscotchCollection.this.getOffset(this.currentIndex);
            if (offset == 0) {
                this.nextBucketHead();
            } else {
                this.prevIndex = this.currentIndex;
                this.currentIndex = HopscotchCollection.this.getIndex(this.currentIndex, offset);
            }
            return HopscotchCollection.this.buckets[this.removeIndex];
        }

        private void nextBucketHead() {
            while (++this.bucketHeadIndex < HopscotchCollection.this.buckets.length) {
                if (!HopscotchCollection.this.isChainHead(this.bucketHeadIndex)) continue;
                this.currentIndex = this.bucketHeadIndex;
                this.prevIndex = -1;
                return;
            }
            this.bucketHeadIndex = -1;
        }
    }

    private final class ElementIterator
    extends BaseIterator {
        private final Object key;

        ElementIterator(Object key) {
            this.key = key;
            int bucketIndex = HopscotchCollection.this.hashToIndex(key);
            if (!HopscotchCollection.this.isChainHead(bucketIndex)) {
                return;
            }
            this.currentIndex = bucketIndex;
            this.ensureEquivalence();
        }

        @Override
        public boolean hasNext() {
            return this.currentIndex != -1;
        }

        @Override
        public T next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException("HopscotchCollection.ElementIterator is exhausted.");
            }
            Object result = HopscotchCollection.this.buckets[this.currentIndex];
            this.removeIndex = this.currentIndex;
            this.removePrevIndex = this.prevIndex;
            this.advanceUntilEquivalent();
            return result;
        }

        @Override
        public void remove() {
            super.remove();
            if (this.currentIndex != -1) {
                this.ensureEquivalence();
            }
        }

        private void ensureEquivalence() {
            if (!HopscotchCollection.this.equivalent(HopscotchCollection.this.buckets[this.currentIndex], this.key)) {
                this.advanceUntilEquivalent();
            }
        }

        private void advanceUntilEquivalent() {
            do {
                int offset;
                if ((offset = HopscotchCollection.this.getOffset(this.currentIndex)) == 0) {
                    this.currentIndex = -1;
                    break;
                }
                this.prevIndex = this.currentIndex;
                this.currentIndex = HopscotchCollection.this.getIndex(this.currentIndex, offset);
            } while (!HopscotchCollection.this.equivalent(HopscotchCollection.this.buckets[this.currentIndex], this.key));
        }
    }

    private abstract class BaseIterator
    implements Iterator<T> {
        protected int currentIndex = -1;
        protected int prevIndex = -1;
        protected int removeIndex = -1;
        protected int removePrevIndex = -1;

        BaseIterator() {
        }

        @Override
        public void remove() {
            if (this.removeIndex == -1) {
                throw new IllegalStateException("Remove without next.");
            }
            HopscotchCollection.this.removeAtIndex(this.removeIndex, this.removePrevIndex);
            if (HopscotchCollection.this.buckets[this.removeIndex] != null) {
                this.currentIndex = this.removeIndex;
                this.prevIndex = this.removePrevIndex;
            }
            this.removeIndex = -1;
        }
    }
}

