/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.spark.utils;

import com.esotericsoftware.kryo.DefaultSerializer;
import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import com.google.common.annotations.VisibleForTesting;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.broadinstitute.hellbender.tools.spark.sv.utils.SVUtils;
import org.broadinstitute.hellbender.tools.spark.utils.LongHopscotchSet;
import org.broadinstitute.hellbender.tools.spark.utils.LongIterator;
import org.broadinstitute.hellbender.tools.spark.utils.SetSizeUtils;
import org.broadinstitute.hellbender.utils.Utils;

@DefaultSerializer(value=Serializer.class)
public final class LargeLongHopscotchSet
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final List<LongHopscotchSet> sets;
    private final int numSets;

    public LargeLongHopscotchSet(long numElements) {
        int partitions;
        Utils.validateArg(numElements > 0L, "Number of elements must be greater than 0");
        int elementsPerPartition = (int)Math.sqrt(numElements);
        try {
            partitions = SetSizeUtils.getLegalSizeBelow(elementsPerPartition);
        }
        catch (IllegalArgumentException e) {
            partitions = 1;
        }
        elementsPerPartition = (int)(numElements / (long)partitions + 1L);
        this.sets = new ArrayList<LongHopscotchSet>();
        for (int i = 0; i < partitions; ++i) {
            this.sets.add(new LongHopscotchSet(elementsPerPartition));
        }
        this.numSets = this.sets.size();
    }

    protected LargeLongHopscotchSet(Kryo kryo, Input stream) {
        boolean oldReferences = kryo.getReferences();
        kryo.setReferences(false);
        this.numSets = stream.readInt();
        this.sets = new ArrayList<LongHopscotchSet>(this.numSets);
        for (int i = 0; i < this.numSets; ++i) {
            this.sets.add((LongHopscotchSet)kryo.readObject(stream, LongHopscotchSet.class));
        }
        kryo.setReferences(oldReferences);
    }

    private static int longHash(long entryVal) {
        return (int)SVUtils.fnvLong64(entryVal);
    }

    protected void serialize(Kryo kryo, Output stream) {
        boolean oldReferences = kryo.getReferences();
        kryo.setReferences(false);
        stream.writeInt(this.sets.size());
        for (LongHopscotchSet set : this.sets) {
            kryo.writeObject(stream, (Object)set);
        }
        kryo.setReferences(oldReferences);
    }

    public boolean add(long entryValue) {
        int hashValue = LargeLongHopscotchSet.longHash(entryValue);
        int setIndex = this.setIndexOf(hashValue);
        return this.sets.get(setIndex).add(entryValue, hashValue);
    }

    public void addAll(long[] entryValues) {
        for (long val : entryValues) {
            this.add(val);
        }
    }

    public long size() {
        long sum = 0L;
        for (LongHopscotchSet s : this.sets) {
            sum += (long)s.size();
        }
        return sum;
    }

    @VisibleForTesting
    public Collection<LongHopscotchSet> getSets() {
        return this.sets;
    }

    public long capacity() {
        long sum = 0L;
        for (LongHopscotchSet s : this.sets) {
            sum += s.capacity();
        }
        return sum;
    }

    public boolean contains(long key) {
        int hash = LargeLongHopscotchSet.longHash(key);
        return this.sets.get(this.setIndexOf(hash)).contains(key, hash);
    }

    public boolean containsAll(long[] vals) {
        for (long val : vals) {
            if (this.contains(val)) continue;
            return false;
        }
        return true;
    }

    public LongIterator iterator() {
        return new LargeLongHopscotchSetIterator();
    }

    public boolean remove(long key) {
        int hash = LargeLongHopscotchSet.longHash(key);
        return this.sets.get(this.setIndexOf(hash)).remove(key, hash);
    }

    public boolean removeAll(long[] set) {
        boolean result = false;
        for (long val : set) {
            if (!this.remove(val)) continue;
            result = true;
        }
        return result;
    }

    public boolean isEmpty() {
        return this.size() == 0L;
    }

    private int setIndexOf(int hash) {
        return Integer.remainderUnsigned(hash, this.numSets);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof LargeLongHopscotchSet)) {
            return false;
        }
        LargeLongHopscotchSet that = (LargeLongHopscotchSet)o;
        return this.numSets == that.numSets && this.sets.equals(that.sets);
    }

    public int hashCode() {
        return this.sets.stream().mapToInt(LongHopscotchSet::hashCode).sum();
    }

    private final class LargeLongHopscotchSetIterator
    implements LongIterator {
        private final Iterator<LongHopscotchSet> outerIterator;
        private LongIterator innerIterator;

        public LargeLongHopscotchSetIterator() {
            this.outerIterator = LargeLongHopscotchSet.this.sets.iterator();
            this.innerIterator = this.outerIterator.hasNext() ? this.outerIterator.next().iterator() : null;
        }

        @Override
        public boolean hasNext() {
            if (this.innerIterator == null) {
                return false;
            }
            while (!this.innerIterator.hasNext()) {
                if (this.outerIterator.hasNext()) {
                    this.innerIterator = this.outerIterator.next().iterator();
                    continue;
                }
                this.innerIterator = null;
                return false;
            }
            return true;
        }

        @Override
        public long next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException("LargeLongHopscotchSetIterator is exhausted.");
            }
            return this.innerIterator.next();
        }
    }

    public static final class Serializer
    extends com.esotericsoftware.kryo.Serializer<LargeLongHopscotchSet> {
        public void write(Kryo kryo, Output output, LargeLongHopscotchSet hopscotchSet) {
            hopscotchSet.serialize(kryo, output);
        }

        public LargeLongHopscotchSet read(Kryo kryo, Input input, Class<LargeLongHopscotchSet> klass) {
            return new LargeLongHopscotchSet(kryo, input);
        }
    }
}

