/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.spark.utils;

import com.esotericsoftware.kryo.DefaultSerializer;
import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import com.google.common.annotations.VisibleForTesting;
import java.io.Serializable;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.stream.LongStream;
import org.broadinstitute.hellbender.tools.spark.sv.utils.SVUtils;
import org.broadinstitute.hellbender.tools.spark.utils.LongIterator;
import org.broadinstitute.hellbender.tools.spark.utils.SetSizeUtils;
import org.broadinstitute.hellbender.utils.Utils;

@DefaultSerializer(value=Serializer.class)
public final class LongHopscotchSet
implements Serializable {
    static final int bytesPerEntry = 9;
    @VisibleForTesting
    static final double LOAD_FACTOR = 0.85;
    private static final long serialVersionUID = 1L;
    private static final int NO_ELEMENT_INDEX = -1;
    private int capacity;
    private int size;
    private long[] buckets;
    private byte[] status;

    public LongHopscotchSet() {
        this(12000);
    }

    public LongHopscotchSet(int capacity) {
        this.capacity = SetSizeUtils.getLegalSizeAbove(capacity);
        this.size = 0;
        this.buckets = new long[this.capacity];
        this.status = new byte[this.capacity];
    }

    public LongHopscotchSet(long[] values) {
        this.capacity = SetSizeUtils.getLegalSizeAbove(values.length);
        this.size = 0;
        this.buckets = new long[this.capacity];
        this.status = new byte[this.capacity];
        for (long val : values) {
            this.add(val);
        }
    }

    protected LongHopscotchSet(Kryo kryo, Input stream) {
        this.capacity = stream.readInt();
        this.size = 0;
        this.buckets = new long[this.capacity];
        this.status = new byte[this.capacity];
        int nElements = stream.readInt();
        while (nElements-- > 0) {
            this.add(stream.readLong());
        }
    }

    private static long getValue(long entry) {
        return entry & Long.MAX_VALUE;
    }

    public static int longHash(long entryVal) {
        return (int)SVUtils.fnvLong64(entryVal);
    }

    protected void serialize(Kryo kryo, Output stream) {
        int idx;
        stream.writeInt(this.capacity);
        stream.writeInt(this.size);
        int count = 0;
        for (idx = 0; idx != this.capacity; ++idx) {
            if (!this.isChainHead(idx)) continue;
            stream.writeLong(LongHopscotchSet.getValue(this.buckets[idx]));
            ++count;
        }
        for (idx = 0; idx != this.capacity; ++idx) {
            long val = this.buckets[idx];
            if (this.isUnusedValue(val) || this.isChainHead(idx)) continue;
            stream.writeLong(LongHopscotchSet.getValue(val));
            ++count;
        }
        if (count != this.size) {
            throw new IllegalStateException("Failed to serialize the expected number of objects: expected=" + this.size + " actual=" + count + ".");
        }
    }

    public final boolean add(long entryValue) {
        int hashValue = LongHopscotchSet.longHash(entryValue);
        return this.add(entryValue, hashValue);
    }

    public final boolean add(long entryValue, int hashValue) {
        Utils.validateArg(this.isValidKey(entryValue), "Tried to add negative entry to LongHopScotchSet");
        if (this.size == this.capacity) {
            this.resize();
        }
        try {
            return this.insert(entryValue, hashValue);
        }
        catch (IllegalStateException ise) {
            this.resize();
            return this.insert(entryValue, hashValue);
        }
    }

    public final void clear() {
        for (int idx = 0; idx != this.capacity; ++idx) {
            this.buckets[idx] = 0L;
            this.status[idx] = 0;
        }
        this.size = 0;
    }

    public final long capacity() {
        return this.capacity;
    }

    public final boolean contains(long key) {
        return this.contains(key, LongHopscotchSet.longHash(key));
    }

    public final boolean contains(long key, int hash) {
        int offset;
        int bucketIndex = this.hashToIndex(hash);
        if (!this.isChainHead(bucketIndex)) {
            return false;
        }
        long entryVal = LongHopscotchSet.getValue(this.buckets[bucketIndex]);
        if (entryVal == key) {
            return true;
        }
        while ((offset = this.getOffset(bucketIndex)) != 0) {
            entryVal = LongHopscotchSet.getValue(this.buckets[bucketIndex = this.getIndex(bucketIndex, offset)]);
            if (entryVal != key) continue;
            return true;
        }
        return false;
    }

    public final boolean isEmpty() {
        return this.size == 0;
    }

    public final LongIterator iterator() {
        return new LongCompleteIterator();
    }

    public final boolean remove(long key) {
        return this.remove(key, LongHopscotchSet.longHash(key));
    }

    public final boolean remove(long key, int hash) {
        Utils.validateArg(this.isValidKey(key), "Tried to remove by negative key in LongHopScotchSet");
        int bucketIndex = this.hashToIndex(hash);
        if (this.isUnusedValue(this.buckets[bucketIndex]) || !this.isChainHead(bucketIndex)) {
            return false;
        }
        int predecessorIndex = -1;
        while (LongHopscotchSet.getValue(this.buckets[bucketIndex]) != key) {
            int offset = this.getOffset(bucketIndex);
            if (offset == 0) {
                return false;
            }
            predecessorIndex = bucketIndex;
            bucketIndex = this.getIndex(bucketIndex, offset);
        }
        this.removeAtIndex(bucketIndex, predecessorIndex);
        return true;
    }

    public final int size() {
        return this.size;
    }

    private int valueToIndex(long entryVal) {
        return this.hashToIndex(LongHopscotchSet.longHash(entryVal));
    }

    private int hashToIndex(int hashVal) {
        int result = hashVal % this.capacity;
        if (result < 0) {
            result += this.capacity;
        }
        return result;
    }

    private boolean isValidKey(long key) {
        return key >= 0L;
    }

    private boolean insert(long entryValue) {
        return this.insert(entryValue, LongHopscotchSet.longHash(entryValue));
    }

    private boolean insert(long entryValue, int hashValue) {
        int bucketIndex = this.hashToIndex(hashValue);
        if (!this.isUnusedValue(this.buckets[bucketIndex]) && !this.isChainHead(bucketIndex)) {
            this.evict(bucketIndex);
        }
        if (this.isUnusedValue(this.buckets[bucketIndex])) {
            this.buckets[bucketIndex] = entryValue;
            this.setOccupied(bucketIndex);
            this.status[bucketIndex] = -128;
            ++this.size;
            return true;
        }
        int endOfChainIndex = bucketIndex;
        while (true) {
            long tableEntry;
            if (LongHopscotchSet.getValue(tableEntry = this.buckets[endOfChainIndex]) == entryValue) {
                return false;
            }
            int offset = this.getOffset(endOfChainIndex);
            if (offset == 0) break;
            endOfChainIndex = this.getIndex(endOfChainIndex, offset);
        }
        int emptyBucketIndex = this.insertIntoChain(bucketIndex, endOfChainIndex);
        this.buckets[emptyBucketIndex] = entryValue;
        this.setOccupied(emptyBucketIndex);
        ++this.size;
        return true;
    }

    private void removeAtIndex(int bucketIndex, int predecessorIndex) {
        int offset = this.getOffset(bucketIndex);
        if (offset == 0) {
            this.buckets[bucketIndex] = 0L;
            this.status[bucketIndex] = 0;
            if (predecessorIndex != -1) {
                int n = predecessorIndex;
                this.status[n] = (byte)(this.status[n] - this.getOffset(predecessorIndex));
            }
        } else {
            int offsetToNext;
            int prevIndex = bucketIndex;
            int nextIndex = this.getIndex(prevIndex, offset);
            while ((offsetToNext = this.getOffset(nextIndex)) != 0) {
                prevIndex = nextIndex;
                nextIndex = this.getIndex(nextIndex, offsetToNext);
            }
            this.buckets[bucketIndex] = this.buckets[nextIndex];
            this.buckets[nextIndex] = 0L;
            int n = prevIndex;
            this.status[n] = (byte)(this.status[n] - this.getOffset(prevIndex));
        }
        --this.size;
    }

    private int insertIntoChain(int bucketIndex, int endOfChainIndex) {
        int offsetToEmpty;
        int offsetToEndOfChain = this.getIndexDiff(bucketIndex, endOfChainIndex);
        int emptyBucketIndex = this.findEmptyBucket(bucketIndex);
        int maxOffset = offsetToEndOfChain + 127;
        while ((offsetToEmpty = this.getIndexDiff(bucketIndex, emptyBucketIndex)) > maxOffset) {
            emptyBucketIndex = this.hopscotch(bucketIndex, emptyBucketIndex);
        }
        if (offsetToEmpty > offsetToEndOfChain) {
            int n = endOfChainIndex;
            this.status[n] = (byte)(this.status[n] + (offsetToEmpty - offsetToEndOfChain));
        } else {
            this.linkIntoChain(bucketIndex, emptyBucketIndex);
        }
        return emptyBucketIndex;
    }

    private void linkIntoChain(int bucketIndex, int emptyBucketIndex) {
        int offsetToEmpty;
        int offset;
        int tmpIndex = bucketIndex;
        for (offsetToEmpty = this.getIndexDiff(bucketIndex, emptyBucketIndex); (offset = this.getOffset(tmpIndex)) < offsetToEmpty; offsetToEmpty -= offset) {
            tmpIndex = this.getIndex(tmpIndex, offset);
        }
        int n = tmpIndex;
        this.status[n] = (byte)(this.status[n] - (offset -= offsetToEmpty));
        this.status[emptyBucketIndex] = (byte)offset;
    }

    private void evict(int bucketToEvictIndex) {
        int bucketIndex = this.valueToIndex(LongHopscotchSet.getValue(this.buckets[bucketToEvictIndex]));
        int offsetToEvictee = this.getIndexDiff(bucketIndex, bucketToEvictIndex);
        int emptyBucketIndex = this.findEmptyBucket(bucketIndex);
        int fromIndex = bucketIndex;
        while (true) {
            if (this.getIndexDiff(bucketIndex, emptyBucketIndex) > offsetToEvictee) {
                emptyBucketIndex = this.hopscotch(fromIndex, emptyBucketIndex);
                continue;
            }
            if (emptyBucketIndex == bucketToEvictIndex) {
                return;
            }
            fromIndex = emptyBucketIndex;
            this.linkIntoChain(bucketIndex, emptyBucketIndex);
            int prevIndex = bucketIndex;
            int offsetToNext = this.getOffset(prevIndex);
            int nextIndex = this.getIndex(prevIndex, offsetToNext);
            while ((offsetToNext = this.getOffset(nextIndex)) != 0) {
                prevIndex = nextIndex;
                nextIndex = this.getIndex(nextIndex, offsetToNext);
            }
            this.buckets[emptyBucketIndex] = this.buckets[nextIndex];
            this.buckets[nextIndex] = 0L;
            this.status[nextIndex] = 0;
            int n = prevIndex;
            this.status[n] = (byte)(this.status[n] - this.getOffset(prevIndex));
            emptyBucketIndex = nextIndex;
        }
    }

    private int findEmptyBucket(int bucketIndex) {
        while (!this.isUnusedValue(this.buckets[bucketIndex = this.getIndex(bucketIndex, 1)])) {
        }
        return bucketIndex;
    }

    private boolean isChainHead(int bucketIndex) {
        return (this.status[bucketIndex] & 0xFFFFFF80) != 0;
    }

    private int getOffset(int bucketIndex) {
        return this.status[bucketIndex] & 0x7F;
    }

    private boolean isUnusedValue(long val) {
        return val == 0L;
    }

    private void setOccupied(int bucketIndex) {
        int n = bucketIndex;
        this.buckets[n] = this.buckets[n] | Long.MIN_VALUE;
    }

    private int getIndex(int bucketIndex, int offset) {
        int result = bucketIndex + offset;
        if (result >= this.capacity) {
            result -= this.capacity;
        } else if (result < 0) {
            result += this.capacity;
        }
        return result;
    }

    private int getIndexDiff(int bucketIndex1, int bucketIndex2) {
        int result = bucketIndex2 - bucketIndex1;
        if (result < 0) {
            result += this.capacity;
        }
        return result;
    }

    private int hopscotch(int fromIndex, int emptyBucketIndex) {
        int fromToEmptyDistance = this.getIndexDiff(fromIndex, emptyBucketIndex);
        for (int offsetToEmpty = 127; offsetToEmpty > 1; --offsetToEmpty) {
            int bucketIndex = this.getIndex(emptyBucketIndex, -offsetToEmpty);
            int offsetInBucket = this.getOffset(bucketIndex);
            if (offsetInBucket == 0 || offsetInBucket >= offsetToEmpty || offsetToEmpty - offsetInBucket >= fromToEmptyDistance) continue;
            int bucketToMoveIndex = this.getIndex(bucketIndex, offsetInBucket);
            this.move(bucketIndex, bucketToMoveIndex, emptyBucketIndex);
            return bucketToMoveIndex;
        }
        throw new IllegalStateException("Hopscotching failed at load factor " + 1.0 * (double)this.size / (double)this.capacity);
    }

    private void move(int predecessorBucketIndex, int bucketToMoveIndex, int emptyBucketIndex) {
        int toEmptyDistance = this.getIndexDiff(bucketToMoveIndex, emptyBucketIndex);
        int nextOffset = this.getOffset(bucketToMoveIndex);
        if (nextOffset == 0 || nextOffset > toEmptyDistance) {
            int n = predecessorBucketIndex;
            this.status[n] = (byte)(this.status[n] + toEmptyDistance);
        } else {
            int n = predecessorBucketIndex;
            this.status[n] = (byte)(this.status[n] + nextOffset);
            toEmptyDistance -= nextOffset;
            predecessorBucketIndex = this.getIndex(bucketToMoveIndex, nextOffset);
            while ((nextOffset = this.getOffset(predecessorBucketIndex)) != 0 && nextOffset < toEmptyDistance) {
                toEmptyDistance -= nextOffset;
                predecessorBucketIndex = this.getIndex(predecessorBucketIndex, nextOffset);
            }
            this.status[predecessorBucketIndex] = (byte)toEmptyDistance;
        }
        if (nextOffset != 0) {
            this.status[emptyBucketIndex] = (byte)(nextOffset - toEmptyDistance);
        }
        this.buckets[emptyBucketIndex] = this.buckets[bucketToMoveIndex];
        this.buckets[bucketToMoveIndex] = 0L;
        this.status[bucketToMoveIndex] = 0;
    }

    private void resize() {
        if (this.buckets == null) {
            throw new IllegalStateException("Someone must be doing something ugly with reflection -- I have no buckets.");
        }
        int oldCapacity = this.capacity;
        int oldSize = this.size;
        long[] oldBuckets = this.buckets;
        byte[] oldStatus = this.status;
        this.capacity = SetSizeUtils.getLegalSizeAbove(this.capacity);
        this.size = 0;
        this.buckets = new long[this.capacity];
        this.status = new byte[this.capacity];
        try {
            int idx = 0;
            do {
                long entry;
                if (this.isUnusedValue(entry = oldBuckets[idx])) continue;
                this.insert(LongHopscotchSet.getValue(entry));
            } while ((idx = (idx + 127) % oldCapacity) != 0);
        }
        catch (IllegalStateException ise) {
            this.capacity = oldCapacity;
            this.size = oldSize;
            this.buckets = oldBuckets;
            this.status = oldStatus;
            throw new IllegalStateException("Hopscotching failed at load factor " + 1.0 * (double)this.size / (double)this.capacity + ", and resizing didn't help.");
        }
        if (this.size != oldSize) {
            throw new IllegalStateException("Lost some elements during resizing.");
        }
    }

    public boolean containsAll(long[] vals) {
        for (long val : vals) {
            if (this.contains(val)) continue;
            return false;
        }
        return true;
    }

    public void addAll(long[] entryValues) {
        for (long val : entryValues) {
            this.add(val);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LongHopscotchSet that = (LongHopscotchSet)o;
        if (this.size != that.size) {
            return false;
        }
        LongIterator itr = this.iterator();
        while (itr.hasNext()) {
            if (that.contains(itr.next())) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        return LongStream.of(this.buckets).filter(val -> !this.isUnusedValue(val)).map(LongHopscotchSet::getValue).mapToInt(Objects::hashCode).sum();
    }

    public boolean removeAll(LongHopscotchSet collection) {
        boolean result = false;
        LongIterator itr = collection.iterator();
        while (itr.hasNext()) {
            if (!this.remove(itr.next())) continue;
            result = true;
        }
        return result;
    }

    public boolean removeAll(long[] set) {
        boolean result = false;
        for (long val : set) {
            if (!this.remove(val)) continue;
            result = true;
        }
        return result;
    }

    private final class LongCompleteIterator
    extends LongBaseIterator {
        private int bucketHeadIndex;

        LongCompleteIterator() {
            this.bucketHeadIndex = -1;
            this.nextBucketHead();
        }

        @Override
        public boolean hasNext() {
            return this.bucketHeadIndex != -1;
        }

        @Override
        public long next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException("Iterator exhausted.");
            }
            this.removeIndex = this.currentIndex;
            this.removePrevIndex = this.prevIndex;
            int offset = LongHopscotchSet.this.getOffset(this.currentIndex);
            if (offset == 0) {
                this.nextBucketHead();
            } else {
                this.prevIndex = this.currentIndex;
                this.currentIndex = LongHopscotchSet.this.getIndex(this.currentIndex, offset);
            }
            return LongHopscotchSet.getValue(LongHopscotchSet.this.buckets[this.removeIndex]);
        }

        private void nextBucketHead() {
            while (++this.bucketHeadIndex < LongHopscotchSet.this.buckets.length) {
                if (!LongHopscotchSet.this.isChainHead(this.bucketHeadIndex)) continue;
                this.currentIndex = this.bucketHeadIndex;
                this.prevIndex = -1;
                return;
            }
            this.bucketHeadIndex = -1;
        }
    }

    private abstract class LongBaseIterator
    implements LongIterator {
        protected int currentIndex = -1;
        protected int prevIndex = -1;
        protected int removeIndex = -1;
        protected int removePrevIndex = -1;

        LongBaseIterator() {
        }

        @Override
        public void remove() {
            if (this.removeIndex == -1) {
                throw new IllegalStateException("Remove without next.");
            }
            LongHopscotchSet.this.removeAtIndex(this.removeIndex, this.removePrevIndex);
            if (!LongHopscotchSet.this.isUnusedValue(LongHopscotchSet.this.buckets[this.removeIndex])) {
                this.currentIndex = this.removeIndex;
                this.prevIndex = this.removePrevIndex;
            }
            this.removeIndex = -1;
        }
    }

    public static final class Serializer
    extends com.esotericsoftware.kryo.Serializer<LongHopscotchSet> {
        public void write(Kryo kryo, Output output, LongHopscotchSet hopscotchSet) {
            hopscotchSet.serialize(kryo, output);
        }

        public LongHopscotchSet read(Kryo kryo, Input input, Class<LongHopscotchSet> klass) {
            return new LongHopscotchSet(kryo, input);
        }
    }
}

