/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.spark.utils;

public final class SetSizeUtils {
    public static final int[] legalSizes = new int[]{251, 359, 509, 719, 1021, 1447, 2039, 2887, 4093, 5791, 8191, 11579, 16381, 23167, 32749, 46337, 65521, 92681, 131071, 185363, 262139, 370723, 524287, 741431, 1048573, 1482907, 0x1FFFF7, 2965819, 0x3FFFFD, 5931641, 0x7FFFF1, 11863279, 0xFFFFFD, 23726561, 33554393, 47453111, 0x3FFFFFB, 94906249, 134217689, 189812507, 0xFFFFFC7, 379625047, 0x1FFFFFFD, 759250111, 0x3FFFFFDD, 1518500213, 2147483629};

    public static int getLegalSizeAbove(long minElements, double loadFactor) {
        long augmentedSize = (long)((double)minElements / loadFactor);
        for (int legalSize : legalSizes) {
            if ((long)legalSize <= augmentedSize) continue;
            return legalSize;
        }
        throw new IllegalArgumentException("No legal sizes large enough for size " + minElements);
    }

    public static int getLegalSizeAbove(long minElements) {
        return SetSizeUtils.getLegalSizeAbove(minElements, 1.0);
    }

    public static int getLegalSizeBelow(long maxElements, double loadFactor) {
        long augmentedSize = (long)((double)maxElements / loadFactor);
        if (augmentedSize <= (long)legalSizes[0]) {
            throw new IllegalArgumentException("No legal sizes small enough for size " + maxElements);
        }
        for (int i = 1; i < legalSizes.length; ++i) {
            if (augmentedSize > (long)legalSizes[i]) continue;
            return legalSizes[i - 1];
        }
        return legalSizes[legalSizes.length - 1];
    }

    public static int getLegalSizeBelow(long maxElements) {
        return SetSizeUtils.getLegalSizeBelow(maxElements, 1.0);
    }
}

