/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.sv;

import htsjdk.tribble.Feature;
import java.util.Objects;
import org.broadinstitute.hellbender.utils.Utils;

public final class BafEvidence
implements Feature {
    final String sample;
    final String contig;
    final int position;
    final double value;

    public BafEvidence(String sample, String contig, int position, double value) {
        Utils.nonNull(sample);
        Utils.nonNull(contig);
        this.sample = sample;
        this.contig = contig;
        this.position = position;
        this.value = value;
    }

    public String getSample() {
        return this.sample;
    }

    public String getContig() {
        return this.contig;
    }

    public int getStart() {
        return this.position;
    }

    public int getEnd() {
        return this.position;
    }

    public double getValue() {
        return this.value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BafEvidence)) {
            return false;
        }
        BafEvidence that = (BafEvidence)o;
        return this.position == that.position && Double.compare(that.value, this.value) == 0 && this.sample.equals(that.sample) && this.contig.equals(that.contig);
    }

    public int hashCode() {
        return Objects.hash(this.sample, this.contig, this.position, this.value);
    }
}

