/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.sv;

import htsjdk.tribble.Feature;
import java.util.Arrays;
import java.util.Objects;
import org.broadinstitute.hellbender.utils.Utils;

public final class DepthEvidence
implements Feature {
    final String contig;
    final int start;
    final int end;
    final int[] counts;

    public DepthEvidence(String contig, int start, int end, int[] counts) {
        Utils.nonNull(contig);
        Utils.nonNull(counts);
        this.contig = contig;
        this.start = start;
        this.end = end;
        this.counts = counts;
    }

    public String getContig() {
        return this.contig;
    }

    public int getStart() {
        return this.start;
    }

    public int getEnd() {
        return this.end;
    }

    public int[] getCounts() {
        return this.counts;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DepthEvidence)) {
            return false;
        }
        DepthEvidence that = (DepthEvidence)o;
        return this.start == that.start && this.end == that.end && this.contig.equals(that.contig) && Arrays.equals(this.counts, that.counts);
    }

    public int hashCode() {
        int result = Objects.hash(this.contig, this.start, this.end);
        result = 31 * result + Arrays.hashCode(this.counts);
        return result;
    }
}

