/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.sv;

import htsjdk.tribble.Feature;
import java.util.Objects;
import org.broadinstitute.hellbender.utils.Utils;

public final class DiscordantPairEvidence
implements Feature {
    final String sample;
    final String startContig;
    final String endContig;
    final int start;
    final int end;
    final boolean startStrand;
    final boolean endStrand;

    public DiscordantPairEvidence(String sample, String startContig, int start, boolean startStrand, String endContig, int end, boolean endStrand) {
        Utils.nonNull(sample);
        Utils.nonNull(startContig);
        Utils.nonNull(endContig);
        this.sample = sample;
        this.startContig = startContig;
        this.start = start;
        this.startStrand = startStrand;
        this.endContig = endContig;
        this.end = end;
        this.endStrand = endStrand;
    }

    public String getSample() {
        return this.sample;
    }

    public String getContig() {
        return this.startContig;
    }

    public int getStart() {
        return this.start;
    }

    public boolean getStartStrand() {
        return this.startStrand;
    }

    public String getEndContig() {
        return this.endContig;
    }

    public int getEnd() {
        if (this.startContig.equals(this.endContig)) {
            return this.end;
        }
        return this.start;
    }

    public int getEndPosition() {
        return this.end;
    }

    public boolean getEndStrand() {
        return this.endStrand;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DiscordantPairEvidence)) {
            return false;
        }
        DiscordantPairEvidence that = (DiscordantPairEvidence)o;
        return this.start == that.start && this.end == that.end && this.startStrand == that.startStrand && this.endStrand == that.endStrand && this.sample.equals(that.sample) && this.startContig.equals(that.startContig) && this.endContig.equals(that.endContig);
    }

    public int hashCode() {
        return Objects.hash(this.sample, this.startContig, this.endContig, this.start, this.end, this.startStrand, this.endStrand);
    }
}

