/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.sv;

import htsjdk.samtools.SAMSequenceDictionary;
import htsjdk.samtools.util.Locatable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.broadinstitute.hellbender.utils.GenomeLoc;
import org.broadinstitute.hellbender.utils.GenomeLocParser;
import org.broadinstitute.hellbender.utils.IntervalUtils;
import org.broadinstitute.hellbender.utils.SimpleInterval;
import org.broadinstitute.hellbender.utils.Utils;
import scala.Tuple2;

public abstract class LocatableClusterEngine<T extends Locatable> {
    protected final TreeMap<GenomeLoc, Integer> genomicToBinMap;
    protected final List<GenomeLoc> coverageIntervals;
    final GenomeLocParser parser;
    protected final SAMSequenceDictionary dictionary;
    private final List<Tuple2<SimpleInterval, List<Long>>> currentClusters;
    private final Map<Long, T> idToItemMap;
    private final List<T> outputBuffer;
    private final CLUSTERING_TYPE clusteringType;
    private long currentItemId;
    private String currentContig;

    public LocatableClusterEngine(SAMSequenceDictionary dictionary, CLUSTERING_TYPE clusteringType, List<GenomeLoc> coverageIntervals) {
        this.dictionary = dictionary;
        this.clusteringType = clusteringType;
        this.currentClusters = new LinkedList<Tuple2<SimpleInterval, List<Long>>>();
        this.idToItemMap = new HashMap<Long, T>();
        this.outputBuffer = new ArrayList<T>();
        this.currentItemId = 0L;
        this.currentContig = null;
        this.parser = new GenomeLocParser(this.dictionary);
        if (coverageIntervals != null) {
            this.coverageIntervals = coverageIntervals;
            this.genomicToBinMap = new TreeMap();
            for (int i = 0; i < coverageIntervals.size(); ++i) {
                this.genomicToBinMap.put(coverageIntervals.get(i), i);
            }
        } else {
            this.genomicToBinMap = null;
            this.coverageIntervals = null;
        }
    }

    protected abstract boolean clusterTogether(T var1, T var2);

    protected abstract SimpleInterval getClusteringInterval(T var1, SimpleInterval var2);

    protected abstract T deduplicateIdenticalItems(Collection<T> var1);

    protected abstract boolean itemsAreIdentical(T var1, T var2);

    protected abstract T flattenCluster(Collection<T> var1);

    public List<T> getOutput() {
        this.flushClusters();
        List<T> output = this.clusteringType == CLUSTERING_TYPE.MAX_CLIQUE ? this.deduplicateItems(this.outputBuffer) : new ArrayList<T>(this.outputBuffer);
        this.outputBuffer.clear();
        return output;
    }

    private void resetItemIds() {
        Utils.validate(this.currentClusters.isEmpty(), "Current cluster collection not empty");
        this.currentItemId = 0L;
        this.idToItemMap.clear();
    }

    public boolean isEmpty() {
        return this.currentContig == null;
    }

    public void add(T item) {
        if (!item.getContig().equals(this.currentContig)) {
            this.flushClusters();
            this.currentContig = item.getContig();
            this.idToItemMap.put(this.currentItemId, item);
            this.seedCluster(this.currentItemId);
            ++this.currentItemId;
            return;
        }
        this.idToItemMap.put(this.currentItemId, item);
        List<Integer> clusterIdsToProcess = this.cluster(item);
        this.processFinalizedClusters(clusterIdsToProcess);
        this.deleteRedundantClusters();
        ++this.currentItemId;
    }

    public String getCurrentContig() {
        return this.currentContig;
    }

    public List<T> deduplicateItems(List<T> items) {
        List<T> sortedItems = IntervalUtils.sortLocatablesBySequenceDictionary(items, this.dictionary);
        ArrayList<Object> deduplicatedList = new ArrayList<Object>();
        int i = 0;
        while (i < sortedItems.size()) {
            int j;
            Locatable record = (Locatable)sortedItems.get(i);
            ArrayList<Integer> identicalItemIndexes = new ArrayList<Integer>();
            for (j = i + 1; j < sortedItems.size() && record.getStart() == ((Locatable)sortedItems.get(j)).getStart(); ++j) {
                Locatable other = (Locatable)sortedItems.get(j);
                if (!this.itemsAreIdentical(record, other)) continue;
                identicalItemIndexes.add(j);
            }
            if (identicalItemIndexes.isEmpty()) {
                deduplicatedList.add(record);
                ++i;
                continue;
            }
            identicalItemIndexes.add(i);
            List identicalItems = identicalItemIndexes.stream().map(sortedItems::get).collect(Collectors.toList());
            deduplicatedList.add(this.deduplicateIdenticalItems(identicalItems));
            i = j;
        }
        return deduplicatedList;
    }

    private List<Integer> cluster(T item) {
        Set linkedItemIds = this.idToItemMap.entrySet().stream().filter(other -> (long)((Long)other.getKey()).intValue() != this.currentItemId && this.clusterTogether(item, (Locatable)other.getValue())).map(Map.Entry::getKey).collect(Collectors.toCollection(LinkedHashSet::new));
        int clusterIndex = 0;
        ArrayList<Integer> clusterIdsToProcess = new ArrayList<Integer>();
        ArrayList<Integer> clustersToAdd = new ArrayList<Integer>();
        ArrayList<Integer> clustersToSeedWith = new ArrayList<Integer>();
        for (Tuple2<SimpleInterval, List<Long>> cluster : this.currentClusters) {
            SimpleInterval clusterInterval = (SimpleInterval)cluster._1;
            List clusterItemIds = (List)cluster._2;
            if (this.getClusteringInterval(item, null).getStart() > clusterInterval.getEnd()) {
                clusterIdsToProcess.add(clusterIndex);
            } else if (this.clusteringType.equals((Object)CLUSTERING_TYPE.MAX_CLIQUE)) {
                int n = (int)clusterItemIds.stream().filter(linkedItemIds::contains).count();
                if (n == clusterItemIds.size()) {
                    clustersToAdd.add(clusterIndex);
                } else if (n > 0) {
                    clustersToSeedWith.add(clusterIndex);
                }
            } else if (this.clusteringType.equals((Object)CLUSTERING_TYPE.SINGLE_LINKAGE)) {
                boolean matchesCluster = clusterItemIds.stream().anyMatch(linkedItemIds::contains);
                if (matchesCluster) {
                    clustersToAdd.add(clusterIndex);
                }
            } else {
                throw new IllegalArgumentException("Clustering algorithm for type " + this.clusteringType.name() + " not implemented");
            }
            ++clusterIndex;
        }
        Iterator<Object> iterator = clustersToAdd.iterator();
        while (iterator.hasNext()) {
            int index = (Integer)iterator.next();
            this.addToCluster(index, this.currentItemId);
        }
        iterator = clustersToSeedWith.iterator();
        while (iterator.hasNext()) {
            int index = (Integer)iterator.next();
            this.seedWithExistingCluster(this.currentItemId, index, linkedItemIds);
        }
        if (clustersToAdd.isEmpty() && clustersToSeedWith.isEmpty()) {
            this.seedCluster(this.currentItemId);
        }
        return clusterIdsToProcess;
    }

    private void processCluster(int clusterIndex) {
        Tuple2<SimpleInterval, List<Long>> cluster = this.validateClusterIndex(clusterIndex);
        List clusterItemIds = (List)cluster._2;
        this.currentClusters.remove(clusterIndex);
        List clusterItems = clusterItemIds.stream().map(this.idToItemMap::get).collect(Collectors.toList());
        this.outputBuffer.add(this.flattenCluster(clusterItems));
    }

    private void processFinalizedClusters(List<Integer> clusterIdsToProcess) {
        Set activeClusterIds = IntStream.range(0, this.currentClusters.size()).boxed().collect(Collectors.toSet());
        activeClusterIds.removeAll(clusterIdsToProcess);
        Set activeClusterItemIds = activeClusterIds.stream().flatMap(i -> ((List)this.currentClusters.get((int)i.intValue())._2).stream()).collect(Collectors.toSet());
        Set finalizedItemIds = clusterIdsToProcess.stream().flatMap(i -> ((List)this.currentClusters.get((int)i.intValue())._2).stream()).filter(i -> !activeClusterItemIds.contains(i)).collect(Collectors.toSet());
        for (int i2 = clusterIdsToProcess.size() - 1; i2 >= 0; --i2) {
            this.processCluster(clusterIdsToProcess.get(i2));
        }
        finalizedItemIds.stream().forEach(this.idToItemMap::remove);
    }

    private void deleteRedundantClusters() {
        HashSet<Integer> redundantClusterSet = new HashSet<Integer>();
        for (int i = 0; i < this.currentClusters.size(); ++i) {
            HashSet clusterSetA = new HashSet((Collection)this.currentClusters.get((int)i)._2);
            for (int j = 0; j < i; ++j) {
                HashSet clusterSetB = new HashSet((Collection)this.currentClusters.get((int)j)._2);
                if (clusterSetA.containsAll(clusterSetB)) {
                    redundantClusterSet.add(j);
                    continue;
                }
                if (clusterSetA.size() == clusterSetB.size() || !clusterSetB.containsAll(clusterSetA)) continue;
                redundantClusterSet.add(i);
            }
        }
        ArrayList redundantClustersList = new ArrayList(redundantClusterSet);
        redundantClustersList.sort(Comparator.naturalOrder());
        for (int i = redundantClustersList.size() - 1; i >= 0; --i) {
            this.currentClusters.remove((Integer)redundantClustersList.get(i));
        }
    }

    private void flushClusters() {
        while (!this.currentClusters.isEmpty()) {
            this.processCluster(0);
        }
        this.resetItemIds();
    }

    private void seedCluster(long seedId) {
        T seed = this.validateItemIndex(seedId);
        ArrayList<Long> newCluster = new ArrayList<Long>(1);
        newCluster.add(seedId);
        this.currentClusters.add((Tuple2<SimpleInterval, List<Long>>)new Tuple2((Object)this.getClusteringInterval(seed, null), newCluster));
    }

    private void seedWithExistingCluster(Long seedId, int existingClusterIndex, Set<Long> clusteringIds) {
        T seed = this.validateItemIndex(seedId);
        List existingCluster = (List)this.currentClusters.get((int)existingClusterIndex)._2;
        List validClusterIds = existingCluster.stream().filter(clusteringIds::contains).collect(Collectors.toList());
        ArrayList<Object> newCluster = new ArrayList<Object>(1 + validClusterIds.size());
        newCluster.addAll(validClusterIds);
        newCluster.add(seedId);
        this.currentClusters.add((Tuple2<SimpleInterval, List<Long>>)new Tuple2((Object)this.getClusteringInterval(seed, (SimpleInterval)this.currentClusters.get((int)existingClusterIndex)._1), newCluster));
    }

    private T validateItemIndex(long index) {
        Locatable item = (Locatable)this.idToItemMap.get(index);
        if (item == null) {
            throw new IllegalArgumentException("Item id " + index + " not found in table");
        }
        if (!this.currentContig.equals(item.getContig())) {
            throw new IllegalArgumentException("Attempted to seed new cluster with item on contig " + item.getContig() + " but the current contig is " + this.currentContig);
        }
        return (T)item;
    }

    private Tuple2<SimpleInterval, List<Long>> validateClusterIndex(int index) {
        if (index < 0 || index >= this.currentClusters.size()) {
            throw new IllegalArgumentException("Specified cluster index " + index + " is out of range.");
        }
        Tuple2<SimpleInterval, List<Long>> cluster = this.currentClusters.get(index);
        List clusterItemIds = (List)cluster._2;
        if (clusterItemIds.isEmpty()) {
            throw new IllegalArgumentException("Encountered empty cluster");
        }
        return cluster;
    }

    private void addToCluster(int clusterIndex, long itemId) {
        Locatable item = (Locatable)this.idToItemMap.get(itemId);
        if (item == null) {
            throw new IllegalArgumentException("Item id " + item + " not found in table");
        }
        if (!this.currentContig.equals(item.getContig())) {
            throw new IllegalArgumentException("Attempted to add new item on contig " + item.getContig() + " but the current contig is " + this.currentContig);
        }
        if (clusterIndex >= this.currentClusters.size()) {
            throw new IllegalArgumentException("Specified cluster index " + clusterIndex + " is greater than the largest index.");
        }
        Tuple2<SimpleInterval, List<Long>> cluster = this.currentClusters.get(clusterIndex);
        SimpleInterval clusterInterval = (SimpleInterval)cluster._1;
        List clusterItems = (List)cluster._2;
        clusterItems.add(itemId);
        SimpleInterval clusteringStartInterval = this.getClusteringInterval(item, clusterInterval);
        if (clusteringStartInterval.getStart() != clusterInterval.getStart() || clusteringStartInterval.getEnd() != clusterInterval.getEnd()) {
            this.currentClusters.remove(clusterIndex);
            this.currentClusters.add(clusterIndex, (Tuple2<SimpleInterval, List<Long>>)new Tuple2((Object)clusteringStartInterval, (Object)clusterItems));
        }
    }

    public static enum CLUSTERING_TYPE {
        SINGLE_LINKAGE,
        MAX_CLIQUE;

    }
}

