/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.sv;

import htsjdk.tribble.Feature;
import htsjdk.tribble.FeatureCodec;
import org.broadinstitute.barclay.argparser.Argument;
import org.broadinstitute.barclay.argparser.CommandLineProgramProperties;
import org.broadinstitute.barclay.argparser.ExperimentalFeature;
import org.broadinstitute.barclay.help.DocumentedFeature;
import org.broadinstitute.hellbender.cmdline.programgroups.StructuralVariantDiscoveryProgramGroup;
import org.broadinstitute.hellbender.engine.FeatureContext;
import org.broadinstitute.hellbender.engine.FeatureManager;
import org.broadinstitute.hellbender.engine.FeatureWalker;
import org.broadinstitute.hellbender.engine.GATKPath;
import org.broadinstitute.hellbender.engine.ReadsContext;
import org.broadinstitute.hellbender.engine.ReferenceContext;
import org.broadinstitute.hellbender.exceptions.UserException;
import org.broadinstitute.hellbender.tools.sv.BafEvidence;
import org.broadinstitute.hellbender.tools.sv.DepthEvidence;
import org.broadinstitute.hellbender.tools.sv.DiscordantPairEvidence;
import org.broadinstitute.hellbender.tools.sv.SplitReadEvidence;
import org.broadinstitute.hellbender.utils.codecs.BafEvidenceCodec;
import org.broadinstitute.hellbender.utils.codecs.DepthEvidenceCodec;
import org.broadinstitute.hellbender.utils.codecs.DiscordantPairEvidenceCodec;
import org.broadinstitute.hellbender.utils.codecs.SplitReadEvidenceCodec;
import org.broadinstitute.hellbender.utils.io.FeatureOutputStream;

@CommandLineProgramProperties(summary="Prints SV evidence records to a file", oneLineSummary="Prints SV evidence records", programGroup=StructuralVariantDiscoveryProgramGroup.class)
@ExperimentalFeature
@DocumentedFeature
public final class PrintSVEvidence
extends FeatureWalker<Feature> {
    public static final String EVIDENCE_FILE_NAME = "evidence-file";
    public static final String COMPRESSION_LEVEL_NAME = "compression-level";
    @Argument(doc="Input file URI with extension '.sr.txt', '.pe.txt', '.baf.txt', or '.rd.txt' (may be gzipped).", fullName="evidence-file")
    private GATKPath inputFilePath;
    @Argument(doc="Output file with an evidence extension matching the input. Will be indexed if it has a block-compressed extension (e.g. '.gz').", fullName="output", shortName="O")
    private GATKPath outputFilePath;
    @Argument(doc="Output compression level", fullName="compression-level", minValue=0.0, maxValue=9.0, optional=true)
    private int compressionLevel = 4;
    private FeatureOutputStream<DiscordantPairEvidence> peStream;
    private FeatureOutputStream<SplitReadEvidence> srStream;
    private FeatureOutputStream<BafEvidence> bafStream;
    private FeatureOutputStream<DepthEvidence> rdStream;
    private FeatureCodec<? extends Feature, ?> featureCodec;
    private Class<? extends Feature> evidenceClass;

    @Override
    protected boolean isAcceptableFeatureType(Class<? extends Feature> featureType) {
        return featureType.equals(BafEvidence.class) || featureType.equals(DepthEvidence.class) || featureType.equals(DiscordantPairEvidence.class) || featureType.equals(SplitReadEvidence.class);
    }

    @Override
    public GATKPath getDrivingFeaturePath() {
        return this.inputFilePath;
    }

    @Override
    public void onTraversalStart() {
        super.onTraversalStart();
        this.featureCodec = FeatureManager.getCodecForFile(this.inputFilePath.toPath());
        this.evidenceClass = this.featureCodec.getFeatureType();
        this.initializeOutput();
        this.writeHeader();
    }

    private void initializeOutput() {
        if (this.evidenceClass.equals(DiscordantPairEvidence.class)) {
            this.peStream = new FeatureOutputStream<DiscordantPairEvidence>(this.outputFilePath, this.featureCodec, DiscordantPairEvidenceCodec::encode, this.getBestAvailableSequenceDictionary(), this.compressionLevel);
        } else if (this.evidenceClass.equals(SplitReadEvidence.class)) {
            this.srStream = new FeatureOutputStream<SplitReadEvidence>(this.outputFilePath, this.featureCodec, SplitReadEvidenceCodec::encode, this.getBestAvailableSequenceDictionary(), this.compressionLevel);
        } else if (this.evidenceClass.equals(BafEvidence.class)) {
            this.bafStream = new FeatureOutputStream<BafEvidence>(this.outputFilePath, this.featureCodec, BafEvidenceCodec::encode, this.getBestAvailableSequenceDictionary(), this.compressionLevel);
        } else if (this.evidenceClass.equals(DepthEvidence.class)) {
            this.rdStream = new FeatureOutputStream<DepthEvidence>(this.outputFilePath, this.featureCodec, DepthEvidenceCodec::encode, this.getBestAvailableSequenceDictionary(), this.compressionLevel);
        } else {
            throw new UserException.BadInput("Unsupported evidence type: " + this.evidenceClass.getSimpleName());
        }
    }

    private void writeHeader() {
        Object header = this.getDrivingFeaturesHeader();
        if (header != null) {
            if (header instanceof String) {
                if (this.peStream != null) {
                    this.peStream.writeHeader((String)header);
                } else if (this.srStream != null) {
                    this.srStream.writeHeader((String)header);
                } else if (this.bafStream != null) {
                    this.bafStream.writeHeader((String)header);
                } else {
                    this.rdStream.writeHeader((String)header);
                }
            } else {
                throw new IllegalArgumentException("Expected header object of type " + String.class.getSimpleName());
            }
        }
    }

    @Override
    public void apply(Feature feature, ReadsContext readsContext, ReferenceContext referenceContext, FeatureContext featureContext) {
        if (this.peStream != null) {
            this.peStream.add((DiscordantPairEvidence)feature);
        } else if (this.srStream != null) {
            this.srStream.add((SplitReadEvidence)feature);
        } else if (this.bafStream != null) {
            this.bafStream.add((BafEvidence)feature);
        } else {
            this.rdStream.add((DepthEvidence)feature);
        }
    }

    @Override
    public Object onTraversalSuccess() {
        super.onTraversalSuccess();
        if (this.peStream != null) {
            this.peStream.close();
        } else if (this.srStream != null) {
            this.srStream.close();
        } else if (this.bafStream != null) {
            this.bafStream.close();
        } else {
            this.rdStream.close();
        }
        return null;
    }
}

