/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.sv;

import htsjdk.tribble.Feature;
import htsjdk.variant.variantcontext.Allele;
import htsjdk.variant.variantcontext.Genotype;
import htsjdk.variant.variantcontext.StructuralVariantType;
import htsjdk.variant.variantcontext.VariantContext;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.broadinstitute.hellbender.tools.spark.sv.utils.GATKSVVCFConstants;
import org.broadinstitute.hellbender.utils.SimpleInterval;
import org.broadinstitute.hellbender.utils.Utils;
import org.broadinstitute.hellbender.utils.codecs.SVCallRecordCodec;

public class SVCallRecord
implements Feature {
    private final String startContig;
    private final int start;
    private final boolean startStrand;
    private final String endContig;
    private final int end;
    private final boolean endStrand;
    private final StructuralVariantType type;
    private int length;
    private final List<String> algorithms;
    private final List<Genotype> genotypes;
    private LinkedHashSet<String> samples;
    private static final List<String> nonDepthCallerAttributes = Arrays.asList("END", "ALGORITHMS", "STRANDS", "SVLEN", "SVTYPE");

    public static SVCallRecord create(VariantContext variant) {
        Utils.nonNull(variant);
        Utils.validate(variant.getAttributes().keySet().containsAll(nonDepthCallerAttributes), "Call is missing attributes");
        String startContig = variant.getContig();
        int start = variant.getStart();
        String endContig = variant.getAttributeAsString("CHR2", "NA");
        int end = variant.getAttributeAsInt("END", variant.getStart());
        StructuralVariantType type = variant.getStructuralVariantType();
        List algorithms = variant.getAttributeAsStringList("ALGORITHMS", "depth");
        String strands = variant.getAttributeAsString("STRANDS", "0");
        if (strands.length() != 2) {
            throw new IllegalArgumentException("Strands field is not 2 characters long");
        }
        String startStrandChar = strands.substring(0, 1);
        if (!startStrandChar.equals(SVCallRecordCodec.STRAND_PLUS) && !startStrandChar.equals(SVCallRecordCodec.STRAND_MINUS)) {
            throw new IllegalArgumentException("Valid start strand not found");
        }
        String endStrandChar = strands.substring(1, 2);
        if (!endStrandChar.equals(SVCallRecordCodec.STRAND_PLUS) && !endStrandChar.equals(SVCallRecordCodec.STRAND_MINUS)) {
            throw new IllegalArgumentException("Valid end strand not found");
        }
        boolean startStrand = startStrandChar.equals(SVCallRecordCodec.STRAND_PLUS);
        boolean endStrand = endStrandChar.equals(SVCallRecordCodec.STRAND_PLUS);
        int length = variant.getAttributeAsInt("SVLEN", 0);
        return new SVCallRecord(startContig, start, startStrand, endContig, end, endStrand, type, length, algorithms, (List<Genotype>)variant.getGenotypes());
    }

    public static SVCallRecord createDepthOnlyFromGCNV(VariantContext variant, double minQuality) {
        boolean endStrand;
        Genotype g;
        Utils.nonNull(variant);
        if (variant.getGenotypes().size() == 1 && ((g = variant.getGenotypes().get(0)).isHomRef() || g.isNoCall() && !g.hasExtendedAttribute("CN") || (double)Integer.valueOf((String)g.getExtendedAttribute("QS")).intValue() < minQuality || SVCallRecord.isNullCall(g))) {
            return null;
        }
        List<String> algorithms = Collections.singletonList("depth");
        boolean isDel = false;
        for (Genotype g2 : variant.getGenotypes()) {
            if (g2.isHomRef() || g2.isNoCall() && !g2.hasExtendedAttribute("CN")) continue;
            if (variant.getReference().equals((Object)Allele.REF_N)) {
                if (g2.getAlleles().stream().anyMatch(a -> a.equals((Object)GATKSVVCFConstants.DEL_ALLELE))) {
                    isDel = true;
                    continue;
                }
                if (g2.getAlleles().stream().anyMatch(a -> a.equals((Object)GATKSVVCFConstants.DUP_ALLELE))) {
                    isDel = false;
                    continue;
                }
                if (g2.getAlleles().stream().allMatch(a -> a.isNoCall())) {
                    if (g2.hasExtendedAttribute("CN")) {
                        isDel = Integer.parseInt(g2.getExtendedAttribute("CN").toString()) < g2.getPloidy();
                        continue;
                    }
                    throw new IllegalStateException("Genotype for sample " + g2.getSampleName() + " at " + variant.getContig() + ":" + variant.getStart() + " had no CN attribute and will be dropped.");
                }
                throw new IllegalArgumentException("Segment VCF schema expects <DEL>, <DUP>, and no-call allele, but found " + g2.getAllele(0) + " at " + variant.getContig() + ":" + variant.getStart());
            }
            isDel = variant.getAlternateAlleles().contains(GATKSVVCFConstants.DEL_ALLELE) && !variant.getAlternateAlleles().contains(GATKSVVCFConstants.DUP_ALLELE);
        }
        boolean startStrand = isDel;
        boolean bl = endStrand = !isDel;
        StructuralVariantType type = !variant.getReference().equals((Object)Allele.REF_N) && variant.getAlternateAlleles().contains(GATKSVVCFConstants.DUP_ALLELE) && variant.getAlternateAlleles().contains(GATKSVVCFConstants.DEL_ALLELE) ? StructuralVariantType.CNV : (isDel ? StructuralVariantType.DEL : StructuralVariantType.DUP);
        String startContig = variant.getContig();
        int start = variant.getStart();
        int end = variant.getEnd();
        int length = end - start;
        return new SVCallRecord(startContig, start, startStrand, startContig, end, endStrand, type, length, algorithms, new ArrayList<Genotype>((Collection<Genotype>)variant.getGenotypes()));
    }

    private static boolean isNullCall(Genotype g) {
        return g.hasExtendedAttribute("CN") && Integer.parseInt(g.getExtendedAttribute("CN").toString()) == 0 && g.isNoCall();
    }

    public SVCallRecord(String startContig, int start, boolean startStrand, String endContig, int end, boolean endStrand, StructuralVariantType type, int length, List<String> algorithms, List<Genotype> genotypes) {
        Utils.nonNull(startContig);
        Utils.nonNull(endContig);
        Utils.nonNull(type);
        Utils.nonNull(algorithms);
        Utils.nonNull(genotypes);
        Utils.nonEmpty(algorithms);
        Utils.nonEmpty(genotypes);
        Utils.containsNoNull(algorithms, "Encountered null algorithm");
        Utils.containsNoNull(genotypes, "Encountered null genotype");
        this.startContig = startContig;
        this.start = start;
        this.startStrand = startStrand;
        this.endContig = endContig;
        this.end = end;
        this.endStrand = endStrand;
        this.type = type;
        this.length = length;
        this.algorithms = algorithms;
        this.genotypes = genotypes;
        this.samples = genotypes.stream().filter(g -> g.hasExtendedAttribute("CN")).map(Genotype::getSampleName).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    public String getContig() {
        return this.startContig;
    }

    public int getStart() {
        return this.start;
    }

    public boolean getStartStrand() {
        return this.startStrand;
    }

    public String getEndContig() {
        return this.endContig;
    }

    public int getEnd() {
        return this.end;
    }

    public boolean getEndStrand() {
        return this.endStrand;
    }

    public StructuralVariantType getType() {
        return this.type;
    }

    public boolean isCNV() {
        return this.type == StructuralVariantType.CNV || this.type == StructuralVariantType.DEL || this.type == StructuralVariantType.DUP;
    }

    public int getLength() {
        return this.length;
    }

    public List<String> getAlgorithms() {
        return this.algorithms;
    }

    public Set<String> getSamples() {
        return this.samples;
    }

    public List<Genotype> getGenotypes() {
        return this.genotypes;
    }

    public SimpleInterval getStartAsInterval() {
        return new SimpleInterval(this.startContig, this.start, this.start);
    }

    public SimpleInterval getEndAsInterval() {
        return new SimpleInterval(this.endContig, this.end, this.end);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SVCallRecord b = (SVCallRecord)obj;
        if (!this.getContig().equals(b.getContig())) {
            return false;
        }
        if (this.getStart() != b.getStart()) {
            return false;
        }
        boolean areEqual = this.getStartStrand() == b.getStartStrand();
        areEqual &= this.getEndContig() == b.getEndContig();
        areEqual &= this.getEnd() == b.getEnd();
        areEqual &= this.getEndStrand() == b.getEndStrand();
        areEqual &= this.getType() == b.getType();
        areEqual &= this.getLength() == b.getLength();
        areEqual &= this.getAlgorithms().containsAll(b.getAlgorithms());
        areEqual &= b.getAlgorithms().containsAll(this.getAlgorithms());
        areEqual &= this.getSamples().containsAll(b.getSamples());
        areEqual &= b.getSamples().containsAll(this.getSamples());
        areEqual &= this.getGenotypes().containsAll(b.getGenotypes());
        return areEqual &= b.getGenotypes().containsAll(this.getGenotypes());
    }

    public int hashCode() {
        return Objects.hash(this.algorithms, this.end, this.endContig, this.endStrand, this.genotypes, this.length, this.samples, this.start, this.startContig, this.startStrand, this.type);
    }
}

