/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.sv;

import htsjdk.variant.variantcontext.Genotype;
import htsjdk.variant.variantcontext.StructuralVariantType;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.broadinstitute.hellbender.tools.sv.DiscordantPairEvidence;
import org.broadinstitute.hellbender.tools.sv.SVCallRecord;
import org.broadinstitute.hellbender.tools.sv.SplitReadSite;
import org.broadinstitute.hellbender.utils.Utils;

public class SVCallRecordWithEvidence
extends SVCallRecord {
    private final List<SplitReadSite> startSplitReadSites;
    private final List<SplitReadSite> endSplitReadSites;
    private final List<DiscordantPairEvidence> discordantPairs;

    public SVCallRecordWithEvidence(SVCallRecord record) {
        super(record.getContig(), record.getStart(), record.getStartStrand(), record.getEndContig(), record.getEnd(), record.getEndStrand(), record.getType(), record.getLength(), record.getAlgorithms(), record.getGenotypes());
        this.startSplitReadSites = Collections.emptyList();
        this.endSplitReadSites = Collections.emptyList();
        this.discordantPairs = Collections.emptyList();
    }

    public SVCallRecordWithEvidence(String startContig, int start, boolean startStrand, String endContig, int end, boolean endStrand, StructuralVariantType type, int length, List<String> algorithms, List<Genotype> genotypes, List<SplitReadSite> startSplitReadSites, List<SplitReadSite> endSplitReadSites, List<DiscordantPairEvidence> discordantPairs) {
        super(startContig, start, startStrand, endContig, end, endStrand, type, length, algorithms, genotypes);
        Utils.nonNull(startSplitReadSites);
        Utils.nonNull(endSplitReadSites);
        Utils.nonNull(discordantPairs);
        Utils.containsNoNull(startSplitReadSites, "Encountered null in start split reads");
        Utils.containsNoNull(endSplitReadSites, "Encountered null in end split reads");
        Utils.containsNoNull(discordantPairs, "Encountered null in discordant pairs");
        this.startSplitReadSites = startSplitReadSites;
        this.endSplitReadSites = endSplitReadSites;
        this.discordantPairs = discordantPairs;
    }

    public List<DiscordantPairEvidence> getDiscordantPairs() {
        return this.discordantPairs;
    }

    public List<SplitReadSite> getStartSplitReadSites() {
        return this.startSplitReadSites;
    }

    public List<SplitReadSite> getEndSplitReadSites() {
        return this.endSplitReadSites;
    }

    @Override
    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SVCallRecordWithEvidence b = (SVCallRecordWithEvidence)obj;
        boolean areEqual = this.getDiscordantPairs().containsAll(b.getDiscordantPairs());
        areEqual &= b.getDiscordantPairs().containsAll(this.getDiscordantPairs());
        areEqual &= this.getEndSplitReadSites().containsAll(b.getEndSplitReadSites());
        areEqual &= b.getEndSplitReadSites().containsAll(this.getEndSplitReadSites());
        areEqual &= this.getStartSplitReadSites().containsAll(b.getStartSplitReadSites());
        return areEqual &= b.getStartSplitReadSites().containsAll(this.getStartSplitReadSites());
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.discordantPairs, this.endSplitReadSites, this.startSplitReadSites);
    }

    String prettyPrint() {
        return this.getContig() + ":" + this.getStart() + "-" + this.getEnd();
    }
}

