/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.sv;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.primitives.Doubles;
import htsjdk.samtools.SAMSequenceDictionary;
import htsjdk.variant.variantcontext.Genotype;
import htsjdk.variant.variantcontext.StructuralVariantType;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.math3.stat.descriptive.moment.Mean;
import org.broadinstitute.hellbender.tools.sv.LocatableClusterEngine;
import org.broadinstitute.hellbender.tools.sv.SVCallRecord;
import org.broadinstitute.hellbender.tools.sv.SVCallRecordWithEvidence;
import org.broadinstitute.hellbender.utils.IntervalUtils;
import org.broadinstitute.hellbender.utils.SimpleInterval;

public class SVClusterEngine
extends LocatableClusterEngine<SVCallRecordWithEvidence> {
    @VisibleForTesting
    public static final double MIN_RECIPROCAL_OVERLAP_DEPTH = 0.8;
    @VisibleForTesting
    public static final int MAX_BREAKEND_CLUSTERING_WINDOW = 300;
    private final double BREAKEND_CLUSTERING_WINDOW_FRACTION = 0.5;
    private final int MIN_BREAKEND_CLUSTERING_WINDOW = 50;
    private final int MIXED_CLUSTERING_WINDOW = 2000;
    private BreakpointSummaryStrategy breakpointSummaryStrategy;

    public SVClusterEngine(SAMSequenceDictionary dictionary) {
        super(dictionary, LocatableClusterEngine.CLUSTERING_TYPE.MAX_CLIQUE, null);
        this.breakpointSummaryStrategy = BreakpointSummaryStrategy.MEDIAN_START_MEDIAN_END;
    }

    public SVClusterEngine(SAMSequenceDictionary dictionary, boolean depthOnly, BreakpointSummaryStrategy strategy) {
        super(dictionary, depthOnly ? LocatableClusterEngine.CLUSTERING_TYPE.SINGLE_LINKAGE : LocatableClusterEngine.CLUSTERING_TYPE.MAX_CLIQUE, null);
        this.breakpointSummaryStrategy = strategy;
    }

    @Override
    protected SVCallRecordWithEvidence flattenCluster(Collection<SVCallRecordWithEvidence> cluster) {
        int newEnd;
        int newStart;
        StructuralVariantType clusterType;
        List startPositions = cluster.stream().map(SVCallRecord::getStart).sorted().collect(Collectors.toList());
        List endPositions = cluster.stream().map(SVCallRecord::getEnd).sorted().collect(Collectors.toList());
        int medianStart = (Integer)startPositions.get(startPositions.size() / 2);
        int medianEnd = (Integer)endPositions.get(endPositions.size() / 2);
        SVCallRecordWithEvidence exampleCall = cluster.iterator().next();
        int length = exampleCall.getContig().equals(exampleCall.getEndContig()) && !exampleCall.getType().equals((Object)StructuralVariantType.INS) ? medianEnd - medianStart + 1 : exampleCall.getLength();
        List<String> algorithms = cluster.stream().flatMap(v -> v.getAlgorithms().stream()).distinct().collect(Collectors.toList());
        List<Genotype> clusterSamples = cluster.stream().flatMap(v -> v.getGenotypes().stream()).collect(Collectors.toList());
        List observedTypes = cluster.stream().map(SVCallRecord::getType).distinct().collect(Collectors.toList());
        StructuralVariantType structuralVariantType = clusterType = observedTypes.size() == 1 ? (StructuralVariantType)observedTypes.get(0) : StructuralVariantType.CNV;
        if (exampleCall.getType().equals((Object)StructuralVariantType.INS)) {
            int mean;
            newStart = mean = (medianStart + medianEnd) / 2;
            newEnd = mean;
        } else {
            switch (this.breakpointSummaryStrategy) {
                case MEDIAN_START_MEDIAN_END: {
                    newStart = medianStart;
                    newEnd = medianEnd;
                    break;
                }
                case MIN_START_MAX_END: {
                    newStart = (Integer)startPositions.stream().min(Integer::compareTo).orElse(startPositions.get(0));
                    newEnd = (Integer)endPositions.stream().max(Integer::compareTo).orElse(endPositions.get(0));
                    break;
                }
                case MAX_START_MIN_END: {
                    newStart = (Integer)startPositions.stream().max(Integer::compareTo).orElse(startPositions.get(0));
                    newEnd = (Integer)endPositions.stream().min(Integer::compareTo).orElse(endPositions.get(0));
                    break;
                }
                case MEAN_START_MEAN_END: {
                    newStart = (int)Math.round(new Mean().evaluate(Doubles.toArray(startPositions)));
                    newEnd = (int)Math.round(new Mean().evaluate(Doubles.toArray(endPositions)));
                    break;
                }
                default: {
                    newStart = medianStart;
                    newEnd = medianEnd;
                }
            }
        }
        return new SVCallRecordWithEvidence(exampleCall.getContig(), newStart, exampleCall.getStartStrand(), exampleCall.getEndContig(), newEnd, exampleCall.getEndStrand(), clusterType, length, algorithms, clusterSamples, exampleCall.getStartSplitReadSites(), exampleCall.getEndSplitReadSites(), exampleCall.getDiscordantPairs());
    }

    @Override
    protected boolean clusterTogether(SVCallRecordWithEvidence a, SVCallRecordWithEvidence b) {
        if (a.isCNV() != b.isCNV()) {
            return false;
        }
        boolean depthOnlyA = SVClusterEngine.isDepthOnlyCall(a);
        boolean depthOnlyB = SVClusterEngine.isDepthOnlyCall(b);
        if (depthOnlyA && depthOnlyB) {
            return this.clusterTogetherBothDepthOnly(a, b);
        }
        if (depthOnlyA != depthOnlyB) {
            return this.clusterTogetherMixedEvidence(a, b);
        }
        return this.clusterTogetherBothWithEvidence(a, b);
    }

    @Override
    protected SimpleInterval getClusteringInterval(SVCallRecordWithEvidence call, SimpleInterval clusterMinStartInterval) {
        int maxStart;
        int minStart;
        if (SVClusterEngine.isDepthOnlyCall(call)) {
            minStart = (int)((double)call.getEnd() - (double)call.getLength() / 0.8);
            maxStart = (int)((double)call.getStart() + 0.19999999999999996 * (double)call.getLength());
        } else {
            minStart = call.getStart() - 300;
            maxStart = call.getStart() + 300;
        }
        String currentContig = this.getCurrentContig();
        if (clusterMinStartInterval == null) {
            return IntervalUtils.trimIntervalToContig(currentContig, minStart, maxStart, this.dictionary.getSequence(currentContig).getSequenceLength());
        }
        int newMinStart = Math.min(minStart, clusterMinStartInterval.getStart());
        int newMaxStart = Math.max(maxStart, clusterMinStartInterval.getEnd());
        return IntervalUtils.trimIntervalToContig(currentContig, newMinStart, newMaxStart, this.dictionary.getSequence(currentContig).getSequenceLength());
    }

    @Override
    protected boolean itemsAreIdentical(SVCallRecordWithEvidence a, SVCallRecordWithEvidence b) {
        return a.getContig().equals(b.getContig()) && a.getStart() == b.getStart() && a.getEndContig().equals(b.getEndContig()) && a.getEnd() == b.getEnd() && a.getType().equals((Object)b.getType()) && a.getStartStrand() == b.getStartStrand() && a.getEndStrand() == b.getEndStrand();
    }

    @Override
    protected SVCallRecordWithEvidence deduplicateIdenticalItems(Collection<SVCallRecordWithEvidence> items) {
        if (items.isEmpty()) {
            return null;
        }
        List<Genotype> genotypes = items.stream().map(SVCallRecord::getGenotypes).flatMap(Collection::stream).collect(Collectors.toList());
        List<String> algorithms = items.stream().map(SVCallRecord::getAlgorithms).flatMap(Collection::stream).distinct().collect(Collectors.toList());
        SVCallRecordWithEvidence example = items.iterator().next();
        return new SVCallRecordWithEvidence(example.getContig(), example.getStart(), example.getStartStrand(), example.getEndContig(), example.getEnd(), example.getEndStrand(), example.getType(), example.getLength(), algorithms, genotypes, example.getStartSplitReadSites(), example.getEndSplitReadSites(), example.getDiscordantPairs());
    }

    private boolean clusterTogetherBothDepthOnly(SVCallRecordWithEvidence a, SVCallRecordWithEvidence b) {
        if (!a.getContig().equals(a.getEndContig()) || !b.getContig().equals(b.getEndContig())) {
            throw new IllegalArgumentException("Attempted to cluster depth-only calls with endpoints on different contigs");
        }
        SimpleInterval intervalA = new SimpleInterval(a.getContig(), a.getStart(), a.getEnd());
        SimpleInterval intervalB = new SimpleInterval(b.getContig(), b.getStart(), b.getEnd());
        return IntervalUtils.isReciprocalOverlap(intervalA, intervalB, 0.8);
    }

    private boolean clusterTogetherBothWithEvidence(SVCallRecordWithEvidence a, SVCallRecordWithEvidence b) {
        boolean intrachromosomalB;
        boolean intrachromosomalA = a.getContig().equals(a.getEndContig());
        if (intrachromosomalA != (intrachromosomalB = b.getContig().equals(b.getEndContig()))) {
            return false;
        }
        SimpleInterval intervalAStart = this.getStartClusteringInterval(a);
        SimpleInterval intervalAEnd = this.getEndClusteringInterval(a);
        SimpleInterval intervalBStart = this.getStartClusteringInterval(b);
        SimpleInterval intervalBEnd = this.getEndClusteringInterval(b);
        return intervalAStart.overlaps(intervalBStart) && intervalAEnd.overlaps(intervalBEnd);
    }

    private boolean clusterTogetherMixedEvidence(SVCallRecordWithEvidence a, SVCallRecordWithEvidence b) {
        boolean intrachromosomalA = a.getContig().equals(a.getEndContig());
        boolean intrachromosomalB = b.getContig().equals(b.getEndContig());
        if (!intrachromosomalA || !intrachromosomalB) {
            return false;
        }
        if (!a.getContig().equals(b.getContig())) {
            return false;
        }
        return Math.abs(a.getStart() - b.getStart()) < 2000 && Math.abs(a.getEnd() - b.getEnd()) < 2000;
    }

    private SimpleInterval getStartClusteringInterval(SVCallRecordWithEvidence call) {
        if (this.genomicToBinMap == null) {
            int padding = this.getEndpointClusteringPadding(call);
            return call.getStartAsInterval().expandWithinContig(padding, this.dictionary);
        }
        return call.getStartAsInterval();
    }

    private SimpleInterval getEndClusteringInterval(SVCallRecordWithEvidence call) {
        if (this.genomicToBinMap == null) {
            int padding = this.getEndpointClusteringPadding(call);
            return call.getEndAsInterval().expandWithinContig(padding, this.dictionary);
        }
        return call.getStartAsInterval();
    }

    private int getEndpointClusteringPadding(SVCallRecordWithEvidence call) {
        return (int)Math.min(300.0, Math.max(50.0, 0.5 * (double)call.getLength()));
    }

    public static boolean isDepthOnlyCall(SVCallRecordWithEvidence call) {
        return call.getAlgorithms().size() == 1 && call.getAlgorithms().get(0).equals("depth");
    }

    public static double getMinReciprocalOverlap() {
        return 0.8;
    }

    public static enum BreakpointSummaryStrategy {
        MEDIAN_START_MEDIAN_END,
        MIN_START_MAX_END,
        MAX_START_MIN_END,
        MEAN_START_MEAN_END;

    }
}

