/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.sv;

import com.google.common.annotations.VisibleForTesting;
import htsjdk.samtools.SAMSequenceDictionary;
import htsjdk.variant.variantcontext.Genotype;
import htsjdk.variant.variantcontext.GenotypeBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.broadinstitute.hellbender.exceptions.GATKException;
import org.broadinstitute.hellbender.exceptions.UserException;
import org.broadinstitute.hellbender.tools.sv.LocatableClusterEngine;
import org.broadinstitute.hellbender.tools.sv.SVCallRecord;
import org.broadinstitute.hellbender.tools.sv.SVCallRecordWithEvidence;
import org.broadinstitute.hellbender.utils.GenomeLoc;
import org.broadinstitute.hellbender.utils.IntervalUtils;
import org.broadinstitute.hellbender.utils.SimpleInterval;
import org.broadinstitute.hellbender.utils.Utils;

public class SVDepthOnlyCallDefragmenter
extends LocatableClusterEngine<SVCallRecordWithEvidence> {
    private final double minSampleOverlap;
    private final double paddingFraction;
    private static final double DEFAULT_MIN_SAMPLE_OVERLAP = 0.9;
    @VisibleForTesting
    protected static final double DEFAULT_PADDING_FRACTION = 0.5;

    public SVDepthOnlyCallDefragmenter(SAMSequenceDictionary dictionary) {
        this(dictionary, 0.5, 0.9, null);
    }

    public SVDepthOnlyCallDefragmenter(SAMSequenceDictionary dictionary, double paddingFraction, double minSampleOverlap, List<GenomeLoc> coverageIntervals) {
        super(dictionary, LocatableClusterEngine.CLUSTERING_TYPE.SINGLE_LINKAGE, coverageIntervals);
        this.minSampleOverlap = minSampleOverlap;
        this.paddingFraction = paddingFraction;
    }

    @Override
    protected SVCallRecordWithEvidence flattenCluster(Collection<SVCallRecordWithEvidence> cluster) {
        int newStart = cluster.stream().mapToInt(SVCallRecord::getStart).min().getAsInt();
        int newEnd = cluster.stream().mapToInt(SVCallRecord::getEnd).max().getAsInt();
        SVCallRecordWithEvidence exampleCall = cluster.iterator().next();
        int length = newEnd - newStart + 1;
        List<String> algorithms = cluster.stream().flatMap(v -> v.getAlgorithms().stream()).distinct().collect(Collectors.toList());
        List<Genotype> clusterGenotypes = this.deduplicateGenotypes(cluster.stream().flatMap(v -> v.getGenotypes().stream()).collect(Collectors.toList()));
        return new SVCallRecordWithEvidence(exampleCall.getContig(), newStart, exampleCall.getStartStrand(), exampleCall.getEndContig(), newEnd, exampleCall.getEndStrand(), exampleCall.getType(), length, algorithms, clusterGenotypes, exampleCall.getStartSplitReadSites(), exampleCall.getEndSplitReadSites(), exampleCall.getDiscordantPairs());
    }

    protected List<Genotype> deduplicateGenotypes(List<Genotype> clusterGenotypes) {
        Set samples = clusterGenotypes.stream().filter(Genotype::isCalled).map(Genotype::getSampleName).collect(Collectors.toCollection(LinkedHashSet::new));
        if (samples.size() == clusterGenotypes.size()) {
            return clusterGenotypes;
        }
        ArrayList<Genotype> mergedGenotypes = new ArrayList<Genotype>();
        LinkedHashMap moreGenotypes = new LinkedHashMap();
        for (Genotype g : clusterGenotypes) {
            if (!moreGenotypes.containsKey(g.getSampleName())) {
                ArrayList<Genotype> newList = new ArrayList<Genotype>();
                newList.add(g);
                moreGenotypes.put(g.getSampleName(), newList);
                continue;
            }
            ((List)moreGenotypes.get(g.getSampleName())).add(g);
        }
        for (List gList : moreGenotypes.values()) {
            if (gList.size() > 1) {
                mergedGenotypes.add(this.defragmentGenotypes(gList));
                continue;
            }
            if (gList.size() != 1) continue;
            mergedGenotypes.add((Genotype)gList.get(0));
        }
        return mergedGenotypes;
    }

    private Genotype defragmentGenotypes(List<Genotype> genotypesForSameSample) {
        String sampleName = genotypesForSameSample.get(0).getSampleName();
        if (!genotypesForSameSample.stream().allMatch(g -> g.getSampleName().equals(sampleName))) {
            throw new IllegalArgumentException("This method expects a list of genotypes from the same sample, but not all input genotypes represent sample " + sampleName + ".");
        }
        GenotypeBuilder gb = new GenotypeBuilder(genotypesForSameSample.get(0));
        gb.noAttributes();
        int copyNumber = Integer.parseInt(genotypesForSameSample.get(0).getExtendedAttribute("CN").toString());
        if (genotypesForSameSample.stream().allMatch(g -> Integer.parseInt(g.getExtendedAttribute("CN").toString()) == copyNumber)) {
            gb.attribute("CN", (Object)copyNumber);
            return gb.make();
        }
        throw new IllegalArgumentException("This method will only merge genotypes with the same copy number. Expected all genotypes to be copy number " + copyNumber + ".");
    }

    @Override
    protected boolean clusterTogether(SVCallRecordWithEvidence a, SVCallRecordWithEvidence b) {
        if (!SVDepthOnlyCallDefragmenter.isDepthOnlyCall(a) || !SVDepthOnlyCallDefragmenter.isDepthOnlyCall(b)) {
            return false;
        }
        Utils.validate(a.getContig().equals(a.getEndContig()), "Call A is depth-only but interchromosomal");
        Utils.validate(b.getContig().equals(b.getEndContig()), "Call B is depth-only but interchromosomal");
        if (!a.getType().equals((Object)b.getType())) {
            return false;
        }
        LinkedHashSet<String> sharedSamples = new LinkedHashSet<String>(a.getSamples());
        sharedSamples.retainAll(b.getSamples());
        double sampleOverlap = Math.min((double)sharedSamples.size() / (double)a.getSamples().size(), (double)sharedSamples.size() / (double)b.getSamples().size());
        if (sampleOverlap < this.minSampleOverlap) {
            return false;
        }
        boolean copyNumbersAgree = true;
        if (a.getGenotypes().size() == 1 && b.getGenotypes().size() == 1 && a.getGenotypes().get(0).getSampleName().equals(b.getGenotypes().get(0).getSampleName()) && a.getGenotypes().get(0).hasExtendedAttribute("CN") && b.getGenotypes().get(0).hasExtendedAttribute("CN") && !a.getGenotypes().get(0).getExtendedAttribute("CN").equals(b.getGenotypes().get(0).getExtendedAttribute("CN"))) {
            copyNumbersAgree = false;
        }
        return this.getClusteringInterval(a, (SimpleInterval)null).overlaps(this.getClusteringInterval(b, (SimpleInterval)null)) && copyNumbersAgree;
    }

    @Override
    protected SimpleInterval getClusteringInterval(SVCallRecordWithEvidence call, SimpleInterval currentClusterInterval) {
        int paddedCallEnd;
        int paddedCallStart;
        Utils.nonNull(call);
        SimpleInterval callInterval = this.getCallInterval(call);
        if (this.genomicToBinMap != null) {
            GenomeLoc callStart = this.parser.createGenomeLoc(call.getContig(), call.getStart(), call.getStart());
            GenomeLoc callEnd = this.parser.createGenomeLoc(call.getContig(), call.getEnd(), call.getEnd());
            Map.Entry startBin = this.genomicToBinMap.ceilingEntry(callStart);
            if (startBin == null) {
                throw new UserException.BadInput("Call start " + callStart + " for  call " + call.prettyPrint() + " not found in model call intervals.");
            }
            int callStartIndex = (Integer)startBin.getValue();
            Map.Entry endBin = this.genomicToBinMap.floorEntry(callEnd);
            if (endBin == null) {
                throw new UserException.BadInput("Call end " + callEnd + " for call " + call.prettyPrint() + " not found in model call intervals.");
            }
            int callEndIndex = (Integer)endBin.getValue();
            int callBinLength = callEndIndex - callStartIndex + 1;
            if (callBinLength <= 0) {
                throw new UserException.BadInput("Copy number call at " + call.getContig() + ":" + call.getStart() + "-" + call.getEnd() + " does not align with supplied model calling intervals. Use the filtered intervals input from GermlineCNVCaller for this cohort/model.");
            }
            int paddedStartIndex = Math.max(callStartIndex - (int)Math.round((double)callBinLength * this.paddingFraction), 0);
            paddedCallStart = ((GenomeLoc)this.coverageIntervals.get(paddedStartIndex)).getContig().equals(callStart.getContig()) ? ((GenomeLoc)this.coverageIntervals.get(paddedStartIndex)).getStart() : callStart.getStart();
            int paddedEndIndex = Math.min(callEndIndex + (int)Math.round((double)callBinLength * this.paddingFraction), this.genomicToBinMap.size() - 1);
            paddedCallEnd = ((GenomeLoc)this.coverageIntervals.get(paddedEndIndex)).getContig().equals(callEnd.getContig()) ? ((GenomeLoc)this.coverageIntervals.get(paddedEndIndex)).getEnd() : callEnd.getEnd();
        } else {
            paddedCallStart = (int)((double)callInterval.getStart() - this.paddingFraction * (double)callInterval.getLengthOnReference());
            paddedCallEnd = (int)((double)callInterval.getEnd() + this.paddingFraction * (double)callInterval.getLengthOnReference());
        }
        int contigLength = this.dictionary.getSequence(call.getContig()).getSequenceLength();
        if (currentClusterInterval == null) {
            return IntervalUtils.trimIntervalToContig(call.getContig(), paddedCallStart, paddedCallEnd, contigLength);
        }
        int newMinStart = Math.min(paddedCallStart, currentClusterInterval.getStart());
        int newMaxEnd = Math.max(paddedCallEnd, currentClusterInterval.getEnd());
        return IntervalUtils.trimIntervalToContig(call.getContig(), newMinStart, newMaxEnd, contigLength);
    }

    @Override
    protected boolean itemsAreIdentical(SVCallRecordWithEvidence a, SVCallRecordWithEvidence b) {
        throw new GATKException.ShouldNeverReachHereException("Deduplication should not be called for single-linkage clustering in depth-only defragmentation.");
    }

    @Override
    protected SVCallRecordWithEvidence deduplicateIdenticalItems(Collection<SVCallRecordWithEvidence> items) {
        return null;
    }

    private SimpleInterval getCallInterval(SVCallRecordWithEvidence call) {
        return new SimpleInterval(call.getContig(), call.getStart(), call.getEnd());
    }

    public static boolean isDepthOnlyCall(SVCallRecord call) {
        if (call.getAlgorithms().isEmpty()) {
            return false;
        }
        for (String alg : call.getAlgorithms()) {
            if (alg.equals("depth")) continue;
            return false;
        }
        return true;
    }

    @VisibleForTesting
    public static double getDefaultPaddingFraction() {
        return 0.5;
    }
}

