/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.sv;

import htsjdk.tribble.Feature;
import java.util.Objects;
import org.broadinstitute.hellbender.utils.Utils;

public final class SplitReadEvidence
implements Feature {
    final String sample;
    final String contig;
    final int position;
    final int count;
    final boolean strand;

    public SplitReadEvidence(String sample, String contig, int position, int count, boolean strand) {
        Utils.nonNull(sample);
        Utils.nonNull(contig);
        this.sample = sample;
        this.contig = contig;
        this.position = position;
        this.count = count;
        this.strand = strand;
    }

    public String getSample() {
        return this.sample;
    }

    public String getContig() {
        return this.contig;
    }

    public int getStart() {
        return this.position;
    }

    public int getEnd() {
        return this.position;
    }

    public boolean getStrand() {
        return this.strand;
    }

    public int getCount() {
        return this.count;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SplitReadEvidence)) {
            return false;
        }
        SplitReadEvidence that = (SplitReadEvidence)o;
        return this.position == that.position && this.count == that.count && this.strand == that.strand && this.sample.equals(that.sample) && this.contig.equals(that.contig);
    }

    public int hashCode() {
        return Objects.hash(this.sample, this.contig, this.position, this.count, this.strand);
    }
}

