/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.sv;

import java.util.Map;
import java.util.Set;
import org.broadinstitute.hellbender.utils.Utils;

final class SplitReadSite {
    private final int position;
    private final Map<String, Integer> sampleCountsMap;

    public SplitReadSite(int position, Map<String, Integer> sampleCountsMap) {
        this.position = position;
        this.sampleCountsMap = sampleCountsMap;
    }

    public int getPosition() {
        return this.position;
    }

    public Map<String, Integer> getSampleCountsMap() {
        return this.sampleCountsMap;
    }

    public int getSampleCountSum(Set<String> samples) {
        return this.sampleCountsMap.entrySet().stream().filter(e -> samples.contains(e.getKey())).mapToInt(e -> (Integer)e.getValue()).sum();
    }

    public double getNormalizedCountSum(Map<String, Double> sampleCoverageMap) {
        Utils.validateArg(sampleCoverageMap.keySet().containsAll(this.sampleCountsMap.keySet()), "Coverage missing for one or more samples");
        return this.sampleCountsMap.entrySet().stream().mapToDouble(e -> (double)((Integer)e.getValue()).intValue() / (Double)sampleCoverageMap.get(e.getKey())).sum();
    }

    public double getNormalizedCountSum(Set<String> samples, Map<String, Double> sampleCoverageMap) {
        Utils.validateArg(sampleCoverageMap.keySet().containsAll(samples), "Coverage missing for one or more samples");
        return this.sampleCountsMap.entrySet().stream().filter(e -> samples.contains(e.getKey())).mapToDouble(e -> (double)((Integer)e.getValue()).intValue() / (Double)sampleCoverageMap.get(e.getKey())).sum();
    }

    public int getCountSum() {
        return this.sampleCountsMap.values().stream().mapToInt(Integer::intValue).sum();
    }
}

