/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.validation;

import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.SamReader;
import htsjdk.samtools.SamReaderFactory;
import htsjdk.samtools.SecondaryOrSupplementarySkippingIterator;
import htsjdk.samtools.util.CloseableIterator;
import htsjdk.samtools.util.CloserUtil;
import htsjdk.samtools.util.IOUtil;
import htsjdk.samtools.util.Locatable;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import org.broadinstitute.barclay.argparser.Advanced;
import org.broadinstitute.barclay.argparser.Argument;
import org.broadinstitute.barclay.argparser.CommandLineException;
import org.broadinstitute.barclay.argparser.CommandLineProgramProperties;
import org.broadinstitute.barclay.argparser.PositionalArguments;
import org.broadinstitute.barclay.help.DocumentedFeature;
import org.broadinstitute.hellbender.cmdline.PicardCommandLineProgram;
import org.broadinstitute.hellbender.engine.GATKPath;
import org.broadinstitute.hellbender.engine.ProgressMeter;
import org.broadinstitute.hellbender.exceptions.UserException;
import org.broadinstitute.hellbender.tools.validation.CompareMatrix;
import org.broadinstitute.hellbender.transformers.BQSRReadTransformer;
import picard.cmdline.programgroups.DiagnosticsAndQCProgramGroup;

@DocumentedFeature
@CommandLineProgramProperties(summary="Compares the base qualities of two SAM/BAM/CRAM files. The reads in the two files must have exactly the same names and appear in the same order.", oneLineSummary="Compares the base qualities of two SAM/BAM/CRAM files", programGroup=DiagnosticsAndQCProgramGroup.class)
public final class CompareBaseQualities
extends PicardCommandLineProgram {
    @PositionalArguments(minElements=2, maxElements=2)
    public List<GATKPath> samFiles;
    public static final String THROW_ON_DIFF_LONG_NAME = "throw-on-diff";
    public static final String STATIC_QUANTIZED_QUALS_LONG_NAME = "static-quantized-quals";
    public static final String ROUND_DOWN_QUANTIZED_LONG_NAME = "round-down-quantized";
    @Argument(doc="Summary output file.", shortName="O", fullName="output", optional=true)
    protected String outputFilename = null;
    @Argument(doc="Throw exception on difference.", fullName="throw-on-diff", optional=true)
    protected boolean throwOnDiff = false;
    @Advanced
    @Argument(doc="Use static quantized quality scores to a given number of levels (with --bqsr-recal-file)", fullName="static-quantized-quals", optional=true)
    public List<Integer> staticQuantizationQuals = new ArrayList<Integer>();
    @Advanced
    @Argument(doc="Round down quality scores to nearest quantized value.", fullName="round-down-quantized", optional=true)
    public boolean roundDown = false;
    private byte[] staticQuantizedMapping;

    @Override
    protected Object doWork() {
        if (this.roundDown && (this.staticQuantizationQuals == null || this.staticQuantizationQuals.isEmpty())) {
            throw new CommandLineException.BadArgumentValue(ROUND_DOWN_QUANTIZED_LONG_NAME, "true", "This option can only be used if static-quantized-quals is also used.");
        }
        this.staticQuantizedMapping = BQSRReadTransformer.constructStaticQuantizedMapping(this.staticQuantizationQuals, this.roundDown);
        IOUtil.assertFileIsReadable((Path)this.samFiles.get(0).toPath());
        IOUtil.assertFileIsReadable((Path)this.samFiles.get(1).toPath());
        SamReaderFactory factory = SamReaderFactory.makeDefault().validationStringency(this.VALIDATION_STRINGENCY);
        SamReader reader1 = factory.referenceSequence(this.REFERENCE_SEQUENCE).open(this.samFiles.get(0).toPath());
        SamReader reader2 = factory.referenceSequence(this.REFERENCE_SEQUENCE).open(this.samFiles.get(1).toPath());
        SecondaryOrSupplementarySkippingIterator it1 = new SecondaryOrSupplementarySkippingIterator((CloseableIterator)reader1.iterator());
        SecondaryOrSupplementarySkippingIterator it2 = new SecondaryOrSupplementarySkippingIterator((CloseableIterator)reader2.iterator());
        CompareMatrix finalMatrix = new CompareMatrix(this.staticQuantizedMapping);
        ProgressMeter progressMeter = new ProgressMeter(1.0);
        progressMeter.start();
        while (it1.hasCurrent() && it2.hasCurrent()) {
            SAMRecord read1 = it1.getCurrent();
            SAMRecord read2 = it2.getCurrent();
            progressMeter.update((Locatable)read1);
            if (!read1.getReadName().equals(read2.getReadName())) {
                throw new UserException.BadInput("files do not have the same exact order of reads:" + read1.getReadName() + " vs " + read2.getReadName());
            }
            finalMatrix.add(read1.getBaseQualities(), read2.getBaseQualities());
            it1.advance();
            it2.advance();
        }
        progressMeter.stop();
        if (it1.hasCurrent() || it2.hasCurrent()) {
            throw new UserException.BadInput("files do not have the same exact number of reads");
        }
        CloserUtil.close((Object)reader1);
        CloserUtil.close((Object)reader2);
        finalMatrix.printOutResults(this.outputFilename);
        if (this.throwOnDiff && finalMatrix.hasNonDiagonalElements()) {
            throw new UserException("Quality scores from the two BAMs do not match");
        }
        return finalMatrix.hasNonDiagonalElements() ? 1 : 0;
    }
}

