/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.validation;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.io.Serializable;
import org.broadinstitute.hellbender.exceptions.UserException;
import org.broadinstitute.hellbender.utils.MathUtils;
import org.broadinstitute.hellbender.utils.Utils;

public final class CompareMatrix
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final int dimension = 94;
    private final byte[] bin;
    private long[][] mat;
    private long[][] binnedMat;

    public CompareMatrix(byte[] binning) {
        Utils.nonNull(binning);
        this.bin = (byte[])binning.clone();
        this.mat = new long[94][94];
        this.binnedMat = new long[94][94];
    }

    public void add(byte[] first, byte[] second) {
        if (first.length != second.length) {
            throw new UserException("The length of the quality scores are not the same for read " + first.length + "," + second.length);
        }
        for (int i = 0; i < first.length; ++i) {
            long[] lArray = this.mat[first[i]];
            byte by = second[i];
            lArray[by] = lArray[by] + 1L;
            long[] lArray2 = this.binnedMat[this.bin[first[i]]];
            byte by2 = this.bin[second[i]];
            lArray2[by2] = lArray2[by2] + 1L;
        }
    }

    public CompareMatrix add(CompareMatrix c) {
        for (int i = 0; i < 94; ++i) {
            for (int j = 0; j < 94; ++j) {
                long[] lArray = this.mat[i];
                int n = j;
                lArray[n] = lArray[n] + c.mat[i][j];
                long[] lArray2 = this.binnedMat[i];
                int n2 = j;
                lArray2[n2] = lArray2[n2] + c.binnedMat[i][j];
            }
        }
        return this;
    }

    public boolean hasNonDiagonalElements() {
        for (int i = 0; i < 94; ++i) {
            for (int j = 0; j < 94; ++j) {
                if (i == j || this.mat[i][j] == 0L) continue;
                return true;
            }
        }
        return false;
    }

    private static void printSummary(PrintStream printStream, long[][] matrix, String name) {
        int totalSize = 187;
        long[] deltaColumns = new long[187];
        for (int i = 0; i < 94; ++i) {
            for (int j = 0; j < 94; ++j) {
                int n = 93 + i - j;
                deltaColumns[n] = deltaColumns[n] + matrix[i][j];
            }
        }
        printStream.println("-----------" + name + " summary------------");
        long columnsSum = MathUtils.sum(deltaColumns);
        if (columnsSum == deltaColumns[93]) {
            printStream.println("all " + columnsSum + " quality scores are the same");
        } else {
            printStream.println("diff\tcount\t%total");
            for (int k = 0; k < 187; ++k) {
                if (deltaColumns[k] == 0L) continue;
                printStream.println(String.format("%d\t%d\t%.4f", k - 93, deltaColumns[k], (double)deltaColumns[k] * 100.0 / (double)columnsSum));
            }
        }
    }

    private static void print(PrintStream printStream, long[][] matrix, String name) {
        printStream.println("---------" + name + " full matrix (non-zero entries) ----------");
        printStream.println("QRead1\tQRead2\tdiff\tcount");
        for (int i = 0; i < 94; ++i) {
            for (int j = 0; j < 94; ++j) {
                if (matrix[i][j] == 0L) continue;
                printStream.println(i + "\t" + j + "\t" + (i - j) + "\t" + matrix[i][j]);
            }
        }
    }

    public void printOutResults(String outputFilename) {
        block15: {
            if (outputFilename != null) {
                try (FileOutputStream os = new FileOutputStream(outputFilename);){
                    PrintStream ps = new PrintStream(os);
                    this.printOutput(ps);
                    break block15;
                }
                catch (IOException e) {
                    throw new UserException.CouldNotCreateOutputFile("unable to write to output file: " + outputFilename, (Exception)e);
                }
            }
            this.printOutput(System.out);
        }
    }

    private void printOutput(PrintStream ps) {
        CompareMatrix.printSummary(ps, this.mat, "CompareMatrix");
        ps.println();
        CompareMatrix.print(ps, this.mat, "CompareMatrix");
        CompareMatrix.printSummary(ps, this.binnedMat, "CompareMatrix-binned");
        ps.println();
        CompareMatrix.print(ps, this.binnedMat, "CompareMatrix-binned");
    }
}

